<?php
if( ! defined('ABSPATH') ){
    exit;
}
use WP_STATISTICS\Menus;
use WP_STATISTICS\Admin_Template;
use WP_Statistics\Utils\Request;
use WP_Statistics\Service\Admin\AuthorAnalytics\Views\AuthorsView;

class StreamTube_Core_WP_Statistics_AuthorsAnalytics_View extends AuthorsView{

    public function isLocked(){
        return false;
    }    

    public function renderContent(){
        $data = $this->getData();

        $args = [
            'title'       => esc_html__('Authors', 'wp-statistics'),
            'pageName'    => Menus::get_page_slug('author-analytics'),
            'DateRang'    => Admin_Template::DateRange(),
            'custom_get'  => [
                'type'      => 'authors',
                'pt'        => Request::get('pt'),
                'order_by'  => Request::get('order_by', 'total_views'),
                'order'     => Request::get('order', 'desc'),
            ],
            'hasDateRang' => true,
            'filters'     => array(),
            'backUrl'     => Menus::admin_url('author-analytics'),
            'backTitle'   => esc_html__('Authors Performance', 'wp-statistics'),
            'data'        => $data['authors'],
            'paged'       => Admin_Template::getCurrentPaged()
        ];

        if ($data['total'] > 0) {
            $args['total'] = $data['total'];

            $args['pagination'] = Admin_Template::paginate_links([
                'total' => $data['total'],
                'echo'  => false
            ]);
        }

        Admin_Template::get_template(
            [
                'layout/header', 
                'layout/title'
            ], 
            $args
        );

        load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH . '/public/components/post-types.php' );

        Admin_Template::get_template(
            [
                "pages/author-analytics/authors-report", 
                'layout/postbox.toggle', 
                'layout/footer'
            ], 
            $args
        );        
    }    
}