<?php
if( ! defined('ABSPATH') ){
    exit;
}

use WP_Statistics\Utils\Request;
use WP_STATISTICS\Admin_Template;
use WP_STATISTICS\Menus;
use WP_Statistics\Service\Admin\AuthorAnalytics\AuthorAnalyticsDataProvider;
use WP_Statistics\Service\Admin\AuthorAnalytics\Views\PerformanceView;


class StreamTube_Core_WP_Statistics_AuthorsPerformance_View extends PerformanceView{
    public function __construct(){

        $post_type = Request::get('pt') ?? '';

        $this->dataProvider = new AuthorAnalyticsDataProvider( compact( 'post_type' ) );
    }

    public function isLocked(){
        return false;
    }    

    public function renderContent(){
        $args = [
            'title'       => esc_html__('Author Analytics', 'wp-statistics'),
            'pageName'    => Menus::get_page_slug('author-analytics'),
            'paged'       => Admin_Template::getCurrentPaged(),
            'custom_get'  => ['pt' => Request::get('pt')],
            'DateRang'    => Admin_Template::DateRange(),
            'hasDateRang' => true,
            'filters'     => array(),
            'data'        => $this->getData()
        ];

        Admin_Template::get_template(
        	[
        		'layout/header', 
        		'layout/title', 
        	], 
        	$args
        );

        load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH . '/public/components/post-types.php' );

        Admin_Template::get_template(
        	[
        		"pages/author-analytics/authors-performance", 
        		'layout/postbox.hide', 
        		'layout/footer'
        	], 
        	$args
        );        
    }    
}