<?php
if( ! defined('ABSPATH') ){
	exit;
}

use WP_STATISTICS\Admin_Template;
use WP_Statistics\Service\Admin\Geographic\Views\TabsView;
use WP_Statistics\Service\Admin\Geographic\GeographicDataProvider;

class StreamTube_Core_WP_Statistics_Geographic_TabView extends TabsView{

	public function __construct(){
		parent::__construct();

        $this->dataProvider = new GeographicDataProvider([
            'per_page'  => Admin_Template::$item_per_page,
            'page'      => Admin_Template::getCurrentPaged(),
            'author_id'	=> ! $this->canViewAll() ? get_current_user_id() : '',
            'post_type'	=> array_keys( streamtube_core_get_statistics_post_types() )
        ]);		
	}

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }
}