<?php
if( ! defined('ABSPATH') ){
	exit;
}
use WP_Statistics\Exception;
use WP_STATISTICS\Option;
use WP_Statistics\Components\View;
use WP_STATISTICS\Menus;
use WP_Statistics\Utils\Request;
use WP_STATISTICS\Admin_Template;
use WP_Statistics\Service\Admin\PageInsights\Views\TabsView;
use WP_Statistics\Service\Admin\PageInsights\PageInsightsDataProvider;

class StreamTube_Core_WP_Statistics_Page_Insights_TabsView extends TabsView{
    public function __construct(){
        $args = [
            'order'     => Request::get('order', 'DESC'),
            'author_id' => Request::get('author_id', '', 'number'),
            'taxonomy'  => Request::get('tx', 'category'),
            'per_page'  => Admin_Template::$item_per_page,
            'page'      => Admin_Template::getCurrentPaged(),
        ];

        if( ! StreamTube_Core_WP_Statistics_Permission::view_all_statistics() ){
        	$args['author_id'] = get_current_user_id();	
        }        

        if ( Request::has('pt') ) {
            $args['post_type'] = Request::get('pt', 'post');
        }
        
        $this->dataProvider = new PageInsightsDataProvider($args);
    }

    public function isLocked(){
    	return false;
    }

    public function render(){
        try {

            $url = remove_query_arg( array_keys( $_REQUEST ), $_SERVER['REQUEST_URI'] );

            $currentTab = $this->getCurrentTab();

            $view_all_statistics = StreamTube_Core_WP_Statistics_Permission::view_all_statistics();

            if( $currentTab !== 'contents' && ! $view_all_statistics ){
                $currentTab = 'contents';
            }

            $template    = $currentTab;
            $data        = $this->getTabData();
            $queryParams = [
                'tab'       => $currentTab,
                'order_by'  => Request::get('order_by'),
                'order'     => Request::get('order')
            ];

            $filters = [];

            if ( $this->isTab('contents') ) {

            	if( $view_all_statistics ){
            		$filters = ['author'];	
            	}

                $queryParams['pt']          = Request::get('pt', '');
                $queryParams['author_id']   = Request::get('author_id', '', 'number');

                if( ! $view_all_statistics ){
                    $queryParams['author_id']   = get_current_user_id();
                }

            } elseif ( $this->isTab('category') ) {
                $queryParams['tx'] = Request::get('tx', 'category');
            }

            $args = [
                'title'         => esc_html__('Page Insights', 'wp-statistics'),
                'pageName'      => Menus::get_page_slug('pages'),
                'custom_get'    => $queryParams,
                'DateRang'      => Admin_Template::DateRange(),
                'hasDateRang'   => true,
                'showLockedPage'=> $this->isLocked(),
                'data'          => $data,
                'allTimeOption' => true,
                'filters'       => $filters,
                'pagination'    => Admin_Template::paginate_links([
                    'total' => isset($data['total']) ? $data['total'] : 0,
                    'echo'  => false
                ]),
                'tabs'          => [
                    [
                        'link'    => add_query_arg( array( 'tab' => 'contents' ), $url ),
                        'title'   => esc_html__('Contents', 'wp-statistics'),
                        'tooltip' => esc_html__('Shows visitor stats, views and word count for each content.', 'wp-statistics'),
                        'class'   => $this->isTab('contents') ? 'current' : '',
                    ]
                ]
            ];

            if( $view_all_statistics ){
            	$args['tabs'] = array_merge( $args['tabs'], array(
                    [
                        'link'    => add_query_arg( array( 'tab' => 'category' ), $url ),
                        'title'   => esc_html__('Category Pages', 'wp-statistics'),
                        'tooltip' => esc_html__('Shows the page views for category pages related to the selected taxonomy.', 'wp-statistics'),
                        'class'   => $this->isTab('category') ? 'current' : '',
                    ],
                    [
                        'link'    => add_query_arg( array( 'tab' => 'author' ), $url ),
                        'title'   => esc_html__('Author Pages', 'wp-statistics'),
                        'tooltip' => esc_html__('View performance metrics for individual authors\' pages.', 'wp-statistics'),
                        'class'   => $this->isTab('author') ? 'current' : '',
                    ],
                    [
                        'link'      => add_query_arg( array( 'tab' => '404' ), $url ),
                        'title'     => esc_html__('404 Pages', 'wp-statistics'),
                        'class'     => $this->isTab('404') ? 'current' : '',
                        'tooltip'   => esc_html__('View URLs that led visitors to 404 errors.', 'wp-statistics'),
                    ]
            	) );
            }

            Admin_Template::get_template( ['layout/header', 'layout/tabbed-page-header'], $args );

            if ( $this->isTab('contents') ) {
            	load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH . '/public/components/post-types.php' );
        	}

            if ( $this->isTab('category') && $view_all_statistics ) {
            	load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH . '/public/components/taxonomies.php' );
        	}        	

            View::load( "pages/page-insights/$template", $args );
            Admin_Template::get_template(['layout/postbox.hide', 'layout/footer'], $args);
        } catch (Exception $e) {
            Notice::renderNotice($e->getMessage(), $e->getCode(), 'error');
        }
    }    
}