<?php
/**
 * Define the DeviceUsageBreakdown functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

use WP_Statistics\Components\View;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\DeviceUsageBreakdown;

class StreamTube_Core_WP_Statistics_DeviceUsageBreakdown extends DeviceUsageBreakdown{

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }    

    public function getData(){
        $args = $this->getFilters();

        if( ! $this->canViewAll() ){
            $args = array_merge( $args, array(
                'post_type' =>  array_keys( streamtube_core_get_statistics_post_types() ),
                'author_id' =>  get_current_user_id()
            ) );
        }        

        $data = array_merge($this->dataProvider->getDeviceChartData($args), [
            'tag_id' => 'wps-device-usage-breakdown',
            'url'    => WP_STATISTICS_URL . 'assets/images/no-data/vector-4.svg'
        ]);

        $output = View::load('metabox/horizontal-bar', ['data' => $data], true);

        return [
            'output'    => $output,
            'data'      => $data
        ];
    }          
}

