<?php
/**
 * Define the MostActiveVisitors functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    return;
}

use WP_Statistics\Components\View;
use WP_STATISTICS\Menus;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\MostActiveVisitors;

class StreamTube_Core_WP_Statistics_MostActiveVisitors extends MostActiveVisitors{

    protected $visitorsModel;

    public function __construct(){
        $this->visitorsModel = new StreamTube_Core_WP_Statistics_VisitorsModel();
    }    

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }

    public function getOptions(){
        $tab = $this->canViewAll() ? 'top-visitors' : 'visitors';
        return [
            'datepicker'    => true,
            'button'        => View::load('metabox/action-button',[
                'link'  => Menus::admin_url( 'visitors', [ 'tab' => $tab ] ) ,
                'title' => esc_html__('View Most Active Visitors', 'wp-statistics')
            ],true)
        ];
    }    

    public function getData(){

        $args = array(
            'page_info' => true,
            'user_info' => true,
            'order_by'  => 'hits',
            'order'     => 'DESC',
            'per_page'  => 10,
            'page'      => 1
        );

        if( ! $this->canViewAll() ){
            $args = array_merge( $args, array(
                'page_info'     =>  false,
                'post_type'     =>  array_keys( streamtube_core_get_statistics_post_types() ),
                'resource_type' =>  streamtube_core_get_statistics_resource_types(),
                'author_id'     =>  get_current_user_id()
            ) );
        }

        $data   = $this->visitorsModel->getVisitorsData( $args );

        ob_start();

        load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH . '/public/metabox/most-active-visitors.php', true, ['data' => $data] );

        return ob_get_clean();
    }        
}