<?php
/**
 * Define the TopCountries functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

use WP_Statistics\Components\View;
use WP_Statistics\Models\VisitorsModel;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\TopCountries;

class StreamTube_Core_WP_Statistics_TopCountries extends TopCountries{

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }

    protected function getVisitorsModel(){
        return new VisitorsModel();
    }

    public function getData(){

        $args = array_merge( $this->getFilters(), array(
            'per_page'  => 10, 
            'not_null'  => 'location',
            'author_id' =>  ! $this->canViewAll() ? get_current_user_id() : ''
        ) );

        $data = $this->getVisitorsModel()->getVisitorsGeoData( $args );

        $output = View::load('metabox/top-countries', ['data' => $data, 'filters' => $args], true);

        return $output;
    }
 
}    