<?php
/**
 * Define the TopReferring functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}
use WP_Statistics\Components\View;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\TopReferring;

class StreamTube_Core_WP_Statistics_TopReferring extends TopReferring{

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }

    protected function getVisitorsModel(){
        return new StreamTube_Core_WP_Statistics_VisitorsModel();
    }

    public function getReferrersData($args = []){
        return $this->getVisitorsModel()->getReferrers( $args );
    }    

    public function getData(){
 
        $args = array_merge( $this->getFilters(), [
            'decorate'      => true,
            'per_page'      => 10,
            'page'          => 1
        ]);

        if( ! $this->canViewAll() ){
            $args = array_merge( $args, array(
                'author_id'     => get_current_user_id(),
                'post_type'     => array_keys( streamtube_core_get_statistics_post_types() ),
                'resource_type' => streamtube_core_get_statistics_resource_types()
            ) );
        }

        $data   = $this->getReferrersData($args);
        $output = View::load('metabox/top-referring', ['data' => $data, 'filters' => $args], true);

        return $output;
    }
}