<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

use WP_STATISTICS\Option;
use WP_Statistics\Decorators\UserDecorator;

$user = $args['user'];
?>

<?php /** @var UserDecorator $user */ ?>
<div class="wps-visitor__visitors-details">
    <div class="wps-visitor__visitors-detail--row">
        <span><?php esc_html_e('Username', 'wp-statistics'); ?></span>
        <div>
            <a href="<?php echo get_edit_user_link($user->getId()); ?>" class="wps-visitor__username text-body">
                <i class="icon-user text-body"></i>
                <?php echo sprintf('%s (#%s)', $user->getDisplayName(), $user->getId()); ?>
            </a>
        </div>
    </div>

    <?php if( current_user_can( Option::get('manage_capability') ) ) : ?>
	    <div class="wps-visitor__visitors-detail--row">
	        <span><?php esc_html_e('Email address', 'wp-statistics'); ?></span>
	        <div>
	            <a class="text-body" href="mailto:<?php echo esc_attr($user->getEmail()); ?>" title="<?php echo esc_attr($user->getEmail()); ?>">
	                <?php echo esc_html($user->getEmail()); ?>
	            </a>
	        </div>
	    </div>

	    <div class="wps-visitor__visitors-detail--row">
	        <span><?php esc_html_e('Last login', 'wp-statistics'); ?></span>
	        <div class="wps-ellipsis-parent">
	            <span><?php echo $user->getLastLogin() ? esc_html($user->getLastLogin()) : esc_html('-'); ?></span>
	        </div>
	    </div>

	    <div class="wps-visitor__visitors-detail--row">
	        <span><?php esc_html_e('Registered', 'wp-statistics'); ?></span>
	        <div class="wps-ellipsis-parent">
	            <span><?php echo esc_html($user->getRegisteredDate()); ?></span>
	        </div>
	    </div>

	    <div class="wps-visitor__visitors-detail--row">
	        <span><?php esc_html_e('Role', 'wp-statistics'); ?></span>
	        <div class="wps-ellipsis-parent">
	            <span class="c-capitalize"><?php echo esc_html($user->getRole()); ?></span>
	        </div>
	    </div>
	<?php endif;?>
</div>