<?php

if( ! defined( 'ABSPATH' ) ){
    exit;
}

$yt_importer    = streamtube_core()->get()->yt_importer;
$is_existed     = $yt_importer->is_existed( $yt_importer->api->search->get_item_id( $args ), $_POST['post_ID'] );

$importer_id    = $args['importer_id'];
$yt_id          = $yt_importer->api->search->get_item_id( $args );
$nonce          = wp_create_nonce( $yt_id . $importer_id );

?>
<?php printf(
    '<li class="d-flex border-bottom" data-importer-id="%s" data-item-id="%s">',
    esc_attr(  $_POST['post_ID'] ),
    esc_attr( $yt_importer->api->search->get_item_id( $args ) )
);?>
    
    <?php if( current_user_can( get_post_type_object( StreamTube_Core_Youtube_Importer_Post_Type::POST_TYPE )->cap->bulk_import ) ) : ?>

        <div class="yt-cb">
            <?php printf(
                '<input %1$s type="checkbox" name="yt_ids[]" value="%2$s" data-item-id="%2$s" data-importer-id="%3$s" data-nonce="%4$s">',
                $is_existed ? 'checked readonly disabled' : 'checked',
                esc_attr( $yt_id ),
                esc_attr( $importer_id ),
                esc_attr( $nonce )
            );?>
        </div>

    <?php endif;?>

    <div class="yt-thumbnail">
        <a target="_blank" href="<?php echo esc_url( $yt_importer->api->search->get_item_url( $args ) ); ?>">
            <?php printf(
                '<img class="img-thumbnail" src="%s">',
                $yt_importer->api->search->get_item_thumbnail_url( $args )
            );?>
        </a>
    </div>

    <div class="yt-content">
        <h3 class="yt-title">
            <?php printf(
                '<a target="_blank" href="%s">%s</a>',        
                esc_url( $yt_importer->api->search->get_item_url( $args ) ),
                $yt_importer->api->search->get_item_title( $args ),
            );?>
        </h3>

        <p class="yt-channel"><?php printf(
            esc_html__( 'By %s', 'streamtube-core' ),
            sprintf(
                '<a target="_blank" href="%s">%s</a>',
                esc_url( $yt_importer->api->search->get_item_channel_url( $args ) ),
                $yt_importer->api->search->get_item_channel_title( $args )
            )
        )?></p>

        <p class="yt-date">
            <?php printf(
                '%s (%s)',
                $yt_importer->api->search->get_item_published_at( $args ),
                sprintf(
                    esc_html__( '%s ago', 'streamtube-core' ),
                    human_time_diff( current_time( 'timestamp' ), strtotime( $yt_importer->api->search->get_item_published_at( $args ) ) )
                )
            ) ?>
        </p>

    </div>

    <div class="yt-button">
        <?php printf(
            '<button te="button" class="btn btn-sm button button-secondary button-yt-import %1$s" data-nonce="%2$s" data-importer-id="%3$s" data-item-id="%4$s" %5$s>',
            $is_existed ? 'disabled btn-success' : 'btn-outline-secondary',
            esc_attr( $nonce  ),
            esc_attr(  $importer_id ),
            esc_attr( $yt_id ),
            $is_existed ? 'readonly disabled' : '',
        );?>

            <span class="spinner"></span>

            <?php if( $is_existed ){
                esc_html_e( 'Imported', 'streamtube-core' );
            }else{
                esc_html_e( 'Import', 'streamtube-core' );
            }?>
        </button>               
    </div>     

</li>