<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

$post_id = is_object( $post ) ? $post->ID : 0;

$tax    = $args['tax'];
$object = get_taxonomy( $tax );

$max_items = (int) get_option( sprintf( 'taxonomy_%s_%s_max_items', 'video', $tax ), 0 );
if ( Streamtube_Core_Permission::moderate_posts( 0, 'video' ) ) {
	$max_items = 0;
}

/**
 * Fires before content
 *
 * @since 2.0
 */
do_action( 'streamtube/core/post/edit/tax/before', $object, $tax );

/**
 * @since 2.0
 */
do_action( "streamtube/core/post/edit/{$tax}/before" );

if ( is_taxonomy_hierarchical( $args['tax'] ) ) :
	?>
	<ul class="categorychecklist checklist" data-max-items="<?php echo esc_attr( $max_items ); ?>">
		<?php
		wp_terms_checklist( $post_id, array(
			'taxonomy'      => $args['tax'],
			'checked_ontop' => false
		) );
		?>
	</ul>
	<?php
else :

	$terms = wp_get_post_terms( $post_id, $args['tax'] );

	?>
	<?php printf(
		'<select name="tax_input[%s][]" class="select2 tax-select2 regular-text input-field w-100" multiple="multiple">',
		esc_attr( $args['tax'] )
	); ?>

	<?php if ( $terms ) {
		for ( $i = 0; $i < count( $terms ); $i++ ) {
			printf(
				'<option selected value="%s">%s</option>',
				$terms[ $i ]->slug,
				$terms[ $i ]->name
			);
		}
	} ?>

	</select>

	<script type="text/javascript">
		jQuery(function () {
			jQuery('.tax-select2').select2({
				tags: true,
				tokenSeparators: [',', ' '],
				allowClear: true,
				minimumInputLength: 1,
				maximumSelectionLength: <?php echo (int) esc_js( $max_items ) ?>,
				ajax: {
					url: '<?php echo esc_url( admin_url( 'admin-ajax.php' ) ) ?>',
					delay: 250,
					dataType: 'json',
					data: function (params) {
						var query = {
							search: params.term,
							action: "get_yt_importer_tax_terms",
							tax: "<?php echo $args['tax'] ?>",
							_wpnonce: "<?php echo wp_create_nonce( '_wpnonce' ); ?>"
						}
						return query;
					},
					processResults: function (data, params) {
						params.page = params.page || 1;
						return {
							results: data.data.results
						};
					}
				}
			});
		});
	</script>
	<?php

endif;

/**
 * Fires before content
 *
 * @since 2.0
 */
do_action( 'streamtube/core/post/edit/tax/after', $object, $tax );

/**
 * @since 2.0
 */
do_action( "streamtube/core/post/edit/{$tax}/after" );
?>