<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$output = '';

global $post;

$importer = streamtube_core()->get()->yt_importer;

$settings = $importer->admin->get_settings( $post->ID );

$post_type_object = get_post_type_object( $post->post_type );

$can_admin = current_user_can( 'manage_options' );
?>

<?php printf(
	'<table class="%s wp-list-table">',
	is_admin() ? 'form-table' : 'table'
); ?>

<tbody>

	<?php ob_start(); ?>

	<?php if ( $can_admin || current_user_can( $post_type_object->cap->import_to_others_cpts ) ) : ?>
		<tr>
			<th scope="row">
				<label for="post_type">
					<?php esc_html_e( 'Post Type', 'streamtube-core' ); ?>
				</label>
			</th>

			<td>
				<select name="yt_importer[post_type]" id="post_type" class="regular-text w-100 form-control">

					<?php foreach ( $importer->options->get_post_types() as $key => $value ) {

						if ( $key !== StreamTube_Core_Youtube_Importer_Post_Type::POST_TYPE )

							if ( is_post_type_viewable( $key ) ) {
								printf(
									'<option %s value="%s">%s</option>',
									selected( $key, $settings['post_type'], false ),
									esc_attr( $key ),
									esc_html( get_post_type_object( $key )->labels->name )
								);
							}
					} ?>

				</select>
			</td>
		</tr>


		<tr>
			<th scope="row">
				<label for="post_meta_field">
					<?php esc_html_e( 'Meta Field', 'streamtube-core' ); ?>
				</label>
			</th>

			<td>
				<?php printf(
					'<input type="text" name="yt_importer[post_meta_field]" id="post_meta_field" class="regular-text w-100 form-control" value="%s">',
					esc_attr( sanitize_key( $settings['post_meta_field'] ) )
				); ?>

				<p>
					<?php
					esc_html_e( 'Videos will be imported into the post content if no post meta field is specified', 'streamtube-core' )
						?>
				</p>
			</td>
		</tr>

	<?php endif; ?>

	<?php if ( $can_admin || current_user_can( $post_type_object->cap->edit_others_posts ) ) : ?>
		<tr>
			<th scope="row">
				<label for="post_status">
					<?php esc_html_e( 'Post Status', 'streamtube-core' ); ?>
				</label>
			</th>

			<td>
				<select name="yt_importer[post_status]" id="post_status" class="regular-text w-100 form-control">

					<?php foreach ( $importer->options->get_post_statuses() as $key => $value ) {
						printf(
							'<option %s value="%s">%s</option>',
							selected( $key, $settings['post_status'], false ),
							esc_attr( $key ),
							esc_html( $value )
						);
					} ?>

				</select>
			</td>
		</tr>
	<?php endif; ?>

	<?php if ( $can_admin || current_user_can( $post_type_object->cap->import_to_others_authors ) ) : ?>
		<tr>
			<th scope="row">
				<label for="post_author">
					<?php esc_html_e( 'Post Author', 'streamtube-core' ); ?>
				</label>
			</th>

			<td>
				<?php wp_dropdown_users( array(
					'role__not_in'      => array(
						'subscriber'
					),
					'class'             => 'regular-text',
					'name'              => 'yt_importer[post_author]',
					'selected'          => $settings['post_author'],
					'class'             => 'regular-text w-100 form-control',
					'show_option_none'  => esc_html__( 'None', 'streamtube-core' ),
					'option_none_value' => 0
				) ); ?>
			</td>
		</tr>
	<?php endif; ?>

	<?php if ( $can_admin || current_user_can( $post_type_object->cap->import_tags ) ) : ?>
		<tr>
			<th scope="row">
				<label for="post_tags">
					<?php esc_html_e( 'Import Tags', 'streamtube-core' ); ?>
				</label>
			</th>

			<td>
				<?php printf(
					'<input type="checkbox" name="yt_importer[post_tags]" %s>',
					checked( $settings['post_tags'], 'on', false )
				); ?>
			</td>
		</tr>
	<?php endif; ?>

	<?php
	$output = trim( ob_get_clean() );

	if ( $output ) {
		echo $output;
	} else {
		?>
		<tr>
			<td colspan="2">
				<p class="text-muted m-0">
					<?php esc_html_e( 'This setting is restricted.', 'steamtube-core' ); ?>
				</p>
			</td>
		</tr>
		<?php
	}
	?>
</tbody>

</table>