(function( $ ) {
	'use strict';

	$(document).ready(function() {
	    // Initialize on page load
	    toggleRowsBasedOnCheckbox();

	    // Handle change event
	    $(document).on('change', 'input#forMine', function(e) {
	        toggleRowsBasedOnCheckbox();
	    });

	    // Function to toggle rows based on checkbox status
	    function toggleRowsBasedOnCheckbox() {
	        let input = $('input#forMine');
	        let isChecked = input.is(':checked');
	        let videoAttributes = [
	            "type",
	            "videoDefinition",
	            "videoDimension",
	            "videoDuration",
	            "videoEmbeddable",
	            "videoLicense",
	            "videoPaidProductPlacement",
	            "videoSyndicated",
	            "videoType"
	        ];
	        let table = $('table#yt-settings-table');

	        if (isChecked === true) {
	            // Hide the rows when the checkbox is checked
	            for (let i = 0; i < videoAttributes.length; i++) {
	                table.find('tr#row-' + videoAttributes[i]).addClass('d-none');
	            }
	        } else {
	            // Show the rows when the checkbox is unchecked
	            for (let i = 0; i < videoAttributes.length; i++) {
	                table.find('tr#row-' + videoAttributes[i]).removeClass('d-none');
	            }
	        }
	    }
	
		$( document ).on( 'click', '.button-search-youtube', function(e){
			var button 		= $(this);
			var isLoadMore 	= button.hasClass( 'button-yt-next-page' ) ? true : false;
			var form 		= button.closest( 'form' );
			var formData 	= new FormData(form[0]);
			formData.append( 'action', 'youtube_search' );

			if( isLoadMore ){
				formData.append( 'next_page_token', button.attr( 'data-next-page-token' ) );
			}

			var jqxhr = $.ajax({
				url 			: streamtube.ajax_url,
				data 			: formData,
				processData 	: false,
				contentType 	: false,
				type 			: 'POST',
				beforeSend: function( jqXHR ) {
	                button.addClass('disabled').attr('disabled', 'disabled');

		        	if( ! isLoadMore ){
		        		$( '#yt-search-results-container' ).html('');
		        	}
				}
			})

			.fail( function( jqXHR, textStatus, errorThrown ){
				alert( errorThrown );
			})

			.done( function( response, textStatus, jqXHR ){
				if( response.success == true ){
		        	if( isLoadMore ){
		        		$( '#yt-search-results-container' ).append( response.data );

		        		button.remove();
		        	}else{
		        		$( '#yt-search-results-container' ).html( response.data );
		        	}
	        	}else{
	        		$( '#yt-search-results-container' ).html( '<p class="api-error">'+ response.data[0].message +'</p>' );
	        	}
			})

			.always( function( jqXHR, textStatus ){
				button.removeClass('disabled').removeAttr('disabled');
			});
		});

		$( document ).on( 'click', 'button.button-yt-import', function( e ) {
			var button 		= $(this);
			var itemId 		= button.attr( 'data-item-id' );
			var importerId 	= button.attr( 'data-importer-id' );
			var nonce   	= button.attr( 'data-nonce' );

			var formData 	= new FormData();

			formData.append( 'action', 			'youtube_import' );
			formData.append( 'item_id', 		itemId );
			formData.append( 'importer_id', 	importerId );
			formData.append( 'nonce', 			nonce );

			var jqxhr = $.ajax({
				url 			: streamtube.ajax_url,
				data 			: formData,
				processData 	: false,
				contentType 	: false,
				type 			: 'POST',
				beforeSend: function( jqXHR ) {
	                button
	                .addClass('disabled')
	                .attr('disabled', 'disabled')
	                .find( '.spinner' ).addClass( 'is-active' );
				}
			})

			.fail( function( jqXHR, textStatus, errorThrown ){
				//alert( errorThrown );
				
				if( youtube_importer.is_admin ){
					alert( errorThrown );
				}else{
					$.showToast( errorThrown, 'danger' );
				}

				button
				.removeClass('disabled')
				.removeAttr('disabled')
				.find( 'spinner' ).removeClass( 'is-active' );
			})

			.done( function( response, textStatus, jqXHR ){
				if( response.success == false ){
					if( youtube_importer.is_admin ){
						alert( response.data[0].message );
					}else{
						$.showToast( response.data, 'danger' );
					}
					
					button
					.removeClass('disabled')
					.removeAttr('disabled')
					.find( '.spinner' ).removeClass( 'is-active' );
				}else{

					button.removeClass( 'btn-outline-secondary' ).addClass( 'btn-success' );

					if( response.data.posts ){
						var posts = $.map( response.data.posts, function(element,index) {return index});

						for ( var i = 0; i < posts.length; i ++ ) {
							$( '#yt-search-results-container ul' )
							.find( 'input[data-item-id="'+posts[i]+'"]' )
							.prop( 'checked', true )
							.addClass('disabled').attr('disabled', 'disabled')
							.attr( 'readonly', 'readonly' );

							$( '#yt-search-results-container ul' )
							.find( 'button[data-item-id="'+posts[i]+'"]' )
							.addClass('disabled').attr('disabled', 'disabled')
							.attr( 'readonly', 'readonly' )
							.html( response.data.message );
						}
					}
				}
			})

			.always( function( jqXHR, textStatus ){
				button.removeClass('running');
			});		
		});

		$( document ).on( 'click', 'button.button-imported-checked-item', function( e ) {
			var button 			= $(this);
			var form 			= button.closest( 'form' );
			var formData 		= new FormData(form[0]);
			var searchWrapper	=	$( '#yt-search-results' );

			if( confirm( streamtube.confirm_import_yt ) !== true ){
				return false;
			}

			formData.append( 'action', 'youtube_bulk_import' );
			formData.append( 'nonce', button.attr( 'data-nonce' ) );

			var jqxhr = $.ajax({
				url 			: streamtube.ajax_url,
				data 			: formData,
				processData 	: false,
				contentType 	: false,
				type 			: 'POST',
				beforeSend: function( jqXHR ) {
	                button.addClass('disabled').attr('disabled', 'disabled');
	                searchWrapper.addClass( 'searching' );
	                searchWrapper.find( '.notice' ).remove();
				}
			})

			.fail( function( jqXHR, textStatus, errorThrown ){
				searchWrapper.prepend( errorThrown );
			})

			.done( function( response, textStatus, jqXHR ){
				if( response.success == false ){
					searchWrapper.prepend( '<div class="notice notice-warning"><p>'+ response.data[0].message +'</p></div>' );
					button.removeClass('disabled').removeAttr('disabled');
				}else{

					if( response.data.posts ){
						var posts = $.map( response.data.posts, function(element,index) {return index});

						for ( var i = 0; i < posts.length; i ++ ) {
							$( '#yt-search-results-container ul' )
							.find( 'input[data-item-id="'+posts[i]+'"]' )
							.prop( 'checked', true )
							.addClass('disabled').attr('disabled', 'disabled')
							.attr( 'readonly', 'readonly' );

							$( '#yt-search-results-container ul' )
							.find( 'button[data-item-id="'+posts[i]+'"]' )
							.addClass('disabled').attr('disabled', 'disabled')
							.attr( 'readonly', 'readonly' )
							.html( response.data.message );
						}

						var text = streamtube.number_posts_imported;

						searchWrapper.prepend( '<div class="notice notice-success"><p>'+ text.replace( '%s', posts.length ) +'</p></div>' );
					}
				}
			})

			.always( function( jqXHR, textStatus ){
				button.removeClass('disabled').removeAttr('disabled');
				searchWrapper.removeClass( 'searching' );
			});		
		});	

		$( document ).on( 'click', 'button.button-check-all', function(e){
			$( '#yt-search-results-container li input[type=checkbox]' ).each( function( key, value ){
				if( ! $(this).attr( 'disabled' ) ){
					$(this).prop( 'checked', true );	
				}
			} );
		});	

		$( document ).on( 'click', 'button.button-uncheck-all', function(e){
			$( '#yt-search-results-container li input[type=checkbox]' ).each( function( key, value ){
				if( ! $(this).attr( 'disabled' ) ){
					$(this).prop( 'checked', false );	
				}
			} );
		});

		$( document ).on( 'click', 'button.button-yt-bulk-import', function(e){
			var button 			= $(this);
			var importerId 		= button.attr( 'data-importer-id' );
			var key 			= button.attr( 'data-key' );
			var nonce 			= button.attr( 'data-nonce' );

			var formData 		= new FormData();

			formData.append( 'importer_id', 	importerId );
			formData.append( 'key', 			key );
			formData.append( 'nonce', 			nonce );
			formData.append( 'action', 			'youtube_cron_bulk_import' );

			var jqxhr = $.ajax({
				url 			: streamtube.ajax_url,
				data 			: formData,
				processData 	: false,
				contentType 	: false,
				type 			: 'POST',
				beforeSend: function( jqXHR ) {
	                button.addClass('disabled').attr('disabled', 'disabled').html( button.attr( 'data-text-running' ) );
	                button.next().remove();
				}
			})

			.fail( function( jqXHR, textStatus, errorThrown ){
				alert( errorThrown )
			})

			.done( function( response, textStatus, jqXHR ){
				if( response.success == false ){
					button.after( '<p class="text-danger">'+ response.data[0].message +'</p>' );
				}else{
					button.after( '<p class="text-success">'+ response.data.message +'</p>' );
					button
					.closest( '#the-list' )
					.find( 'td.last_run' )
					.html( '<span class="text-success">'+ response.data.last_check +'</span>' );
				}
			})

			.always( function( jqXHR, textStatus ){
				button.removeClass('disabled').removeAttr('disabled').html( button.attr( 'data-text-run' ) );
			});
		});

	});

})( jQuery );	