<?php
/**
 *
 * Theme update template
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      1.0.0
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if( ! defined( 'ABSPATH' ) ){
	exit;
}

do_action( 'streamtube/verify_license_before' );

$is_verified 	= StreamTube_Theme_License()->is_verified();
$purchases 		= StreamTube_Theme_License()->_get_purchases();
?>
<div class="wrap">
	
	<div class="license-verification">

		<h1>
			<?php esc_html_e( 'Verify License', 'streamtube' ); ?>
			<?php if( $is_verified ): ?>
				<span class="bg-success text-white">
					<?php esc_html_e( 'Verified.', 'streamtube' );?>
				</span>
			<?php endif;?>			
		</h1>

		<?php
		do_action( 'streamtube/verify_license_screen' );
		?>

		<?php
		do_action( 'license_verification' );
		?>

		<?php if( StreamTube_Theme_License()->did_oauth_request() && ! $purchases ){
			printf(
			'<div class="notice notice-error is-dismissible"><p>%s</p></div>',
			esc_html__( 'You have not purchased any StreamTube licenses yet.', 'streamtube' )
			);
		}?>

		<?php printf(
			'<form method="post" id="verify-license-form" class="verify-license-form %s">',
			$is_verified ? 'verified' : ''
		);?>

			<table class="form-table">
				<tbody>
					<?php printf( '<tr class="%s">', $purchases ? 'd-none' : '' ); ?>
						<td>	
							<label><?php esc_html_e( 'Access Token', 'streamtube' );?></label>
							<p>
							<?php printf(
								'<input name="access_token" type="text" id="access_token" value="%s" class="regular-text">',
								esc_attr( get_option( 'access_token' ) )
							);?>
							</p>
							<p class="description">
								<?php printf(
									'<a target="_blank" href="https://build.envato.com/create-token/">%s</a>',
									esc_html__( 'Create your personal access token key', 'streamtube' )
								);?>
							</p>
						</td>
					</tr>

					<tr>
						<td>	

							<?php if( $purchases ) :?>

								<ul class="purchases-list">
									
									<?php foreach ( $purchases as $purchase => $item ): ?>
										
										<li>
											<label>
												<?php printf(
													'<input type="radio" name="purchase_code" value="%s" %s />',
													esc_attr( $purchase ),
													checked( $purchase, StreamTube_Theme_License()->get_purchase_code(), false )
												); ?>

												<div class="purchase-item">

													<?php printf(
														'<h3>%s</h3>',
														$item['name']
													); ?>

													<?php printf(
														'<p>%s</p>',
														$purchase
													); ?>

													<p>
														<?php printf(
															esc_html__( 'Purchased: %s ago', 'streamtube' ),
															human_time_diff( strtotime( $item['sold_at'] ), current_time( 'U' ) )
														); ?>
													</p>

													<p>
														<?php 

														$support_date = strtotime( $item['supported_until'] );

														printf(
															esc_html__( 'Support until:  %s %s', 'streamtube' ),
															date_i18n( 'Y-m-d H:i:s', $support_date ),
															$support_date < current_time( 'timestamp' ) ? '<span class="badge bg-danger">'. esc_html__( 'Expired', 'streamtube' ) .'</span>' : ''
														); ?>
													</p>

												</div>												
											</label>
										</li>

									<?php endforeach ?>

								</ul>

								<?php if( ! $is_verified ): ?>
									<p>
										<?php esc_html_e( 'Awesome! Choose a purchase and click the "Verify" button to validate your license.', 'streamtube' );?>
									</p>
								<?php endif;?>

							<?php else:?>

								<label><?php esc_html_e( 'Purchase code', 'streamtube' );?></label>

								<p>
								<?php printf(
									'<input name="purchase_code" type="text" id="purchase_code" value="%s" class="regular-text">',
									esc_attr( StreamTube_Theme_License()->get_purchase_code() )
								);?>
								</p>

							<?php endif;?>
						</td>
					</tr>

				</tbody>
			</table>

			<input type="hidden" name="page" value="license-verification">

			<input type="hidden" name="action" value="streamtube/license/verify">

			<?php wp_nonce_field( 'verify_license' );?>

			<p class="submit">

				<?php printf(
					'<button type="button" name="button-verify" class="button button-primary button-large">%s</button>',
					esc_html__( 'Verify', 'streamtube' )
				);?>

				<?php printf(
					'<button type="button" name="button-check-update" class="button button-primary button-large button-update">%s</button>',
					esc_html__( 'Check Update', 'streamtube' )
				);?>				

				<?php printf(
					'<a class="button button-primary button-large" href="%s">%s</a>',
					esc_url( StreamTube_Theme_License()->get_oauth_url() ),
					esc_html__( 'Authenticate with Your Envato Account', 'streamtube' )
				);?>

				<?php printf(
					'<button type="submit" name="button-deregister" class="button-deregister button button-secondary button-large">%s</button>',
					esc_html__( 'Deregister', 'streamtube' )
				)?>

			</p>

<pre>
/**
 * OPTIONAL
 * - Define your app to authenticate using your own credentials.
 * - Register your app at: https://build.envato.com/register/
 * - Add the definition to wp-config.php, before the line: "That's all, stop editing! Happy publishing."
 */
define( 'ENVATO_CLIENT_ID', 'Your Envato App Client ID' );
define( 'ENVATO_CLIENT_SECRET', 'Your Envato App Client Secret' );
define( 'ENVATO_REDIRECT_URI', '<?php echo admin_url( 'themes.php?page=license-verification' )?>' );				
</pre>

			<p class="documentation">
				<?php printf(
					'<a target="_blank" href="https://streamtube.marstheme.com/documentation/#verify-purchase">%s</a>',
					esc_html__( 'How to verfy purchase?', 'streamtube' )
				)?>
			</p>

			<div class="spinner-wrap">
				<span class="spinner is-active"></span>
			</div>
		</form>
	</div>
</div>

<?php

do_action( 'streamtube/verify_license_after' );