<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$has_sidebar = streamtube_woo_has_sidebar();
?>
<div class="row">
    <?php printf(
        '<div class="col-xl-%1$s col-lg-%1$s col-md-12 col-12">',
        $has_sidebar ? '8' : '12'
    );?>
		<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
			<div class="row">

				<?php printf(
					'<div class="col-12 col-sm-%1$s col-md-%2$s col-lg-%3$s">',
					12,
					12,
					8
				);?>
					<div class="product-img-wrap">
						<?php
						/**
						 * Hook: woocommerce_before_single_product_summary.
						 *
						 * @hooked woocommerce_show_product_sale_flash - 10
						 * @hooked woocommerce_show_product_images - 20
						 */
						do_action( 'woocommerce_before_single_product_summary' );
						?>
					</div>
				</div>

				<?php printf(
					'<div class="col-12 col-sm-%1$s col-md-%2$s col-lg-%3$s">',
					12,
					12,
					4
				)?>
					<div class="summary entry-summary bg-white shadow-sm p-4">
						<?php
						/**
						 * Hook: woocommerce_single_product_summary.
						 *
						 * @hooked woocommerce_template_single_title - 5
						 * @hooked woocommerce_template_single_rating - 10
						 * @hooked woocommerce_template_single_price - 10
						 * @hooked woocommerce_template_single_excerpt - 20
						 * @hooked woocommerce_template_single_add_to_cart - 30
						 * @hooked woocommerce_template_single_meta - 40
						 * @hooked woocommerce_template_single_sharing - 50
						 * @hooked WC_Structured_Data::generate_product_data() - 60
						 */
						
						do_action( 'woocommerce_single_product_summary' );
						?>
					</div>
				</div>
			</div>
			<?php
			/**
			 * Hook: woocommerce_after_single_product_summary.
			 *
			 * @hooked woocommerce_output_product_data_tabs - 10
			 * @hooked woocommerce_upsell_display - 15
			 * @hooked woocommerce_output_related_products - 20
			 */
			do_action( 'woocommerce_after_single_product_summary' );
			?>
		</div>
	</div>

    <?php if( $has_sidebar ): ?>
        <div class="col-xl-4 col-lg-4 col-md-12 col-12">
            <?php get_sidebar( 'woocommerce' );?>
        </div>
    <?php endif;?>

</div>