/**
 * Scripts for both frontend and backend sides
 */
(function( $ ) {
	'use strict';

	/**
	 *
	 * @since  1.0.0
	 * 
	 */
	$( document ).on( 'click', 'button.button-cloudflare-sync', function(e){
		e.preventDefault();

		var button 			= $(this);
		var attachmentId 	= button.attr( 'data-attachment-id' );

		$.ajax( {
			url 		: 	wp_cloudflare_stream.ajax_url,
			method 		: 	'POST',
			beforeSend: function ( xhr ) {
				button.attr( 'disabled', 'disabled' );

				button.next( '.alert' ).remove();
			},
			data:{
				'action' 		: 'sync_cloudflare_upload',
				'attachment_id' : attachmentId,
				'nonce' 		: button.attr( 'data-nonce' )
			}
		} ).done( function ( response ) {
			button.removeAttr( 'disabled' )

			if( ! response.success ){
				if( streamtube.is_admin ){
					alert( response.data[0].message );
				}else{
					$.showToast( response.data, 'danger' );
				}
			}else{
				button.html( response.data.message );
			}
		} );
	});	

    $( document ).on( 'submit', 'form#import-cloudflare-all-videos', function(e) {
        e.preventDefault();

        var form        = $(this);
        var button      = form.find('button[type=submit]');
        var progress    = form.find( '.progress-wrap' );
        var list        = form.find( '#cloudflare-imported-list' );
        var formData    = new FormData(form[0]);

        if( formData.get('confirm') == 'on' && ! confirm( formData.get( 'confirm_msg' ).replace(/\\n/g, '\n') ) ){
            return false;
        }

        $.ajax({
            url: streamtube.ajax_url,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function(xhr) {
                button.attr('disabled', 'disabled').addClass( 'd-none' );
				progress.removeClass( 'd-none' );
            },
            success: function(response) {

                form.find( 'input[name=confirm]' ).val( 'off' );

                var storedData          = sessionStorage.getItem('cloudflare_items');

                storedData              = storedData ? JSON.parse(storedData) : [];

                var totalItems          = storedData.length;
                var storedtotalItems    = sessionStorage.getItem( 'cloudflare_total_items' );

                if (response.success === true) {
                    var data            = response.data;
                    var didAction       = data.did_action;

                    if( didAction == 'fetched' ){

                    	if( data.result.videos.length === 0 ){
                    		return progress.addClass( 'd-none' );
                    	}

                        var totalItems      = parseInt( data.result.total );
                        var itemsPerPage    = parseInt( data.result.range );

                        // Add new items if they exist
                        if ( data.result.videos ) {
                            storedData = storedData.concat(data.result.videos);
                            sessionStorage.setItem('cloudflare_items', JSON.stringify(storedData));
                        }              

                        storedData = storedData.reduce((acc, current) => {
                            if ( ! acc.some(item => item.uid === current.uid)) {
                                acc.push(current);
                            }
                            return acc;
                        }, []);

                        sessionStorage.setItem( 'cloudflare_total_items', storedData.length );
                        var entry = storedData.shift();
                        sessionStorage.setItem('cloudflare_items', JSON.stringify(storedData));
                        form.find( 'input[name=uid]' ).val( entry.uid );
                        form.trigger( 'submit' );

                        progress
                        .find( '.progress-bar' ).addClass( 'bg-success rounded' )
                        .html( '<span class="text-black" style="padding: 0 1rem;">'+ streamtube.preparing +'</span>' );

                    }else{

                        if( storedData.length > 0 ){
                            var entry = storedData.shift();
                            sessionStorage.setItem('cloudflare_items', JSON.stringify(storedData));
                            form.find( 'input[name=uid]' ).val( entry.uid );
                            form.trigger( 'submit' );
                        }

                        if( list.hasClass( 'd-none' ) ){
                            list.removeClass( 'd-none' );
                        }

                        list.append( '<li><a target="_blank" href="'+ response.data.post.url +'">'+ response.data.post.url +'</a></li>' );

                        var percentCompleted    = Math.ceil( ( storedtotalItems - totalItems ) * 100 / storedtotalItems );
                        var progressText        = percentCompleted != 100 ? percentCompleted + '%' : streamtube.done;

                        progress
                        .find( '.progress-bar' )
                        .css( 'width', percentCompleted + '%' )
                        .text( progressText );
                    }           
                }

                if ( response.success === false ) {
                    button.removeAttr('disabled').removeClass( 'd-none' );

                    var percentCompleted    = Math.ceil( ( storedtotalItems - totalItems ) * 100 / storedtotalItems );
                    var progressText        = percentCompleted != 100 ? percentCompleted + '%' : streamtube.done;

                    progress
                    .find( '.progress-bar' )
                    .css( 'width', percentCompleted + '%' )
                    .text( progressText );

                    list.removeClass( 'd-none' ).append( '<li><span class="text-danger">'+ response.data[0].message +'</span></li>' );

                    if( storedData.length > 0 ){
                        var entry = storedData.shift();
                        sessionStorage.setItem('cloudflare_items', JSON.stringify(storedData));
                        form.find( 'input[name=uid]' ).val( entry.uid );
                        form.trigger( 'submit' );
                    }                   
                } 
            }
        });
    }); 


	$( document.body ).on( 'delete_cloudflare_video', function( event, response, textStatus, jqXHR, element ){

		if( response.success == false ){
			$.showToast( response.data, 'danger' );	
		}else{
			element.closest( 'tr' ).remove();
		}
		
	} );

	$( document.body ).on( 'import_cloudflare_stream_video', function( event, response, textStatus, jqXHR, element ){
		if( response.success == true ){
			element.replaceWith( '<span class="badge bg-success"><a class="text-white" target="_blank" href="'+response.data.uid+'">'+wp_cloudflare_stream.imported+'</a></span>' );
		}else{
			$.showToast( response.data );
		}
	} );

	/**
	 *
	 * Fires after live stream created
	 * 
	 */
	$( document.body ).on( 'live_stream', function( event, response, textStatus, jqXHR, formData, form ){

		let liveStream = response.data.live_stream;

		streamTubeUploadedVideoHandler( event, response, textStatus, jqXHR, formData, form );

		form.closest( '.modal-content' ).find( 'button[type=submit]' )
		.removeClass( 'disabled' )
		.removeAttr( 'disabled' )
		.find( '.spinner-border' ).remove();

		if( response.success == false ){
			return $.showToast( response.data, 'danger' );	
		}

		form.find( '.label-upload-img' ).remove();
		form.closest( '.modal' ).find( '.modal-footer' ).remove();	

		let rtmps = '<div class="mt-4">';

			rtmps += '<div class="mb-4 field-group field-rtmp-url form-floating position-relative">';
				rtmps += '<input readonly class="form-control" type="text" value="'+ liveStream.rtmps.url +'">'
				rtmps += '<label class="field-label">'+ wp_cloudflare_stream.rtmps.url +'</label>';
			rtmps += '</div>';

			rtmps += '<div class="mb-4 field-group field-rtmp-streamkey form-floating position-relative">';
				rtmps += '<input readonly class="form-control" type="text" value="'+ liveStream.rtmps.streamKey +'">'
				rtmps += '<label class="field-label">'+ wp_cloudflare_stream.rtmps.streamkey +'</label>';
			rtmps += '</div>';		

		rtmps += '</div>';		

		form.find( '.post-meta' ).after(rtmps);

	});

})( jQuery );		