(function($) {
    'use strict';

    function importUid(file, uid, status, form) {
        $.ajax({
            url: streamtube.rest_url + '/cloudflare/import',
            type: 'POST',
            data: {
                name: file.name,
                type: file.type,
                uid: uid,
                status: status
            },
            beforeSend: function(jqXHR) {
                jqXHR.setRequestHeader('X-WP-Nonce', streamtube.nonce);
            },
            success: function(data, textStatus, jqXHR) {
                $(document.body).trigger('upload_video', [data, textStatus, jqXHR, file, form]);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                $.showToast(textStatus, 'danger');
            }
        });
    }

    function directUpload(uploadUrl, uid, file, progress, form = null) {

        var formData = new FormData();
        formData.append('file', file);

        $.ajax({
            url: uploadUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            xhr: function() {
                var jqXHR = new XMLHttpRequest();

                jqXHR.upload.addEventListener('progress', function(event) {
                    if (event.lengthComputable) {
                        var percentComplete = Math.round((event.loaded / event.total) * 100);
                        progress.find('.progress-bar')
                            .css('width', percentComplete + '%')
                            .attr('aria-valuenow', percentComplete)
                            .html(percentComplete + '%')
                    }

                }, false);

                return jqXHR;
            },
            success: function(data, textStatus, jqXHR) {
                const status = form.find('select[name=post_status]').val();
                importUid(file, uid, status, form);

            },
            error: function(jqXHR, textStatus, errorThrown) {
                const errorMessage = jqXHR.responseJSON?.message || textStatus || errorThrown || 'An unknown error occurred.';
                $.showToast(errorMessage, 'danger');
            }

        });
    }

    function resumableUpload(uploadUrl, uid, file, progress, form) {

        const upload = new tus.Upload(file, {
            uploadUrl: uploadUrl,
            chunkSize: 5242880,
            uploadSize: file.size,
            retryDelays: [0, 1000, 3000, 5000, 7000, 10000, 12000, 15000],
            metadata: {
                name: file.name,
                filetype: file.type
            },
            onError: function(error) {
                console.error("TUS Upload Error:", error);
            },
            onProgress: function(bytesUploaded, bytesTotal) {

                const percentComplete = Math.round((bytesUploaded / bytesTotal) * 100);

                // Update the progress bar UI
                progress.find('.progress-bar')
                    .css('width', `${percentComplete}%`)
                    .attr('aria-valuenow', percentComplete)
                    .html(`${percentComplete}%`);
            },
            onSuccess: function() {

                const status = form.find('select[name=post_status]').val();
                importUid(file, uid, status, form);

            }
        });

        upload.start();
    }

    function handleUpload(oldHandler, file, form) {

        const fileId = $.generateFileId(file);
        var progress = $(`div[data-file-id="${fileId}"]`);

        var formData = new FormData();

        formData.append('name', file.name);
        formData.append('size', file.size);
        formData.append('type', file.type);

        var jqxhr = $.ajax({
            url: streamtube.rest_url + '/cloudflare/endpoint',
            data: formData,
            processData: false,
            contentType: false,
            type: 'POST',
            beforeSend: function(jqXHR) {
                jqXHR.setRequestHeader('X-WP-Nonce', streamtube.nonce);
            }
        });

        jqxhr.fail(function(jqXHR, textStatus, errorThrown) {

            if( jqXHR?.responseJSON?.code === 'rest_forbidden' ){
                return $.showToast( jqXHR?.responseJSON?.message, 'danger');
            }

            if ( jqXHR?.responseJSON?.data) {
                $(document.body).trigger('upload_video', [jqXHR.responseJSON, textStatus, jqXHR, file, form]);
            } else {
                const errorMessage = jqXHR?.responseJSON?.message ?? errorThrown ?? textStatus;
                $.showToast(errorMessage, 'danger');
            }
        });

        jqxhr.done(function(data, textStatus, jqXHR) {

            let uploadUrl = data.data.uploadURL;

            let uid = data.data.uid;

            if (uploadUrl.search('tus') !== -1) {
                resumableUpload(uploadUrl, uid, file, progress, form);

            } else {
                directUpload(uploadUrl, uid, file, progress, form);
            }
        });
    }

    $(document).ready(function() {
        wp.hooks.addFilter('streamtube_js_do_upload_file_handler', 'cloudflare', handleUpload, 30);
    });

})(jQuery);