<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

$wp_list_table = new WP_Cloudflare_Stream_Videos_List_Table();

if( function_exists( 'streamtube_core_the_screen_options' ) ){
    streamtube_core_the_screen_options( $wp_list_table );
}

$wp_list_table->prepare_items();

streamtube_core_the_dashboard_head( esc_html__( 'Videos', 'wp-cloudflare-stream' ) );

streamtube_core_the_dashboard_content_start();    
?>
<div class="wp-core-ui">
    <div id="wpbody-content">

        <div class="list-views">
            <?php $wp_list_table->views(); ?>
            <div class="clearfix"></div>
        </div>

        <?php if( WP_Cloudflare_Stream_Permission::import_videos() ): ?>
            <form class="mt-4" id="import-cloudflare-all-videos">
                <?php printf(
                    '<input type="hidden" name="page" value="%s" />',
                    isset( $_REQUEST['page'] ) ? esc_attr( $_REQUEST['page'] ) : ''
                )?>
                <input type="hidden" name="action" value="import_all_cloudflare_videos">
                <input type="hidden" name="uid" value="">
                <input type="hidden" name="confirm" value="on">
                <input type="hidden" name="confirm_msg" value="<?php esc_attr_e( 'Do you want to import all videos from Cloudflare Stream?\nMass importing will\n- Import only videos marked as `Ready`\n- Update the metadata of existing videos.', 'wp-cloudflare-stream' )?>">
                <input type="hidden" name="_wpnonce" value="<?php echo esc_attr( wp_create_nonce( 'import_all_cloudflare_videos' ) )?>">
                <?php printf(
                    '<input type="hidden" name="tab" value="%s" />',
                    isset( $_REQUEST['tab'] ) ? esc_attr( $_REQUEST['tab'] ) : 'bulk-import'
                )?>    

                <p class="form-submit">
                    <button type="submit" class="button button-primary">
                        <?php esc_html_e( 'Mass Import All Videos', 'wp-cloudflare-stream' );?>
                    </button>        
                </p>

                <div class="progress-wrap bg-secondary rounded d-none" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 0%; padding: 0 .5rem"></div>
                </div>

                <ol id="cloudflare-imported-list" class="video-imported-list bg-white p-4 px-5 mt-4 border d-none">

                </ol>

            </form>
        <?php endif;?>        
        
        <form method="get">
            <?php
                $wp_list_table->search_box('Search', 'search');
                $wp_list_table->display();
            ?>
        </form>

    </div>
</div>
<?php    
streamtube_core_the_dashboard_content_end();