<?php
/**
 * BuddyPress - Members Home
 *
 * @package BuddyPress
 * @subpackage bp-legacy
 */

?>
<div class="bl-author-detail">
    <div class="wrap-personal-info-author sticky-sidebar">
        <div class="personal-info-author">
            <div class="media-author">
                <div class="pic-author">
                    <?php bp_displayed_user_avatar( 'type=full' ); ?>
                </div>

                <div class="socials-author">
                    <?php if( get_user_meta(bp_displayed_user_id(),'facebook',true) ) {?>
                        <a href="<?php the_author_meta('facebook',bp_displayed_user_id());?>"><i class="fa fa-facebook"></i></a>
                    <?php }?>
                    <?php if( get_user_meta(bp_displayed_user_id(),'twitter',true) ) {?>
                        <a href="<?php the_author_meta('twitter',bp_displayed_user_id());?>"><i class="fa fa-twitter"></i></a>
                    <?php }?>
                    <?php if( get_user_meta(bp_displayed_user_id(),'pinterest',true) ) {?>
                        <a href="<?php the_author_meta('pinterest',bp_displayed_user_id());?>"><i class="fa fa-pinterest-p"></i></a>
                    <?php }?>
                    <?php if( get_user_meta(bp_displayed_user_id(),'skype',true) ) {?>
                        <a href="<?php the_author_meta('skype',bp_displayed_user_id());?>"><i class="fa fa-skype"></i></a>
                    <?php }?>
                </div>
            </div>
            <?php
            $user_info = get_the_author_meta( 'thim_info', bp_displayed_user_id() );
            ?>
            <div class="info-author">
                <div class="item-info">
                    <span class="name-item">
                        <?php echo esc_html__( 'Full Name:', 'vividly' );?>
                    </span>
                    <span class="value-item">
                        <?php the_author_meta('display_name',bp_displayed_user_id());?>
                    </span>
                </div>
                <?php if(isset($user_info['birthday'])) {?>
                <div class="item-info">
                    <span class="name-item">
                        <?php echo esc_html__( 'Date of Birth:', 'vividly' );?>
                    </span>
                    <span class="value-item">
                        <?php echo esc_html($user_info['birthday']);?>
                    </span>
                </div>
                <?php }?>
                <?php if(isset($user_info['residence'])) {?>
                    <div class="item-info">
                    <span class="name-item">
                        <?php echo esc_html__( 'Residence:', 'vividly' );?>
                    </span>
                        <span class="value-item">
                        <?php echo esc_html($user_info['residence']);?>
                    </span>
                    </div>
                <?php }?>
                <?php if(isset($user_info['country'])) {?>
                    <div class="item-info">
                    <span class="name-item">
                        <?php echo esc_html__( 'Country:', 'vividly' );?>
                    </span>
                        <span class="value-item">
                        <?php echo esc_html($user_info['country']);?>
                    </span>
                    </div>
                <?php }?>
                <?php if(isset($user_info['gender'])) {?>
                    <div class="item-info">
                    <span class="name-item">
                        <?php echo esc_html__( 'Gender:', 'vividly' );?>
                    </span>
                        <span class="value-item">
                        <?php echo esc_html($user_info['gender']);?>
                    </span>
                    </div>
                <?php }?>
                <?php if(isset($user_info['language'])) {?>
                    <div class="item-info">
                    <span class="name-item">
                        <?php echo esc_html__( 'Language:', 'vividly' );?>
                    </span>
                        <span class="value-item">
                        <?php echo esc_html($user_info['language']);?>
                    </span>
                    </div>
                <?php }?>
                <?php if(isset($user_info['height'])) {?>
                    <div class="item-info">
                    <span class="name-item">
                        <?php echo esc_html__( 'Height:', 'vividly' );?>
                    </span>
                        <span class="value-item">
                        <?php echo esc_html($user_info['height']);?>
                    </span>
                    </div>
                <?php }?>
            </div>
        </div>
    </div>
    <div class="detail-author">
        <div class="field-detail">
            <h3 class="title-field">
                <?php echo esc_html__('Biography','vividly');?>
            </h3>
            <div class="content-field">
                <p><?php the_author_meta('description',bp_displayed_user_id()); ?></p>
            </div>
        </div>
        <?php
        $query = array(
            'author' => bp_displayed_user_id(),
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
            'tax_query' => array( array(
                'taxonomy' => 'post_format',
                'field' => 'slug',
                'terms' => array('post-format-video'),
            ) )
        );
        $videos = new WP_Query( $query );
        ?>
        <?php if ( $videos->have_posts() ) { ?>
        <div class="field-detail">
            <h3 class="title-field">
                <?php echo esc_html__('Filmography','vividly');?>
            </h3>
            <div class="content-field">
                <div class="list-films">
                    <div class="head-list">
                        <span class="name-film">
                            <?php echo esc_html__('Movie Name','vividly');?>
                        </span>
                        <span class="release-date">
                            <?php echo esc_html__('Release Date','vividly');?>
                        </span>
                    </div>
                    <?php while ( $videos->have_posts() ) : $videos->the_post(); ?>
                        <?php
                        $categories = get_the_category();
                        $cat = '';
                        if ( ! empty( $categories ) ) {
                            for ($i=0;$i<count($categories);$i++) {
                                if($i>0) $cat .= ', ';
                                $cat .= $categories[$i]->name;
                            }
                        }
                        ?>
                        <div class="item-film">
                            <div class="pic-film">
                                <a href="<?php the_permalink(); ?>">
                                    <?php echo thim_feature_image(100, 110);?>
                                </a>
                            </div>

                            <div class="text-film">
                                <div class="film-info">
                                    <div class="genre-film">
                                        <?php echo esc_html($cat);?>
                                    </div>

                                    <div class="title-film">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php get_the_title() ? the_title() : the_ID(); ?>
                                        </a>
                                    </div>
                                    <?php if( get_post_meta(get_the_ID(),'thim_video_meta_rating',true) ) {?>
                                    <div class="stars-film">
                                        <span class="iconstars">
                                            <?php for ($i=0;$i<10;$i++) {?>
                                                <i class="ion ion-android-star<?php echo esc_html($i>=(int) get_post_meta(get_the_ID(),'thim_video_meta_rating',true)) ? '-outline' : '';?>"></i>
                                            <?php }?>
                                        </span>

                                        <?php echo (int) get_post_meta(get_the_ID(),'thim_video_meta_rating',true);?>/10
                                    </div>
                                    <?php }?>
                                </div>

                                <div class="release-date">
                                    <?php the_date();?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;?>
                </div>
            </div>
        </div>
        <?php }?>
    </div>
</div>