<?php
/**
 * Theme functions and definitions.
 *
 * @link    https://developer.wordpress.org/themes/basics/theme-functions/
 *
 */
require_once( ABSPATH . "wp-admin" . '/includes/image.php' );
require_once( ABSPATH . "wp-admin" . '/includes/file.php' );
require_once( ABSPATH . "wp-admin" . '/includes/media.php' );
require_once get_template_directory() . '/inc/theme-setup.php';

define( 'THIM_DIR', trailingslashit( get_template_directory() ) );
define( 'THIM_URI', trailingslashit( get_template_directory_uri() ) );
define( 'THIM_THEME_VERSION', '1.5.4' );

if ( ! function_exists( 'thim_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function thim_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on this theme, use a find and replace
		 * to change 'vividly' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'vividly', THIM_DIR . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary Menu', 'vividly' ),
			)
		);

		if ( get_theme_mod( 'copyright_menu', true ) ) {
			register_nav_menus(
				array(
					'copyright_menu' => esc_html__( 'Copyright Menu', 'vividly' ),
				)
			);
		}

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5', array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		/*
		 * Enable support for Post Formats.
		 * See https://developer.wordpress.org/themes/functionality/post-formats/
		 */
		add_theme_support(
			'post-formats', array(
				'aside',
				'image',
				'video',
				'audio',
				'quote',
				'link',
				'gallery',
				'chat',
			)
		);

		add_theme_support( 'custom-background' );

		add_theme_support( 'thim-core' );
		add_theme_support( 'video-blog-demo-data' );

		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
		add_theme_support( 'woocommerce' );

		add_image_size( 'thim-single-product', 370, 416, true );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style-editor.css' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		// Editor color palette.
		add_theme_support(
			'editor-color-palette', array(
				array(
					'name'  => esc_html__( 'Primary Color', 'vividly' ),
					'slug'  => 'primary',
					'color' => get_theme_mod( 'body_primary_color', '#439fdf' ),
				),
				array(
					'name'  => esc_html__( 'Title Color', 'vividly' ),
					'slug'  => 'title',
					'color' => get_theme_mod( 'font_title_color', '#333333' ),
				),
				array(
					'name'  => esc_html__( 'Font Body Color', 'vividly' ),
					'slug'  => 'body',
					'color' => get_theme_mod( 'font_body_color', '#777777' ),
				)
			)
		);

		// Add custom editor font sizes.
		add_theme_support(
			'editor-font-sizes',
			array(
				array(
					'name'      => __( 'Small', 'vividly' ),
					'shortName' => __( 'S', 'vividly' ),
					'size'      => 13,
					'slug'      => 'small',
				),
				array(
					'name'      => __( 'Normal', 'vividly' ),
					'shortName' => __( 'M', 'vividly' ),
					'size'      => 15,
					'slug'      => 'normal',
				),
				array(
					'name'      => __( 'Large', 'vividly' ),
					'shortName' => __( 'L', 'vividly' ),
					'size'      => 28,
					'slug'      => 'large',
				),
				array(
					'name'      => __( 'Huge', 'vividly' ),
					'shortName' => __( 'XL', 'vividly' ),
					'size'      => 36,
					'slug'      => 'huge',
				),
			)
		);
		// remove wp_global_styles_render_svg_filters
		remove_action( 'wp_body_open', 'wp_global_styles_render_svg_filters' );
	}
endif;
add_action( 'after_setup_theme', 'thim_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function thim_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'thim_content_width', 640 );
}

add_action( 'after_setup_theme', 'thim_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function thim_widgets_init() {
	$thim_options = get_theme_mods();

	/**
	 * Sidebar for module Topbar
	 */
	if ( get_theme_mod( 'header_topbar_display', true ) ) {
		register_sidebar(
			array(
				'name'          => esc_html__( 'Topbar Left', 'vividly' ),
				'id'            => 'topbar-left',
				'description'   => esc_html__( 'Display in topbar left.', 'vividly' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);
		register_sidebar(
			array(
				'name'          => esc_html__( 'Topbar Right', 'vividly' ),
				'id'            => 'topbar-right',
				'description'   => esc_html__( 'Display in topbar right.', 'vividly' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);
	}

	register_sidebar(
		array(
			'name'          => esc_html__( 'Right logo', 'vividly' ),
			'id'            => 'right-logo',
			'description'   => esc_html__( 'Display in right logo.', 'vividly' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Left logo', 'vividly' ),
			'id'            => 'left-logo',
			'description'   => esc_html__( 'Display in left logo.', 'vividly' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Right menu', 'vividly' ),
			'id'            => 'right-menu',
			'description'   => esc_html__( 'Display in right menu.', 'vividly' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'vividly' ),
			'id'            => 'sidebar',
			'description'   => esc_html__( 'Appears in the Sidebar section of the site.', 'vividly' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Canvas', 'vividly' ),
			'id'            => 'canvas',
			'description'   => esc_html__( 'Appears in the Sidebar section of the site.', 'vividly' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar Shop', 'vividly' ),
			'id'            => 'sidebar-shop',
			'description'   => esc_html__( 'Appears in the Sidebar section of the site.', 'vividly' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);

	if ( isset( $thim_options['footer_columns'] ) ) {
		$footer_columns = (int) $thim_options['footer_columns'];
		for ( $i = 1; $i <= $footer_columns; $i ++ ) {
			register_sidebar(
				array(
					'name'          => sprintf( 'Footer Sidebar %s', $i ),
					'id'            => 'footer-sidebar-' . $i,
					'description'   => esc_html__( 'Sidebar display widgets.', 'vividly' ),
					'before_widget' => '<aside id="%1$s" class="widget %2$s">',
					'after_widget'  => '</aside>',
					'before_title'  => '<h3 class="widget-title">',
					'after_title'   => '</h3>',
				)
			);
		}
	}

	/**
	 * Not remove
	 * Function create sidebar on wp-admin.
	 */
	$sidebars = apply_filters( 'thim_core_list_sidebar', array() );
	if ( count( $sidebars ) > 0 ) {
		foreach ( $sidebars as $sidebar ) {
			$new_sidebar = array(
				'name'          => $sidebar['name'],
				'id'            => $sidebar['id'],
				'description'   => '',
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			);

			register_sidebar( $new_sidebar );
		}
	}

}

add_action( 'widgets_init', 'thim_widgets_init' );
// remove font-awesome in elementor
add_action(
	'elementor/frontend/after_register_styles', function () {
	foreach ( [ 'solid', 'regular', 'brands' ] as $style ) {
		wp_deregister_style( 'elementor-icons-fa-' . $style );
		wp_deregister_style( 'font-awesome' );
	}
}, 20
);
/**
 * Enqueue scripts and styles.
 */
function thim_scripts() {

	// Enqueue Styles
	wp_enqueue_style( 'ionicon', THIM_URI . 'assets/css/libs/ionicons/ionicons.css', array(), THIM_THEME_VERSION, 'all' );
	wp_enqueue_style( 'fontawesome', THIM_URI . 'assets/css/libs/awesome/font-awesome.css', array(), THIM_THEME_VERSION, 'all' );
	wp_enqueue_style( 'v4-shims', THIM_URI . 'assets/css/libs/awesome/v4-shims.css', array(), THIM_THEME_VERSION, 'all' );
	wp_enqueue_style( 'bootstrap', THIM_URI . 'assets/css/libs/bootstrap/bootstrap.css', array(), THIM_THEME_VERSION, 'all' );
	wp_enqueue_style( 'builder-press-slick', THIM_URI . 'assets/css/libs/slick/slick.css', array(), THIM_THEME_VERSION, 'all' );
	wp_enqueue_style( 'builder-press-magnific-popup', THIM_URI . 'assets/css/libs/magnific-popup/magnific-popup.css', array(), THIM_THEME_VERSION, 'all' );
	// End: Enqueue Styles

	// Enqueue Scripts
	wp_enqueue_script( 'imagesloaded' );
	wp_enqueue_script( 'builder-press-slick', THIM_URI . 'assets/js/libs/slick.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_enqueue_script( 'tether', THIM_URI . 'assets/js/libs/1_tether.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_enqueue_script( 'bootstrap', THIM_URI . 'assets/js/libs/bootstrap.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_enqueue_script( 'builder-press-isotope', THIM_URI . 'assets/js/libs/isotope.pkgd.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_enqueue_script( 'flexslider', THIM_URI . 'assets/js/libs/jquery.flexslider-min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_dequeue_script( 'select2' );
	wp_enqueue_script( 'thim-select2', THIM_URI . 'assets/js/libs/select2.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_enqueue_script( 'stellar', THIM_URI . 'assets/js/libs/stellar.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_enqueue_script( 'theia-sticky-sidebar', THIM_URI . 'assets/js/libs/theia-sticky-sidebar.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	wp_enqueue_script( 'builder-press-magnific-popup', THIM_URI . 'assets/js/libs/jquery.magnific-popup.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );

	// End: Enqueue Scripts

	//	Style
	// Theme Style
	wp_enqueue_style( 'thim-style', THIM_URI . 'style.css', array(), THIM_THEME_VERSION );

	// Style default
	if ( ! thim_plugin_active( 'thim-core' ) ) {
		wp_enqueue_style( 'font-poppins', '//fonts.googleapis.com/css?family=Poppins:300,300i,400,400i,500,500i,600,600i', array() );
		wp_enqueue_style( 'thim-default', THIM_URI . 'inc/data/default.css', array() );
	}

	$main_file = THIM_URI . 'assets/js/main.min.js';

	//	Scripts
	wp_enqueue_script( 'thim-main', $main_file, array( 'jquery', 'imagesloaded' ), THIM_THEME_VERSION, true );

	if ( get_theme_mod( 'feature_smoothscroll', false ) ) {
		wp_enqueue_script( 'smoothscroll', THIM_URI . 'assets/js/libs/smoothscroll.min.js', array( 'jquery' ), '', true );
	}

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

add_action( 'wp_enqueue_scripts', 'thim_scripts', 100 );

add_action( 'admin_enqueue_scripts', 'thim_admin_scripts' );
function thim_admin_scripts() {
	wp_enqueue_script( 'thim-admin-script', THIM_URI . 'assets/js/admin-script.js', array( 'jquery' ) );
	wp_enqueue_style( 'thim-admin-style', THIM_URI . 'assets/css/admin.css', array() );
}

function thim_custom_stylesheet_for_developer( $stylesheet, $stylesheet_dir ) {
	if ( WP_DEBUG && ! is_child_theme() ) {
		$stylesheet = $stylesheet_dir . '/style.unminify.css';
	}

	return $stylesheet;
}

add_filter( 'stylesheet_uri', 'thim_custom_stylesheet_for_developer', 10, 2 );


/**
 * Implement the theme wrapper.
 */
require_once( THIM_DIR . 'inc/libs/theme-wrapper.php' );


/**
 * Tax meta Class
 *
 * @todo: Remove comment if you want to use tax meta class
 */
require_once( THIM_DIR . 'inc/libs/Tax-meta-class/Tax-meta-class.php' );
require_once( THIM_DIR . 'inc/tax-meta.php' );

/**
 * Custom template tags for this theme.
 */
require_once( THIM_DIR . 'inc/template-tags.php' );

/**
 * Custom functions that act independently of the theme templates.
 */
require_once( THIM_DIR . 'inc/extras.php' );

/**
 * Extra setting on plugins, export & import with demo data.
 */
include_once THIM_DIR . 'inc/data/extra-plugin-settings.php';

/**
 * Load aq_resize
 */
include_once THIM_DIR . 'inc/aq_resizer.php';

/**
 * Load Jetpack compatibility file.
 */
require_once( THIM_DIR . 'inc/jetpack.php' );

/**
 * Custom wrapper layout for theme
 */
require_once( THIM_DIR . 'inc/wrapper-layout.php' );

/**
 * Custom BuddyPress for theme
 */
if ( class_exists( 'BuddyPress' ) ) {
	require THIM_DIR . 'inc/bp-custom.php';
}

/**
 * Custom functions
 */
require_once( THIM_DIR . 'inc/custom-functions.php' );

/**
 * Video functions
 */
require_once( THIM_DIR . 'inc/video-functions.php' );

/**
 * Shop functions
 */
require_once( THIM_DIR . 'inc/shop-functions.php' );

/**
 * Customizer additions.
 */
require_once( THIM_DIR . 'inc/customizer.php' );

/**
 * Require plugins
 */
if ( is_admin() && current_user_can( 'manage_options' ) ) {
	include_once THIM_DIR . 'inc/admin/installer/installer.php';
	include_once THIM_DIR . 'inc/admin/plugins-require.php';
}
