<?php
/**
 * Section Sharing
 *
 * @package Hair_Salon
 */

thim_customizer()->add_section(
    array(
        'id'       => 'sharing',
        'panel'    => 'blog',
        'title'    => esc_html__( 'Social Share', 'vividly' ),
        'priority' => 21,
    )
);
// Enable or Disable Author Meta Tags
thim_customizer()->add_field(
    array(
        'id'          => 'show_sharing',
        'type'        => 'switch',
        'label'       => esc_html__( 'Show Sharing', 'vividly' ),
        'tooltip'     => esc_html__( 'Allows you to show Sharing on single post.', 'vividly' ),
        'section'     => 'sharing',
        'default'     => false,
        'priority'    => 10,
        'choices'     => array(
            true  	  => esc_html__( 'Show', 'vividly' ),
            false	  => esc_html__( 'Hide', 'vividly' ),
        ),
    )
);

// Sharing Group
thim_customizer()->add_field(
    array(
        'id'       => 'group_sharing',
        'type'     => 'sortable',
        'label'    => esc_html__( 'Sortable Buttons Sharing', 'vividly' ),
        'tooltip'  => esc_html__( 'Click on eye icons to show or hide buttons. Use drag and drop to change the position of social share icons..', 'vividly' ),
        'section'  => 'sharing',
        'priority' => 10,
        'default'  => array(
            'facebook',
            'twitter',
            'pinterest',
            'instagram',
        ),
        'choices'  => array(
            'facebook'  => esc_html__( 'Facebook', 'vividly' ),
            'twitter'   => esc_html__( 'Twitter', 'vividly' ),
            'pinterest' => esc_html__( 'Pinterest', 'vividly' ),
            'instagram' => esc_html__( 'Instagram', 'vividly' ),
        ),
    )
);

