<?php
/**
 * Section Thim Our Team plugin
 *
 */

thim_customizer()->add_section(
    array(
        'id'       => 'blog_single',
        'panel'    => 'blog',
        'title'    => esc_html__( 'Single Page', 'vividly' ),
        'priority' => 14,
    )
);



// Enable or Disable Page Title
thim_customizer()->add_field(
    array(
        'id'       => 'blog_single_hide_page_title',
        'type'     => 'switch',
        'label'    => esc_html__( 'Hidden Page Title', 'vividly' ),
        'tooltip'  => esc_html__( 'Allows you can hidden or show page title on heading top. ', 'vividly' ),
        'section'       => 'blog_single',
        'default'  => false,
        'priority' => 10,
        'choices'  => array(
            true  => esc_html__( 'On', 'vividly' ),
            false => esc_html__( 'Off', 'vividly' ),
        ),
    )
);

// Enable or Disable Breadcrumb
thim_customizer()->add_field(
    array(
        'id'          => 'blog_single_hide_breadcrumb',
        'type'        => 'switch',
        'label'       => esc_html__( 'Hide Breadcrumb', 'vividly' ),
        'tooltip'     => esc_html__( 'Allows you can HIDE breadcrumb on page title bar. ', 'vividly' ),
        'section'     => 'blog_single',
        'default'     => false,
        'priority'    => 15,
        'choices'     => array(
            true  	  => esc_html__( 'On', 'vividly' ),
            false	  => esc_html__( 'Off', 'vividly' ),
        ),
    )
);

// Background Image
thim_customizer()->add_field(
    array(
        'id'       => 'blog_single_heading_background_image',
        'type'     => 'image',
        'label'    => esc_html__( 'Background Image', 'vividly' ),
        'tooltip'  => esc_html__( 'You can upload image make to background image for page title on heading top. ', 'vividly' ),
        'section'   => 'blog_single',
        'priority' => 20,
        'js_vars'  => array(
            array(
                'element'  => '.main-top',
                'function' => 'css',
                'property' => 'background-image',
            ),
        ),
        'default'  => THIM_URI . "assets/images/page-title.jpg",
    )
);

// Background Color
thim_customizer()->add_field(
    array(
        'id'        => 'blog_single_heading_background_color',
        'type'      => 'color',
        'label'     => esc_html__( 'Background Color', 'vividly' ),
        'tooltip'   => esc_html__( 'If you do not use background image, then can use background color for page title on heading top. ', 'vividly' ),
        'section'   => 'blog_single',
        'default'   => '#222222',
        'priority'  => 25,
        'alpha'     => true,
        'transport' => 'postMessage',
        'js_vars'   => array(
            array(
                'choice'   => 'color',
                'element'  => '.page-title .main-top .overlay-top-header',
                'property' => 'background',
            )
        )
    )
);

// Background Color opacity
thim_customizer()->add_field(
    array(
        'id'        => 'blog_single_background_opacity',
        'type'      => 'text',
        'label'     => esc_html__( 'Background Color Opacity', 'vividly' ),
        'section'   => 'blog_single',
        'default'   => '0.5',
        'priority'  => 35,
        'alpha'     => true,
        'transport' => 'postMessage',
        'js_vars'   => array(
            array(
                'choice'   => 'text',
                'element'  => '.page-title .main-top .overlay-top-header',
                'property' => 'opacity',
            )
        )
    )
);

// Sub title
thim_customizer()->add_field(
	array(
		'id'        => 'blog_single_sub_title',
		'type'      => 'text',
		'label'     => esc_html__( 'Sub title', 'vividly' ),
		'section'   => 'blog_single',
		'priority'  => 36,
		'transport' => 'postMessage',
	)
);