<?php
/**
 * Section Header Layout
 * 
 * @package Thim_Starter_Theme
 */

thim_customizer()->add_section(
	array(
		'id'             => 'header_layout',
		'title'          => esc_html__( 'Layouts', 'vividly' ),
		'panel'			 => 'header',
		'priority'       => 20,
	)
);

// Select Header Layout
thim_customizer()->add_field(
	array(
		'id'            => 'header_style',
		'type'          => 'radio-image',
		'label'         => esc_html__( 'Header Layouts', 'vividly' ),
		'tooltip'     	=> esc_html__( 'Allows you can select header layout for header on your site. ', 'vividly' ),
		'section'       => 'header_layout',
		'default'       => 'header_v1',
		'priority'      => 10,
		'choices'       => array(
			'layout-1'     => THIM_URI . 'assets/images/header/layout-1.jpg',
            'layout-2'     => THIM_URI . 'assets/images/header/layout-2.jpg',
            'layout-3'     => THIM_URI . 'assets/images/header/layout-3.jpg',
            'layout-4'     => THIM_URI . 'assets/images/header/layout-4.jpg',
		),
	)
);

// Select Header Position
thim_customizer()->add_field(
	array(
		'id'          => 'header_position',
		'type'        => 'select',
		'label'       => esc_html__( 'Header Positions', 'vividly' ),
		'tooltip'     => esc_html__( 'Allows you can select position layout for header layout. ', 'vividly' ),
		'section'     => 'header_layout',
		'priority'    => 20,
		'multiple'    => 0,
		'default'     => 'default',
		'choices'     => array(
			'default' => esc_html__( 'Default', 'vividly' ),
			'overlay' => esc_html__( 'Overlay', 'vividly' ),
		),
	)
);


// Background Header
thim_customizer()->add_field(
	array(
		'id'          => 'header_background_color',
		'type'        => 'color',
		'label'       => esc_html__( 'Background Color', 'vividly' ),
		'tooltip'     => esc_html__( 'Allows you can choose background color for your header. ', 'vividly' ),
		'section'     => 'header_layout',
		'default'     => '#439fdf',
		'priority'    => 30,
		'alpha'       => true,
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'choice'   => 'color',
				'element'  => 'body #masthead.site-header',
				'property' => 'background-color',
			)
		)
	)
);