<?php
/**
 * Section Shop Layouts
 *
 * @package video-blog
 */

thim_customizer()->add_section(
	array(
		'id'             => 'shop_layout',
		'panel'			 => 'shop',
		'title'          => esc_html__( 'Layouts', 'vividly' ),
		'priority'       => 10,
	)
);

//-------------------------------------------------Archive---------------------------------------------//

// Select Shop Archive Layout
thim_customizer()->add_field(
	array(
		'id'            => 'shop_archive_layout',
		'type'          => 'radio-image',
		'label'         => esc_html__( 'Shop Archive Layouts', 'vividly' ),
		'tooltip'       => esc_html__( 'Allows you to choose a layout to display for all Shop archive, Shop category page on your site.', 'vividly' ),
		'section'       => 'shop_layout',
		'priority'      => 12,
		'choices'       => array(
			'sidebar-left'     => THIM_URI . 'assets/images/layout/sidebar-left.jpg',
			'no-sidebar'       => THIM_URI . 'assets/images/layout/body-full.jpg',
			'sidebar-right'    => THIM_URI . 'assets/images/layout/sidebar-right.jpg',
			'full-sidebar'     => THIM_URI . 'assets/images/layout/body-left-right.jpg'
		),
	)
);

// Select Sidebar To Display In Sidebar Left For Full Sidebar Layout
thim_customizer()->add_field(
	array(
		'id'          => 'shop_archive_layout_sidebar_left',
		'type'        => 'select',
		'label'       => esc_html__( 'Sidebar Left For Shop Archive Layout ', 'vividly' ),
		'tooltip'     => esc_html__( 'Allows you to select a sidebar to display in sidebar left when you used Full sidebar layout on Shop archive layout.', 'vividly' ),
		'section'     => 'shop_layout',
		'priority'    => 13,
		'multiple'    => 1,
		'default'     => 'sidebar',
		'choices'     => thim_get_list_sidebar(),
		'active_callback' => array(
			array(
				'setting'  => 'shop_archive_layout',
				'operator' => '===',
				'value'    => 'full-sidebar',
			),
		),
	)
);

// Select Sidebar To Display In Sidebar Right For Full Sidebar Layout
thim_customizer()->add_field(
	array(
		'id'          => 'shop_archive_layout_sidebar_right',
		'type'        => 'select',
		'label'       => esc_html__( 'Sidebar Right For Shop Archive Layout', 'vividly' ),
		'tooltip'     => esc_html__( 'Allows you to select a sidebar to display in sidebar right when you used Full sidebar layout on Archive layout.', 'vividly' ),
		'section'     => 'shop_layout',
		'priority'    => 14,
		'multiple'    => 1,
		'default'     => 'sidebar',
		'choices'     => thim_get_list_sidebar(),
		'active_callback' => array(
			array(
				'setting'  => 'shop_archive_layout',
				'operator' => '===',
				'value'    => 'full-sidebar',
			),
		),
	)
);

//-------------------------------------------------Single---------------------------------------------//

// Select Single Layout
thim_customizer()->add_field(
	array(
		'id'            => 'shop_single_layout',
		'type'          => 'radio-image',
		'label'         => esc_html__( 'Shop Single Layouts', 'vividly' ),
		'tooltip'       => esc_html__( 'Allows you to choose a layout to display for only Shop single page on your site.', 'vividly' ),
		'section'       => 'shop_layout',
		'priority'      => 20,
		'choices'       => array(
			'sidebar-left'     => THIM_URI . 'assets/images/layout/sidebar-left.jpg',
			'no-sidebar'       => THIM_URI . 'assets/images/layout/body-full.jpg',
			'sidebar-right'    => THIM_URI . 'assets/images/layout/sidebar-right.jpg',
			'full-sidebar'     => THIM_URI . 'assets/images/layout/body-left-right.jpg'
		),
	)
);

// Select Sidebar To Display In Sidebar Left For Full Sidebar Layout
thim_customizer()->add_field(
	array(
		'id'          => 'shop_single_layout_sidebar_left',
		'type'        => 'select',
		'label'       => esc_html__( 'Sidebar Left For Post Layout', 'vividly' ),
		'tooltip'     => esc_html__( 'Allows you to select a sidebar to display in sidebar left when you used Full sidebar layout on Post layout.', 'vividly' ),
		'section'     => 'shop_layout',
		'priority'    => 21,
		'multiple'    => 1,
		'choices'     => thim_get_list_sidebar(),
		'active_callback' => array(
			array(
				'setting'  => 'shop_single_layout',
				'operator' => '===',
				'value'    => 'full-sidebar',
			),
		),
	)
);

// Select Sidebar To Display In Sidebar Right For Full Sidebar Layout
thim_customizer()->add_field(
	array(
		'id'          => 'shop_single_layout_sidebar_right',
		'type'        => 'select',
		'label'       => esc_html__( 'Sidebar Right For Post Layout', 'vividly' ),
		'tooltip'     => esc_html__( 'Allows you to select a sidebar to display in sidebar right when you used Full sidebar layout on Post layout.', 'vividly' ),
		'section'     => 'shop_layout',
		'priority'    => 22,
		'multiple'    => 1,
		'choices'     => thim_get_list_sidebar(),
		'active_callback' => array(
			array(
				'setting'  => 'shop_single_layout',
				'operator' => '===',
				'value'    => 'full-sidebar',
			),
		),
	)
);