<?php

function thim_get_all_plugins_require( $plugins ) {
	return array(
		array(
			'name'        => 'Video Blog Demo Data',
			'slug'        => 'video-blog-demo-data',
			'premium'     => true,
			'required'    => true,
			'version'     => '1.4',
			'description' => 'Demo data for the theme Video Blog',
		),
		array(
			'name'     => 'WPBakery Page Builder',
			'slug'     => 'js_composer',
			'premium'  => true,
			'version'  => '5.7',
			'required' => false,
			'icon'     => THIM_URI . 'assets/images/plugins/js_composer.png',
		),
		array(
			'name'     => 'Stellar video player',
			'slug'     => 'Stellar-video-player',
			'premium'  => true,
			'version'  => '1.4',
			'required' => true,
		),
		array(
			'name'        => 'BuilderPress',
			'slug'        => 'builderpress',
			'premium'     => true,
			'required'    => true,
			'version'     => '1.2.1.4',
			'description' => 'Full of Thim features for page builders: Visual Composer, Site Origin, Elementor',
		),

		array(
			'name'     => 'Elementor Page Builder',
			'slug'     => 'elementor',
			'required' => false,
		),
		array(
			'name'     => 'AnyWhere Elementor',
			'slug'     => 'anywhere-elementor',
			'required' => false,
		),
		array(
			'name'     => 'WooCommerce',
			'slug'     => 'woocommerce',
			'required' => false,
		),
		array(
			'name' => 'Contact Form 7',
			'slug' => 'contact-form-7'
		),
		array(
			'name'     => 'Easy Forms for MailChimp',
			'slug'     => 'yikes-inc-easy-mailchimp-extender',
			'required' => false,
		),
		array(
			'name'     => 'Instagram Feed',
			'slug'     => 'instagram-feed',
			'required' => false,
		),
		array(
			'name'     => 'BuddyPress',
			'slug'     => 'buddypress',
			'required' => false,
		),
	);
}

add_filter( 'thim_core_get_all_plugins_require', 'thim_get_all_plugins_require' );

add_filter( 'thim_core_plugin_icon_install', 'thim_custom_plugin_icon', 10, 2 );
if ( !function_exists( 'thim_custom_plugin_icon' ) ) {
	function thim_custom_plugin_icon( $icon, $plugin ) {
		if ( $plugin->get_slug() == 'anywhere-elementor' ) {
			$icon = 'https://ps.w.org/' . $plugin->get_slug() . '/assets/icon-128x128.jpg';
		}

		return $icon;
	}
}