<?php
/**
 * Filter & Action
 */
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

add_action( 'woocommerce_before_shop_loop_item', 'thim_before_loop_product', 1 );
if( !function_exists( 'thim_before_loop_product' ) ) {
    function thim_before_loop_product() {
        echo '<div class="item-product">';
    }
}
add_action( 'woocommerce_after_shop_loop_item', 'thim_after_loop_product', 15 );
if( !function_exists( 'thim_after_loop_product' ) ) {
    function thim_after_loop_product() {
        echo '</div>';
    }
}
add_action( 'woocommerce_before_shop_loop_item_title', 'thim_before_shop_loop_item_title_start', 5 );
if( !function_exists( 'thim_before_shop_loop_item_title_start' ) ) {
    function thim_before_shop_loop_item_title_start() {
        echo '<div class="media-item"><div class="pic">';
    }
}
add_action( 'woocommerce_before_shop_loop_item_title', 'thim_before_shop_loop_item_title_end', 15 );
if( !function_exists( 'thim_before_shop_loop_item_title_end' ) ) {
    function thim_before_shop_loop_item_title_end() {
        echo '</div>';
    }
}
add_action( 'woocommerce_before_shop_loop_item_title', 'thim_before_shop_loop_item_title_end_media', 30 );
if( !function_exists( 'thim_before_shop_loop_item_title_end_media' ) ) {
    function thim_before_shop_loop_item_title_end_media() {
        echo '</div>';
    }
}
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 20 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
/**
 * Add begin, end to result count + ordering
 */
add_action( 'woocommerce_before_shop_loop', 'thim_before_shop_loop_begin', 15 );
if( !function_exists('thim_before_shop_loop_begin') ) {
    function thim_before_shop_loop_begin() {
        echo '<div class="heading-products">';
    }
}
add_action( 'woocommerce_before_shop_loop', 'thim_before_shop_loop_end', 35 );
if( !function_exists('thim_before_shop_loop_end') ) {
    function thim_before_shop_loop_end() {
        echo '</div>';
    }
}
/**
 * Action Shop loop item title
 */
add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_price', 15 );
// add begin, end loop title action
add_action( 'woocommerce_shop_loop_item_title', 'thim_add_loop_product_title_start', 5 );
if( !function_exists('thim_add_loop_product_title_start') ) {
    function thim_add_loop_product_title_start() {
        echo '<div class="text-item">';
    }
}
add_action( 'woocommerce_shop_loop_item_title', 'thim_add_loop_product_title_end', 20 );
if( !function_exists('thim_add_loop_product_title_end') ) {
    function thim_add_loop_product_title_end() {
        echo '</div>';
    }
}
// Custom loop title
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'thim_custom_template_loop_product_title', 10 );
if( !function_exists( 'thim_custom_template_loop_product_title' ) ) {
    function thim_custom_template_loop_product_title() {
        echo '<h4 class="title"><a href="'.esc_url(get_permalink()).'">' . esc_html(get_the_title()) . '</a></h4>';
    }
}
/**
 * Custom After shop loop item title
 */
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );

add_filter( 'woocommerce_loop_add_to_cart_link', 'thim_custom_loop_add_to_cart_link', 10, 3 );
if( !function_exists('thim_custom_loop_add_to_cart_link') ) {
    function thim_custom_loop_add_to_cart_link($output, $product, $args) {
        global $product;
        $args['class'] .= ' btn-addcart';
        $output = '<a 
                href="'.esc_url( $product->add_to_cart_url() ).'" data-quantity="'.esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ).'" 
                class="'.esc_attr( isset( $args['class'] ) ? $args['class'] : 'btn-addcart' ).'">
                <i class="ion ion-android-cart"></i> '.esc_html( $product->add_to_cart_text() ).'
                </a>';
        return $output;
    }
}

/**
 * Action single product
 */
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_filter( 'woocommerce_related_products_columns', 'thim_custom_related_products_columns', 10, 1 );
if( !function_exists('thim_custom_related_products_columns') ) {
    function thim_custom_related_products_columns($columns) {
        return '3';
    }
}
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
add_action( 'woocommerce_after_single_product', 'woocommerce_output_related_products', 5 );


add_filter( 'woocommerce_breadcrumb_defaults', 'thim_custom_woocommerce_breadcrumb', 10, 1 );
if( !function_exists('thim_custom_woocommerce_breadcrumb') ) {
    function thim_custom_woocommerce_breadcrumb($args) {
        $args = array(
            'delimiter'   => '<span class="breadcrum-icon">&nbsp;&#47;&nbsp;</span>',
            'wrap_before' => '<ul class="breadcrumbs">',
            'wrap_after'  => '</ul>',
            'before'      => '<li>',
            'after'       => '</li>',
            'home'        => esc_html__( 'Home', 'vividly' ),
        );
        return $args;
    }
}

// create text field enter name produces of product
function thim_produces_product() {
    $args = array(
        'id' => 'thim_name_produces',
        'label' => esc_html__( 'Product in', 'vividly' ),
        'class' => 'cfwc-custom-field',
        'desc_tip' => true,
        'description' => esc_html__( 'Enter the name produces of product .', 'vividly' ),
    );
    woocommerce_wp_text_input( $args );
}
add_action( 'woocommerce_product_options_general_product_data', 'thim_produces_product' );

// save enter name produces of product
function thim_save_produces_product($post_id){
    $product = wc_get_product( $post_id );
    $title = isset( $_POST['thim_name_produces'] ) ? $_POST['thim_name_produces'] : '';
    $product->update_meta_data( 'thim_name_produces', sanitize_text_field( $title ) );
    $product->save();
}
add_action( 'woocommerce_process_product_meta', 'thim_save_produces_product' );

//add_filter( 'woocommerce_gallery_thumbnail_size', 'thim_custom_woocommerce_gallery_thumbnail_size', 10, 1 );
if( !function_exists('thim_custom_woocommerce_gallery_thumbnail_size') ) {
    function thim_custom_woocommerce_gallery_thumbnail_size($size) {
        $size = array(50,50);
        return $size;
    }
}

// filter custom number related products
add_filter( 'woocommerce_output_related_products_args', 'thim_custom_woocommerce_output_related_products_args' );
if( !function_exists( 'thim_custom_woocommerce_output_related_products_args' ) ) {
    function thim_custom_woocommerce_output_related_products_args($args) {
        $args = array(
            'posts_per_page' => 3,
        );
        return $args;
    }
}
// filter custom add class to single product
add_filter('woocommerce_single_product_image_gallery_classes', 'thim_custom_woocommerce_single_product_image_gallery_classes',10,1);
if( !function_exists('thim_custom_woocommerce_single_product_image_gallery_classes') ) {
    function thim_custom_woocommerce_single_product_image_gallery_classes($arr) {
        array_push( $arr, 'media-product' );
        return $arr;
    }
}

add_filter( 'woocommerce_gallery_image_size', 'thim_custom_woocommerce_gallery_image_size' );
if( !function_exists( 'thim_custom_woocommerce_gallery_image_size' ) ) {
    function thim_custom_woocommerce_gallery_image_size() {
        return 'thim-single-product';
    }
}

add_filter( 'single_product_archive_thumbnail_size', 'thim_custom_single_product_archive_thumbnail_size' );
if( !function_exists( 'thim_custom_single_product_archive_thumbnail_size' ) ) {
    function thim_custom_single_product_archive_thumbnail_size($size) {
        $size = 'thim-single-product';
        return $size;
    }
}

add_action( 'woocommerce_add_to_cart_redirect', 'thim_remove_duplicate_products_redirect' );
function thim_remove_duplicate_products_redirect( $url = false ) {
    if( !empty( $url ) ) {
        return $url;
    }
    return add_query_arg( array(), remove_query_arg( 'add-to-cart' ) );
}