<?php
add_action( 'thim_loop_item_video_media', 'thim_video_add_loop_thumbnail', 10 );
if( !function_exists('thim_video_add_loop_thumbnail') ) {
    function thim_video_add_loop_thumbnail() {
        echo thim_feature_image(270,390, true);
        echo '<div class="overlay"></div>';
    }
}
add_action( 'thim_loop_item_video_media', 'thim_video_add_loop_meta', 15 );
if( !function_exists('thim_video_add_loop_meta') ) {
    function thim_video_add_loop_meta() {
        if( taxonomy_exists('type') ) {
            $type = wp_get_post_terms(get_the_ID(),'type');
        }
        ?>
        <div class="meta-info">
            <?php if( get_post_meta(get_the_ID(),'thim_video_meta_imdb',true) ) {?>
                <div class="imdb">
                    <span class="value"><?php echo get_post_meta(get_the_ID(),'thim_video_meta_imdb',true);?></span><?php echo esc_html__( 'IMDb', 'vividly' );?>
                </div>
            <?php }?>
            <?php if( !empty($type) ) {?>
                <div class="labels">
                    <?php foreach ($type as $item) {
                        $color = get_term_meta( $item->term_id, 'thim_type_color', true );
                        ?>
                        <div class="label"<?php echo ent2ncr($color) ? ' style="background-color: '.$color.';"' : ''; ?>>
                            <?php echo esc_html($item->name);?>
                        </div>
                    <?php }?>
                </div>
            <?php }?>
        </div>
        <?php
    }
}
add_action( 'thim_loop_item_video_media', 'thim_video_add_loop_icon_play', 20 );
if( !function_exists('thim_video_add_loop_icon_play') ) {
    function thim_video_add_loop_icon_play() {
        $key = rand(100,999);
        ?>
        <div id="box-video-<?php echo esc_attr($key);?>" class="mfp-with-anim mfp-hide frame-video-popup"></div>
        <?php if( get_post_meta(get_the_ID(),'thim_video_meta_player_sc',true) || get_post_meta(get_the_ID(),'thim_video_meta_player_iframe',true) ) {?>
            <a href="#box-video-<?php echo esc_attr($key);?>" class="btn-play" data-id="<?php echo get_the_ID();?>" data-effect="mfp-zoom-in"></a>
        <?php }?>
        <?php
    }
}
add_action( 'thim_loop_item_video_title', 'thim_video_add_loop_title', 10 );
if( !function_exists('thim_video_add_loop_title') ) {
    function thim_video_add_loop_title() {
        ?>
        <h4 class="title">
            <a href="<?php the_permalink();?>">
                <?php the_title();?>
            </a>
        </h4>
        <?php
    }
}
/**
 * Add filter to list videos page
 */
add_action( 'thim_before_list_videos', 'thim_add_filter_videos', 10 );
if( !function_exists( 'thim_add_filter_videos' ) ) {
    function thim_add_filter_videos() {
        $arr_cats = $arr_year = array();
        $page_video = get_page_by_path('videos');
        $cat_current = 0;
        if ( isset( $_GET['cat_id'] ) ) {
            $cat_current = $_GET['cat_id'];
        }
        $query = array(
            'posts_per_page'      => -1,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
            'tax_query' => array( array(
                'taxonomy' => 'post_format',
                'field' => 'slug',
                'terms' => array('post-format-video'),
            ) )
        );
        $all_videos = new WP_Query( $query );
        if ( $all_videos->have_posts() ) {
            while ( $all_videos->have_posts() ) : $all_videos->the_post();
                $categories = get_the_category();
                if ( ! empty( $categories ) ) {
                    foreach ($categories as $cat) {
                        if( !in_array($cat->term_id,$arr_cats) ) {
                            array_push($arr_cats,$cat->term_id);
                        }
                    }
                }
                if( !in_array(get_the_date('Y'),$arr_year) ) {
                    array_push($arr_year,get_the_date('Y'));
                }
            endwhile;
            wp_reset_postdata();
        }
        if($arr_cats) {
            ?>
            <div class="heading-element">
                <div class="wrap-filter-group">
                    <form method="get" class="form_filter_mobile" action="<?php echo esc_url(get_permalink($page_video));?>">
                        <select name="cat_id">
                            <option value=""><?php echo esc_html__('All', 'vividly');?></option>
                            <?php for($i=0;$i<count($arr_cats);$i++) {
                                $category = get_category( $arr_cats[$i] );
                                ?>
                                <option<?php echo esc_html($cat_current==$category->term_id) ? ' selected' : '';?> value="<?php echo esc_attr($category->term_id);?>"><?php echo esc_html($category->name);?></option>
                            <?php }?>
                        </select>
                    </form>
                    <div class="filter-tope-group">
                        <a class="item-tope <?php echo esc_attr($cat_current==0) ? 'active' : '';?>" href="<?php echo esc_url(get_permalink($page_video));?>">
                            <?php echo esc_html__('All', 'vividly');?>
                        </a>
                        <?php for($i=0;$i<count($arr_cats);$i++) {
                            $category = get_category( $arr_cats[$i] );
                            $cat_link = add_query_arg('cat_id', $category->term_id, get_permalink($page_video));
                            ?>
                            <a class="item-tope <?php echo esc_attr($cat_current==$category->term_id) ? 'active' : '';?>" href="<?php echo esc_url($cat_link);?>">
                                <?php echo esc_html($category->name);?>
                            </a>
                        <?php }?>
                    </div>
                </div>
                <div class="wrap-filter-videos js-filter-full-container">
                    <a href="#" class="toggle-filter">
                        <?php echo esc_html__('Filter videos', 'vividly');?>
                    </a>

                    <div class="content-filter">
                        <form action="" method="post">
                            <div class="row">
                                <div class="col-lg-2 col-md-4 col-sm-6">
                                    <label><?php echo esc_html__('Genre','vividly');?></label>
                                    <?php
                                    $genre = get_terms( 'genre', array(
                                        'hide_empty' => false,
                                    ) );
                                    if($genre) {
                                        ?>
                                        <ul>
                                            <?php foreach ($genre as $item) {
                                                ?>
                                                <li>
                                                    <input<?php if( isset( $_POST['type_genre'] ) && in_array($item->term_id,$_POST['type_genre']) ) echo ' checked';?> type="checkbox" name="type_genre[]" value="<?php echo esc_attr($item->term_id);?>"> <?php echo esc_html($item->name);?>
                                                </li>
                                            <?php }?>
                                        </ul>
                                    <?php }?>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-6">
                                    <label><?php echo esc_html__('Quality','vividly');?></label>
                                    <?php
                                    $quality = get_terms( 'quality', array(
                                        'hide_empty' => false,
                                    ) );
                                    if($quality) {
                                        ?>
                                        <ul>
                                            <?php foreach ($quality as $item) {
                                                ?>
                                                <li>
                                                    <input<?php if( isset( $_POST['type_quality'] ) && in_array($item->term_id,$_POST['type_quality']) ) echo ' checked';?> type="checkbox" name="type_quality[]" value="<?php echo esc_attr($item->term_id);?>"> <?php echo esc_html($item->name);?>
                                                </li>
                                            <?php }?>
                                        </ul>
                                    <?php }?>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-6">
                                    <label><?php echo esc_html__('Country','vividly');?></label>
                                    <?php
                                    $country = get_terms( 'country', array(
                                        'hide_empty' => false,
                                    ) );
                                    if($country) {
                                        ?>
                                        <ul>
                                            <?php foreach ($country as $item) {
                                                ?>
                                                <li>
                                                    <input<?php if( isset( $_POST['type_country'] ) && in_array($item->term_id,$_POST['type_country']) ) echo ' checked';?> type="checkbox" name="type_country[]" value="<?php echo esc_attr($item->term_id);?>"> <?php echo esc_html($item->name);?>
                                                </li>
                                            <?php }?>
                                        </ul>
                                    <?php }?>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-6">
                                    <label><?php echo esc_html__('Type','vividly');?></label>
                                    <?php
                                    $type = get_terms( 'type', array(
                                        'hide_empty' => false,
                                    ) );
                                    if($type) {
                                        ?>
                                        <ul>
                                            <?php foreach ($type as $item) {
                                                ?>
                                                <li>
                                                    <input<?php if( isset( $_POST['type_type'] ) && in_array($item->term_id,$_POST['type_type']) ) echo ' checked';?> type="checkbox" name="type_type[]" value="<?php echo esc_attr($item->term_id);?>"> <?php echo esc_html($item->name);?>
                                                </li>
                                            <?php }?>
                                        </ul>
                                    <?php }?>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-6">
                                    <label><?php echo esc_html__('Year','vividly');?></label>
                                    <?php
                                    $year = get_terms( 'thim_year', array(
                                        'hide_empty' => false,
                                    ) );
                                    if($year) {
                                        ?>
                                        <ul>
                                            <?php foreach ($year as $item) {
                                                ?>
                                                <li>
                                                    <input<?php if( isset( $_POST['type_year'] ) && in_array($item->term_id,$_POST['type_year']) ) echo ' checked';?> type="checkbox" name="type_year[]" value="<?php echo esc_attr($item->term_id);?>"> <?php echo esc_html($item->name);?>
                                                </li>
                                            <?php }?>
                                        </ul>
                                    <?php }?>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-6">
                                    <label><?php echo esc_html__('Rating','vividly');?></label>
                                    <?php
                                    $rating = get_terms( 'rating', array(
                                        'hide_empty' => false,
                                    ) );
                                    if($rating) {
                                        ?>
                                        <ul>
                                            <?php foreach ($rating as $item) {
                                                ?>
                                                <li>
                                                    <input<?php if( isset( $_POST['type_rating'] ) && in_array($item->term_id,$_POST['type_rating']) ) echo ' checked';?> type="checkbox" name="type_rating[]" value="<?php echo esc_attr($item->term_id);?>"> <?php echo esc_html($item->name);?>
                                                </li>
                                            <?php }?>
                                        </ul>
                                    <?php }?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-xs-12 text-center">
                                    <button type="submit" class="btn-primary btn-sm shape-round"><?php echo esc_html__('Filter videos', 'vividly');?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <?php
        }
    }
}

function thim_get_list_videos($number = 8) {
    $query = array(
        'posts_per_page'      => $number,
        'no_found_rows'       => true,
        'post_status'         => 'publish',
        'ignore_sticky_posts' => true,
        'tax_query' => array( array(
            'taxonomy' => 'post_format',
            'field' => 'slug',
            'terms' => array('post-format-video'),
        ) )
    );
    $cat_id = 0;
    if ( isset( $_GET['cat_id'] ) ) {
        $cat_id = $_GET['cat_id'];
    }
    $year = $gender = $type = $rating = $country = $quality = '';
    if ( isset( $_POST['type_year'] ) || isset( $_POST['type_genre'] ) || isset( $_POST['type_type'] ) || isset( $_POST['type_rating'] ) || isset( $_POST['type_country'] ) || isset( $_POST['type_quality'] ) ) {
        $query['tax_query'] = array(
            'relation' => 'AND',
        );
        if ( isset( $_POST['type_year'] ) ) {
            array_push($query['tax_query'], array(
                'taxonomy' => 'thim_year',
                'field' => 'term_id',
                'terms' => $_POST['type_year'],
            ));
        }
        if ( isset( $_POST['type_genre'] ) ) {
            array_push($query['tax_query'], array(
                'taxonomy' => 'genre',
                'field' => 'term_id',
                'terms' => $_POST['type_genre'],
            ));
        }
        if ( isset( $_POST['type_type'] ) ) {
            array_push($query['tax_query'], array(
                'taxonomy' => 'type',
                'field' => 'term_id',
                'terms' => $_POST['type_type'],
            ));
        }
        if ( isset( $_POST['type_rating'] ) ) {
            array_push($query['tax_query'], array(
                'taxonomy' => 'rating',
                'field' => 'term_id',
                'terms' => $_POST['type_rating'],
            ));
        }
        if ( isset( $_POST['type_country'] ) ) {
            array_push($query['tax_query'], array(
                'taxonomy' => 'country',
                'field' => 'term_id',
                'terms' => $_POST['type_country'],
            ));
        }
        if ( isset( $_POST['type_quality'] ) ) {
            array_push($query['tax_query'], array(
                'taxonomy' => 'quality',
                'field' => 'term_id',
                'terms' => $_POST['type_quality'],
            ));
        }
    }
    if ( $cat_id ) {
        $query['cat'] = $cat_id;
    }
    $videos = new WP_Query( $query );
    return $videos;
}