<?php
/**
 * Template Name: Authors Page
 *
 **/
$authors = thim_get_list_authors();
?>

<div class="thim-author_list-authors-page">
    <div class="authors-list">
        <div class="wrap-element">
            <?php
            /**
             * Hook: thim_before_list_authors.
             *
             */
            do_action( 'thim_before_list_authors' );
            ?>

            <?php if ( $authors ) { ?>
                <div class="row">
                <?php foreach ( $authors as $user ) { ?>
                    <?php
                    $bp_name = bp_core_get_userlink( $user->ID );
                    ?>
                    <div class="col-sm-6 col-md-3">
                        <div class="author-item">
                            <div class="pic-author">
                                <?php echo get_avatar($user->ID, 270);?>
                                <a href="<?php echo bp_core_get_user_domain( $user->ID );?>" class="overlay-author"></a>
                            </div>

                            <div class="text-author">
                                <h4 class="name-author">
                                    <?php echo ent2ncr($bp_name);?>
                                </h4>

                                <div class="info-author">
                                    Reporter
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }?>
                </div>
                <?php wp_reset_postdata(); ?>
            <?php }?>

            <?php
            /**
             * Hook: thim_after_list_authors.
             *
             */
            do_action( 'thim_after_list_authors' );
            ?>
        </div>
    </div>
</div>