<?php
/**
 * Footer template: Default
 *
 * @package Thim_Starter_Theme
 */
?>

<footer class="site-footer layout-1">
    <?php if ( get_theme_mod( 'footer_widgets', false ) ) : ?>
    <div class="footer-sidebars">
        <div class="container">
            <?php thim_footer_widgets(); ?>
        </div>
    </div>
    <?php endif;?>
    <?php if( get_theme_mod( 'copyright_bar', true ) || get_theme_mod( 'copyright_menu', true ) ) {?>
    <div class="copyright-area">
        <div class="container">
            <?php
            $col = ( get_theme_mod( 'copyright_bar', true ) && get_theme_mod( 'copyright_menu', true ) ) ? 'thim-2-col' : 'thim-1-col';
            ?>
            <div class="<?php echo esc_attr($col);?>">
                <div class="copyright-text">
                    <?php thim_copyright_bar(); ?>
                </div>
                <?php
                if( get_theme_mod( 'copyright_menu', false ) ) { ?>
                    <div class="copyright-menu">
                        <?php
                        wp_nav_menu(array(
                                'theme_location' => 'copyright_menu',
                                'container'      => false,
                                'items_wrap'     => '%3$s'
                            )
                        );
                        ?>
                    </div>
                <?php }?>
            </div>
        </div>
    </div>
    <?php }?>
</footer>