<?php
/**
 * Page Title Bar
 */

global $wp_query, $post;
$GLOBALS['post']      = $wp_query->post;
$thim_options         = get_theme_mods();
$thim_heading_top_src = $custom_title = $subtitle = $text_color = $sub_color = $bg_color = $front_title = $heading_padding_style = $sub_title = '';
$hide_breadcrumb      = $hide_title = $heading_padding_top = $heading_padding_bottom = 0;
$bg_opacity           = 1;

if ( get_post_type() == "post" ) {
    $prefix = 'blog_';
    if( get_post_format() == 'video' ) $prefix = 'videos_';
} elseif ( get_post_type() == "product" ) {
    $prefix = 'woo_';
} elseif ( class_exists( 'BuddyPress' ) && bp_is_user() ) {
    $prefix = 'author_';
} else {
    $prefix = '';
}

$cat_obj = $wp_query->get_queried_object();
if ( isset( $cat_obj->term_id ) ) {
	$cat_ID = $cat_obj->term_id;
} else {
	$cat_ID = "";
}

if ( isset( $thim_options['hide_page_title'] ) ) {
	$hide_title = get_theme_mod( 'hide_page_title', false );
}

if ( isset( $thim_options['disable_breadcrumb'] ) ) {
	$hide_breadcrumb = get_theme_mod( 'disable_breadcrumb' );
}

if ( isset( $thim_options['page_title_background_color'] ) ) {
	$bg_color = get_theme_mod( 'page_title_background_color' );
}

if ( isset( $thim_options['page_title_background_opacity'] ) ) {
	$bg_opacity =   get_theme_mod( 'page_title_background_opacity' );
}


//if ( isset( $thim_options['page_title_padding_top'] ) ) {
//	$heading_padding_top =   (float)get_theme_mod( 'page_title_padding_top' );
//}

if ( ( isset( $thim_options['page_title_background_image'] ) && get_theme_mod( 'page_title_background_image' ) <> '' ) ) {
	$thim_heading_top_img = get_theme_mod( 'page_title_background_image' );
	$thim_heading_top_src = $thim_heading_top_img; // For the default value

	if ( is_numeric( $thim_heading_top_img ) ) {
		$thim_heading_top_attachment = wp_get_attachment_image_src( $thim_heading_top_img, 'full' );
		$thim_heading_top_src        = $thim_heading_top_attachment[0];
	}
}

// Get Style From MTB
if ( is_page() || is_single() ) {
    if( is_single() || ( class_exists( 'BuddyPress' ) && bp_is_user() ) ) {
        if ( isset( $thim_options[ '' . $prefix . 'single_hide_page_title' ] ) ) {
			$hide_title = get_theme_mod( '' . $prefix . 'single_hide_page_title' );
        }
        if ( isset( $thim_options[ '' . $prefix . 'single_hide_breadcrumb' ] ) ) {
            $hide_breadcrumb = get_theme_mod( '' . $prefix . 'single_hide_breadcrumb' );
        }
        if ( ( isset( $thim_options['' . $prefix . 'single_heading_background_image'] ) && get_theme_mod( '' . $prefix . 'single_heading_background_image' ) <> '' ) ) {
            $thim_heading_top_img = get_theme_mod( '' . $prefix . 'single_heading_background_image' );
            $thim_heading_top_src = $thim_heading_top_img; // For the default value

            if ( is_numeric( $thim_heading_top_img ) ) {
                $thim_heading_top_attachment = wp_get_attachment_image_src( $thim_heading_top_img, 'full' );
                $thim_heading_top_src        = $thim_heading_top_attachment[0];
            }
        }
        if ( isset( $thim_options[ '' . $prefix . 'single_heading_background_color' ] ) ) {
            $bg_color = get_theme_mod( '' . $prefix . 'single_heading_background_color' );
        }
        if ( isset( $thim_options[ '' . $prefix . 'single_background_opacity' ] ) ) {
            $bg_opacity = (float) get_theme_mod( '' . $prefix . 'single_background_opacity' );
        }
        if ( isset( $thim_options[ '' . $prefix . 'single_sub_title' ] ) ) {
            $sub_title = get_theme_mod( '' . $prefix . 'single_sub_title' );
        }
        if ( isset( $thim_options[ '' . $prefix . 'single_padding_top' ] ) ) {
            $heading_padding_top = (float) get_theme_mod( '' . $prefix . 'single_padding_top' );
        }
        if ( isset( $thim_options[ '' . $prefix . 'single_padding_bottom' ] ) ) {
            $heading_padding_bottom = (float) get_theme_mod( '' . $prefix . 'single_padding_bottom' );
        }
        if( class_exists( 'BuddyPress' ) && bp_is_user() ) {
            $user_info = get_the_author_meta( 'thim_info', bp_displayed_user_id() );
            $sub_title = isset( $user_info['major'] ) ? $user_info['major'] : $sub_title;
        }
    }
	$postid               = get_the_ID();
	$using_custom_heading = get_post_meta( $postid, 'thim_enable_custom_title', true );

	if ( $using_custom_heading ) {
		$array_title = get_post_meta( $postid, 'thim_group_custom_title', false );
		$array_bg    = get_post_meta( $postid, 'thim_group_custom_background', false );

		if ( isset( $array_title[0] ) ) {
			if ( isset( $array_title[0]['thim_hide_title'] ) ) {
				$hide_title = $array_title[0]['thim_hide_title'];
			}
			if ( isset( $array_title[0]['thim_hide_breadcrumbs'] ) ) {
				$hide_breadcrumb = $array_title[0]['thim_hide_breadcrumbs'];
			}
			if ( isset( $array_title[0]['thim_custom_title'] ) ) {
				$custom_title = $array_title[0]['thim_custom_title'];
			}
			if ( isset( $array_title[0]['thim_custom_subtitle'] ) ) {
				$subtitle = $array_title[0]['thim_custom_subtitle'];
			}
			if ( isset( $array_title[0]['thim_color_title'] ) ) {
				$text_color_1 = $array_title[0]['thim_color_title'];
				if ( $text_color_1 <> '' ) {
					$text_color = $text_color_1;
				}
			}
			if ( isset( $array_title[0]['thim_color_subtitle'] ) ) {
				$sub_color_1 = $array_title[0]['thim_color_subtitle'];
				if ( $sub_color_1 <> '' ) {
					$sub_color = $sub_color_1;
				}
			}
		}

		if ( isset( $array_bg[0] ) ) {
			$bg_color_1 = isset( $array_bg[0]['thim_heading_background'] ) ? $array_bg[0]['thim_heading_background'] : '';
			$bg_opacity = isset( $array_bg[0]['thim_heading_background_opacity'] ) ? (float) $array_bg[0]['thim_heading_background_opacity'] : 1;
			if ( $bg_color_1 <> '' ) {
				$bg_color = $bg_color_1;
			}
			if ( isset( $array_bg[0]['thim_heading_image'] ) ) {
				$thim_heading_top_img        = $array_bg[0]['thim_heading_image'];
				$thim_heading_top_src        = $thim_heading_top_img[0];
				$thim_heading_top_attachment = wp_get_attachment_image_src( $thim_heading_top_img[0], 'full' );
				$thim_heading_top_src        = $thim_heading_top_attachment[0];
			}
		}

	}
} else {
     if ( isset( $thim_options[ '' . $prefix . 'archive_hide_page_title' ] ) ) {
		 $hide_title = get_theme_mod( '' . $prefix . 'archive_hide_page_title' );
    }
    if ( isset( $thim_options[ '' . $prefix . 'archive_hide_breadcrumb' ] ) ) {
        $hide_breadcrumb = get_theme_mod( '' . $prefix . 'archive_hide_breadcrumb' );
    }

    if ( ( isset( $thim_options['' . $prefix . 'archive_heading_background_image'] ) && get_theme_mod( '' . $prefix . 'archive_heading_background_image' ) <> '' ) ) {
        $thim_heading_top_img = get_theme_mod( '' . $prefix . 'archive_heading_background_image' );
        $thim_heading_top_src = $thim_heading_top_img; // For the default value

        if ( is_numeric( $thim_heading_top_img ) ) {
            $thim_heading_top_attachment = wp_get_attachment_image_src( $thim_heading_top_img, 'full' );
            $thim_heading_top_src        = $thim_heading_top_attachment[0];
        }
    }
    if ( isset( $thim_options[ '' . $prefix . 'archive_heading_background_color' ] ) ) {
        $bg_color = get_theme_mod( '' . $prefix . 'archive_heading_background_color' );
    }
    if ( isset( $thim_options[ '' . $prefix . 'archive_background_opacity' ] ) ) {
        $bg_opacity = (float) get_theme_mod( '' . $prefix . 'archive_background_opacity' );
    }
}
$hide_title      = ( $hide_title == '1' ) ? '1' : $hide_title;
$hide_breadcrumb = ( $hide_breadcrumb == '1' ) ? '1' : $hide_breadcrumb;


// style css
$c_css_style = $overlay_css_style = $title_css_style = $title_css = '';
$overlay_css_style .= ( $bg_color != '' ) ? 'background-color: ' . $bg_color . ';' : '';
$overlay_css_style .= ( $bg_color != '' ) ? 'opacity: ' . $bg_opacity . ';' : '';
$c_css_style .= ( $thim_heading_top_src != '' ) ? 'background-image:url(' . $thim_heading_top_src . ');' : '';
$heading_padding_style .= ($heading_padding_top) ? 'padding-top: ' . $heading_padding_top . 'px;' : '';
$heading_padding_style .= ($heading_padding_bottom) ? 'padding-bottom: ' . $heading_padding_bottom . 'px;' : '';

$title_css_style .= ( $text_color != '' ) ? 'color: ' . $text_color . ';' : '';
$c_css_sub_color = ( $sub_color != '' ) ? 'style="color:' . $sub_color . '"' : '';

$title_css   = ( $title_css_style != '' ) ? 'style="' . $title_css_style . '"' : '';

$c_css       = ( $c_css_style != '' ) ? 'style="' . $c_css_style . '"' : '';
$overlay_css = ( $overlay_css_style != '' ) ? 'style="' . $overlay_css_style . '"' : '';
$heading_padding_style = ( $heading_padding_style != '' ) ? 'style="' . $heading_padding_style . '"' : '';
$parallax    = get_theme_mod( 'enable_parallax_page_title', true ) ? ' data-stellar-background-ratio="0.5"' : '';
?>
<div class="page-title">
	<?php if ( $hide_title != '1' || $hide_breadcrumb != '1' ||  $sub_title) : ?>
		<div class="main-top" <?php echo ent2ncr( $c_css ); ?>  <?php echo ent2ncr( $parallax ); ?> >
			<span class="overlay-top-header" <?php echo ent2ncr( $overlay_css ); ?>></span>
 				<div class="content container" <?php echo ent2ncr($heading_padding_style);?>>
 					<?php if ( $hide_title != '1' ) : ?>

					<?php
                    $typography = 'h1 ' . $title_css;
					if ( ( is_category() || is_archive() || is_search() || is_404() ) ) {
						echo '<' . $typography . '>';
						echo thim_archive_title();
						echo '</' . $typography . '>';
						if ( category_description( $cat_ID ) != '' ) {
						} else {
							echo esc_html( $subtitle != '' ) ? '<div class="banner-description" ' . $c_css_sub_color . '><p>' . $subtitle . '</p></div>' : '';
						}
					} elseif ( is_page() || is_single() ) {
                        if ( is_single() ) {
                            if ( get_post_type() == "post" ) {
                                if ( $custom_title ) {
                                    $single_title = $custom_title;
                                } else {
                                    $single_title = ( get_post_format()=='video' && thim_plugin_active( 'Stellar-video-player', 'video-player.php' ) ) ? get_the_title() : esc_html__('Single Blog', 'vividly');
                                }
                                echo '<' . $typography . '>';
                                echo esc_html($custom_title != '') ? $custom_title : $single_title;
                                echo '</' . $typography . '>';
                            }
                            if ( get_post_type() == "product" ) {
                                echo '<' . $typography . '>' . esc_html__( 'Products', 'vividly' );
                                echo '</' . $typography . '>';
                            }
                        }else {
                            echo '<' . $typography . '>';
                            echo esc_html( $custom_title != '' ) ? $custom_title : get_the_title( get_the_ID() );
                            echo '</' . $typography . '>';
                        }

						echo esc_html( $subtitle != '' ) ? '<div class="banner-description" ' . $c_css_sub_color . '><p>' . $subtitle . '</p></div>' : '';
					} elseif ( is_front_page() || is_home() ) {
						echo '<h1>';
						echo esc_html( $front_title != '' ) ? $front_title : esc_html__( 'Blog', 'vividly' );
						echo '</h1>';
                        echo esc_html( $subtitle != '' ) ? '<div class="banner-description" ' . $c_css_sub_color . '><p>' . $subtitle . '</p></div>' : '';
					}
					?>
					<?php endif; ?>
                    <?php if( $sub_title ) { ?>
                        <div class="description"><?php echo esc_html($sub_title);?></div>
                    <?php }?>
                    <?php
                    if ( $hide_breadcrumb != '1' ) :?>
                        <?php
                        if ( ! is_front_page() || ! is_home() ) { ?>
                            <div class="wrap-breadcrumb">
                                    <?php
                                    if ( get_post_type() == 'product' ) {
                                        woocommerce_breadcrumb();
                                    } else {
                                        thim_breadcrumbs();
                                    }
                                    ?>
                            </div><!-- .breadcrumbs-wrapper -->
                        <?php }
                        ?>
                     <?php
                    endif;
                    ?>
				</div>

		</div><!-- .main-top -->
	<?php endif; ?>

</div><!-- .page-title -->