<?php
/**
 * Template Name: Submit Video
 *
 **/

?>

<div class="thim-form_submit-page">
    <div class="row justify-content-center">
        <div class="col-xl-10">
            <?php while ( have_posts() ) : the_post();?>
                <?php the_content();?>
            <?php endwhile;?>

            <div class="divline_submit-page"></div>

            <?php
            if(isset($_POST['post_title']) && $_POST['post_title']) {
                if( is_user_logged_in() ) {
                    $author_id = $_POST['user_id'];
                } else {
                    $userdata = array(
                        'user_login'  =>  $_POST['user_username'],
                        'user_email'  =>  $_POST['user_email'],
                        'first_name'  =>  $_POST['user_fname'],
                        'last_name'  =>  $_POST['user_lname'],
                    );
                    $author_id = wp_insert_user( $userdata );
                }
                $post_info = array(
                    'post_title' => wp_strip_all_tags( $_POST['post_title'] ),
                    'post_content' => $_POST['content'],
                    'post_author' => $author_id,
                    'post_type' => 'post',
                    'post_status'=>'pending',
                    'meta_input' => array('thim_video_meta_player_iframe' => $_POST['video_url']),
                    'tax_input'     => array('post_format' => 'post-format-video')
                );
                $pid = wp_insert_post( $post_info );
                if($_POST['post_tags']) {
                    wp_set_post_tags( $pid, $_POST['post_tags'], true );
                }

                if($_FILES['featured' ]["name"]) {
                    $uploaddir = wp_upload_dir();
                    $file = $_FILES['featured' ];
                    $uploadfile = $uploaddir['path'] . '/' . basename( $file['name'] );
                    move_uploaded_file( $file['tmp_name'] , $uploadfile );
                    $filename = basename( $uploadfile );
                    $wp_filetype = wp_check_filetype(basename($filename), null );
                    $attachment = array(
                        'post_mime_type' => $wp_filetype['type'],
                        'post_title' => preg_replace('/\.[^.]+$/', '', $filename),
                        'post_content' => '',
                        'post_status' => 'inherit',
                    );
                    $attach_id = wp_insert_attachment( $attachment, $uploadfile );
                    update_post_meta($pid,'_thumbnail_id',$attach_id);
                    set_post_thumbnail( $pid, $attach_id );
                }
                echo '<p class="message message-success align-center">'.esc_html__('Video add success', 'vividly').'</p>';
            } else {
                ?>
                <!-- Submit video form -->
                <form class="submit-video-form validate-form" action="" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <?php if( is_user_logged_in() ) {?>
                            <input type="hidden" name="user_id" value="<?php echo esc_attr(get_current_user_id());?>">
                        <?php } else {?>
                            <div class="col-md-6">
                                <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('First name', 'vividly');?>
                                </span>

                                    <label class="input-field">
                                        <input type="text" name="user_fname" autocomplete="off">
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('Last name','vividly');?>
                                </span>

                                    <label class="input-field">
                                        <input type="text" name="user_lname" autocomplete="off">
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('Username','vividly');?> *
                                </span>

                                    <label class="input-field require">
                                        <input type="text" name="user_username" autocomplete="off">
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('Email','vividly');?> *
                                </span>

                                    <label class="input-field require">
                                        <input type="text" name="user_email" autocomplete="off">
                                    </label>
                                </div>
                            </div>
                            <div class="divline-form"></div>
                        <?php }?>
                        <div class="col-md-12">
                            <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('Title Video','vividly');?> *
                                </span>

                                <label class="input-field require">
                                    <input type="text" name="post_title" autocomplete="off">
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('Video Content','vividly');?> *
                                </span>

                                <label class="input-field require">
                                    <textarea name="content"></textarea>
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('Video Tags','vividly');?>
                                </span>

                                <label class="input-field">
                                    <input type="text" name="post_tags" placeholder="<?php echo esc_attr__('Select existing tags', 'vividly');?>" autocomplete="off">
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="item-input input-choose-file">
                                <span class="input-title">
                                    <?php echo esc_html__('Featured image','vividly');?>
                                </span>

                                <label class="input-field">
                                    <?php echo esc_html__('Choose file','vividly');?>
                                    <input type="file" name="featured" id="featured" size="50">
                                </label>

                                <span class="input-file-value">
                                    <?php echo esc_html__('No file chosen','vividly');?>
                                </span>
                            </div>
                        </div>
                        <div class="divline-form"></div>
                        <div class="col-12">
                            <div class="item-input">
                                <span class="input-title">
                                    <?php echo esc_html__('Video URL (or embed)','vividly');?>
                                </span>

                                <label class="input-field">
                                    <textarea name="video_url"></textarea>
                                </label>
                            </div>
                        </div>
                    </div>

                    <button class="btn-submit btn-large shape-round">
                        <?php echo esc_html__('Submit video','vividly');?>
                    </button>
                </form>
                <!-- end Submit video form -->
                <?php
            }
            ?>
        </div>
    </div>
</div>
