<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */
global $class;
$thim_options = get_theme_mods();
$column = isset( $thim_options['archive_post_column'] ) ? get_theme_mod( 'archive_post_column' ) : 1;
if (has_post_format('aside')) {
    $class = 'aside-item';
} elseif (has_post_format('chat')) {
    $class = 'chat-item';
} elseif (has_post_format('gallery')) {
    $class = 'slide-item';
} elseif (has_post_format('image')) {
    $class = '';
} elseif (has_post_format('link')) {
    $class = 'link-item';
} elseif (has_post_format('quote')) {
    $class = 'quote-item';
}elseif (has_post_format('video')) {
    $class = 'video-item';
} elseif (has_post_format('audio')) {
    $class = 'audio-item';
}
else {
    $class = 'image-item';
}

// check haspost thumbnail
if(has_post_thumbnail()){
    $thumbnail = '';
}
else {
    $thumbnail = 'have-no-thumbnail';
}

$class  = 'grid-item item-blog'.' '. $class .' ' . $thumbnail;

if ( isset( $_GET['column'] ) ) {
    $class = 'grid-item item-blog'.' '. $class .' ' . $thumbnail;
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>
    <div class="entry-top media-item">
        <?php
        if ( class_exists( 'TP' ) ) {
            thim_entry_top_archive();
        } else {
            if ( has_post_thumbnail() ) {
                ?>
                <div class="post-thumbnail">
                    <?php the_post_thumbnail(); ?>
                </div><!-- .post-thumbnail -->
                <?php
            }
        }
        ?>
    </div><!-- .entry-top -->

        <?php
        if ( has_post_format( 'link' ) && thim_meta( 'thim_link_url' ) && thim_meta( 'thim_link_text' ) ) {
            $url  = thim_meta( 'thim_link_url' );
            $text = thim_meta( 'thim_link_text' );
            if ( $url && $text ) { ?>
                <header class="entry-header">
                    <h4 class="entry-title title">
                        <a class="link" href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $text ); ?></a>
                    </h4>
                </header><!-- .entry-header -->
                <?php
            }
            ?>
            <div class="entry-summary content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-summary -->

            <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-readmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>


            <?php if ( get_theme_mod( 'show_sharing', false ) ) :?>
                <div class="share">
                    <div class="wrap-text">
                        <span class="text">
                            <?php echo esc_html('SHARE THIS ARTICLE','vividly')?>
                        </span>
                        <span class="line"></span>
                    </div>
                    <?php do_action( 'thim_social_share' ); ?>
                </div>
            <?php endif; ?>

        <?php } elseif ( has_post_format( 'quote' ) && thim_meta( 'thim_quote_author_url' ) ) {

            $author     = thim_meta( 'thim_quote_author_text' );
            $author_url = thim_meta( 'thim_quote_author_url' );
            if ( $author_url ) {
                $author = ' <a href=' . esc_url( $author_url ) . '>' . $author . '</a>';
            }
            ?>
            <?php thim_entry_meta(); ?>

            <header class="entry-header">
                <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
            </header><!-- .entry-header -->


            <div class="entry-summary content">
                <?php if ( $author ) { ?>
                    <div class="box-header box-quote">
                        <blockquote><?php the_content(); ?><cite><?php echo wp_kses( $author, array(
                                    'a' => array(
                                        'href' => array(),
                                    )
                                ) ); ?></cite>
                        </blockquote>
                    </div>
                <?php } ?>
            </div><!-- .entry-summary -->

            <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-readmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>


            <?php if ( get_theme_mod( 'show_sharing', false ) ) :?>
                <div class="share">
                    <div class="wrap-text">
                        <span class="text">
                            <?php echo esc_html('SHARE THIS ARTICLE','vividly')?>
                        </span>
                        <span class="line"></span>
                    </div>
                    <?php do_action( 'thim_social_share' ); ?>
                </div>
            <?php endif; ?>

            <?php
        } elseif ( has_post_format( 'audio' ) ) { ?>
            <?php thim_entry_meta(); ?>

            <header class="entry-header">
                <div class="entry-meta">
                    <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
                </div>
            </header><!-- .entry-header -->

            <div class="entry-summary content">
                <?php
                the_excerpt();
                ?>
            </div><!-- .entry-summary -->

            <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-readmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>

            <?php if ( get_theme_mod( 'show_sharing', false ) ) :?>
                <div class="share">
                    <div class="wrap-text">
                        <span class="text">
                            <?php echo esc_html('SHARE THIS ARTICLE','vividly')?>
                        </span>
                        <span class="line"></span>
                    </div>
                    <?php do_action( 'thim_social_share' ); ?>
                </div>
            <?php endif; ?>
        <?php } elseif ( has_post_format( 'chat' ) ) { ?>
            <?php thim_entry_meta(); ?>

            <header class="entry-header">
                <div class="entry-meta">
                    <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
                </div>
            </header><!-- .entry-header -->

            <div class="entry-summary content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-summary -->

            <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-readmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>

            <?php if ( get_theme_mod( 'show_sharing', false ) ) :?>
                <div class="share">
                    <div class="wrap-text">
                        <span class="text">
                            <?php echo esc_html('SHARE THIS ARTICLE','vividly')?>
                        </span>
                        <span class="line"></span>
                    </div>


                    <?php do_action( 'thim_social_share' ); ?>

                </div>
            <?php endif; ?>
        <?php } else { ?>
            <?php thim_entry_meta(); ?>

            <header class="entry-header">
                <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
            </header>
            <!-- .entry-header -->

            <div class="entry-summary content">
                <?php
                the_excerpt();
                ?>
            </div><!-- .entry-summary -->

            <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-readmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>

            <?php if ( get_theme_mod( 'show_sharing', false ) ) :?>
                <div class="share">
                    <div class="wrap-text">
                        <span class="text">
                            <?php echo esc_html('SHARE THIS ARTICLE','vividly')?>
                        </span>
                        <span class="line"></span>
                    </div>

                        <?php do_action( 'thim_social_share' ); ?>

                </div>
            <?php endif; ?>
        <?php }
        ?>

</article><!-- #post-## -->
