<?php
/**
 * Template Name: Videos Page
 *
 **/
$cat_current = 0;
if ( isset( $_GET['cat_id'] ) ) {
    $cat_current = $_GET['cat_id'];
}
$videos = thim_get_list_videos(20);
?>

<div class="thim-videos_list-videos-page">
    <div class="videos-list">
        <div class="wrap-element">
            <?php
            /**
             * Hook: thim_before_list_videos.
             *
             * @hooked thim_add_filter_videos - 10
             */
            do_action( 'thim_before_list_videos' );
            ?>

            <?php if ( $videos->have_posts() ) { ?>
                <div class="row">
                <?php while ( $videos->have_posts() ) : $videos->the_post(); ?>
                    <div class="col-sm-6 col-md-3">
                        <div class="item-post">
                            <div class="pic-item">
                                <?php
                                /**
                                 * Hook: thim_loop_item_video_media.
                                 *
                                 * @hooked thim_video_add_loop_thumbnail - 10
                                 * @hooked thim_video_add_loop_meta - 15
                                 * @hooked thim_video_add_loop_icon_play - 20
                                 */
                                do_action( 'thim_loop_item_video_media' );
                                ?>
                            </div>
                            <div class="text-item">
                                <?php
                                /**
                                 * Hook: thim_loop_item_video_title.
                                 *
                                 * @hooked thim_video_add_loop_title - 10
                                 */
                                do_action( 'thim_loop_item_video_title' );
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile;?>
                </div>
                <?php wp_reset_postdata(); ?>
            <?php } else {?>
                <div class="message message-success"><?php echo esc_html__('No have video on result.','vividly');?></div>
            <?php } ?>

            <?php
            /**
             * Hook: thim_after_list_videos.
             *
             */
            do_action( 'thim_after_list_videos' );
            ?>
        </div>
    </div>
</div>