const path = require('path');
var WebpackNotifierPlugin = require('webpack-notifier');
const { VueLoaderPlugin } = require('vue-loader')
module.exports = {
    mode: 'development',
    entry: './assets/src/settings.js',
    output: {
        path: path.resolve(__dirname, '../dist/'),
        filename: 'traveler-settings.min.js'
    },
    module: {
        rules: [
            {
                test: /\.vue$/,
                loader: 'vue-loader',
                options: {
                    loaders: {
                        scss: 'vue-style-loader!css-loader!sass-loader', // <style lang="scss">
                        sass: 'vue-style-loader!css-loader!sass-loader?indentedSyntax' // <style lang="sass">
                    }
                }
            },
            {
                test: /\.js$/,
                loader: 'babel-loader',
                exclude: /node_modules/
            },
            {
                test: /\.less$/,
                use: [{
                    loader: 'style-loader' // creates style nodes from JS strings
                }, {
                    loader: 'css-loader' // translates CSS into CommonJS
                }, {
                    loader: 'less-loader' // compiles Less to CSS
                }]
            },
            {
                test: /\.scss$/,
                use: [{
                    loader: "style-loader" // creates style nodes from JS strings
                }, {
                    loader: "css-loader" // translates CSS into CommonJS
                }, {
                    loader: "sass-loader" // compiles Sass to CSS
                }]
            }
        ]
    },
    resolve: {
        extensions: ['*', '.js', '.vue', '.json']
    },
	plugins: [
		new WebpackNotifierPlugin(),
        new VueLoaderPlugin()
	],
};
