<?php

function ulc_settings_init() {
    register_setting('ulc', 'ulc_settings');

    add_settings_section(
        'ulc_section_developers',
        __('', 'ulc'),
        '',
        'ulc'
    );

    add_settings_field(
        'ulc_field_safe_redirect_disabled',
        __('Disable Links Redirect', 'ulc'),
        'ulc_field_safe_redirect_disabled_cb',
        'ulc',
        'ulc_section_developers',
        [
            'label_for' => 'ulc_field_safe_redirect_disabled',
            'class' => 'ulc_row',
        ]
    );
}

add_action('admin_init', 'ulc_settings_init');

function ulc_field_safe_redirect_disabled_cb($args) {
    $options = get_option('ulc_settings'); ?>
    <input type="checkbox" id="<?php echo esc_attr($args['label_for']); ?>" name="ulc_settings[<?php echo esc_attr($args['label_for']); ?>]" value="1" <?php echo !empty($options[$args['label_for']]) ? checked( 1, $options[$args['label_for']], false ) : ''; ?> />
    <label for="<?php echo esc_attr($args['label_for']); ?>">
        <?php esc_html_e('Check to disable safe redirect', 'ulc'); ?>
    </label>
 <?php
}

function ulc_settings_page() {
    add_submenu_page(
        'edit.php?post_type=ulc-link',
        'ULC Settings',
        'ULC Settings',
        'manage_options',
        'ulc-settings',
        'ulc_settings_page_html'
    );
}

add_action('admin_menu', 'ulc_settings_page');

function ulc_settings_page_html() {
    if (!current_user_can('manage_options')) {
        return;
    }

    if (isset($_GET['settings-updated'])) {
        add_settings_error('ulc_messages', 'ulc_message', __('Settings Saved', 'ulc'), 'updated');
    }

    settings_errors('ulc_messages');
    ?>
 <div class="wrap">
     <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
     <form action="options.php" method="post">
    <?php
    settings_fields('ulc');
    do_settings_sections('ulc');
    submit_button('Save Settings');
    ?>
    </form>
 </div>
 <?php
}