<?php
add_action('cmb2_admin_init', 'ulc_register_taxonomy_metabox');

function ulc_register_taxonomy_metabox()
{
    $prefix = 'ulc_link_type_';

    $cmb_term = new_cmb2_box(array(
        'id' => $prefix . 'edit',
        'title' => 'Category Metabox',
        'object_types' => array('term'),
        'taxonomies' => array('ulc-link-type'),
        'new_term_section' => true,
    ));


    //Image type
    $cmb_term->add_field( array(
        'name'             => 'Category image type',
        'id'               => $prefix . 'img_type',
        'type'             => 'radio',
        'show_option_none' => false,
        'default'          => 'font_icon',
        'options'          => array(
            'image'     => 'Upload image',
            'font_icon' => 'Font icon',
        ),
        'attributes'       => array(
            'required'       => 'required',
        ),
    ) );

    $cmb_term->add_field(array(
        'name' => 'Image',
        'desc' => 'Max Image size 80x80 px, (display size 36x36 px)',
        'id' => $prefix . 'logo_img',
        'type' => 'file',
        'attributes' => array(
            'required'               => true,
            'data-conditional-id'    => $prefix . 'img_type',
            'data-conditional-value' => 'image',
        ),
        'options' => array(
            'url' => false,
        ),
        'text' => array(
            'add_upload_file_text' => 'Add File'
        ),
    ) );


    $cmb_term->add_field(array(
        'name' => 'Icon FontAswsome',
        'desc' => '',
        'id' => $prefix . 'icon',
        'type' => 'fontawesome_icon',
        'default' => 'fa-link',
        'attributes' => array(
            'required'               => true,
            'data-conditional-id'    => $prefix . 'img_type',
            'data-conditional-value' => 'font_icon',
        ),
    ));

    $cmb_term->add_field(array(
        'name' => 'Icon color',
        'desc' => '',
        'id' => $prefix . 'icon_color',
        'type' => 'colorpicker',
        'default' => '#ffffff',
        'attributes' => array(
            'required'               => true,
            'data-conditional-id'    => $prefix . 'img_type',
            'data-conditional-value' => 'font_icon',
        ),
    ));

    $cmb_term->add_field(array(
        'name' => 'Icon background color',
        'desc' => '',
        'id' => $prefix . 'bg_icon',
        'type' => 'colorpicker',
        'default' => '#1e73be',
        'attributes' => array(
            'required'               => true,
            'data-conditional-id'    => $prefix . 'img_type',
            'data-conditional-value' => 'font_icon',
        ),
    ));

}

?>