<?php
if (!defined('ABSPATH')) {
	exit;
}

class VI_WNOTIFICATION_Admin_OpenAi {
	protected $settings;
	protected $api_key;
	protected $ai_openai_version;
	protected $ai_openai_model;

	public function __construct() {
		$this->settings        = VI_WNOTIFICATION_Data::get_instance();
		$this->api_key         = $this->settings->get_params('ai_openai_api_key');
		$this->ai_openai_model = $this->settings->get_params('ai_openai_model');
	}


	public function get_model_list() {
		if (!$this->api_key) {
			return false;
		}
		$args            = array();
		$url             = "https://api.openai.com/v1/models";
		$headers         = [
			'Content-Type'  => 'application/json',
			'Authorization' => 'Bearer ' . $this->api_key,
		];
		$args['headers'] = $headers;
		try {
			$r = wp_remote_get($url, $args);

			$body        = wp_remote_retrieve_body($r);
			$models      = json_decode($body)->data ?? [];
			$list_models = array();
			if (!empty($models)) {
				foreach ($models as $model) {
					$list_models[] = [
						'id' => $model->id,
					];
				}
			}

			return $list_models;

		} catch (\Exception $e) {
			return false;
		}

	}

	public function generator( $type = '', $language = '' ) {
		if (!$this->api_key) {
			return '';
		}
		if (!$type) {
			return '';
		}
		$key_render = '';
		switch ($type) {
			case 'mess_purchase':
				$key_render = $this->settings->get_params('ai_openai_key_purchase_mess');
				if ($language) {
					$key_render = $this->settings->get_params('ai_openai_key_purchase_mess_' . $language);
				}
				break;
			case 'first_name':
				$key_render = $this->settings->get_params('ai_openai_key_virtual_first_name');
				if ($language) {
					$key_render = $this->settings->get_params('ai_openai_key_virtual_first_name_' . $language);
				}
				break;
			case 'city':
				$key_render = $this->settings->get_params('ai_openai_key_virtual_city');
				if ($language) {
					$key_render = $this->settings->get_params('ai_openai_key_virtual_city_' . $language);
				}
				break;
			default:
				break;
		}
		$r_data         = [
			'writing_style'  => $this->settings->get_params('ai_command_writing_style'),
			'writing_tone'   => $this->settings->get_params('ai_command_writing_tone'),
			'min_characters' => $this->settings->get_params('ai_command_min_characters'),
			'max_characters' => $this->settings->get_params('ai_command_max_characters'),
		];
		$key_render     = $this->settings->ai_command_replace_shortcodes($key_render, $r_data);
		$headers_openai = [
			'Authorization' => 'Bearer ' . $this->api_key,
			'Content-Type'  => 'application/json',
		];
		$data_openai    = [
			'model'   => $this->ai_openai_model,
			"messages" => [
				[
					"role"    => "user",
					"content" => $key_render
				]
			],
			'stop'        => '',
			'n'           => 1,
		];
		$args           = [
			'headers' => $headers_openai,
			'body'    => json_encode($data_openai),
			'timeout' => 120
		];
		try {
			$res = wp_remote_post('https://api.openai.com/v1/chat/completions', $args);

			$body = wp_remote_retrieve_body($res);
			if (
				'application/json' === wp_remote_retrieve_header( $res, 'content-type' )||
				'application/json; charset=utf-8' === wp_remote_retrieve_header( $res, 'content-type' )
			) {
				$data = json_decode( $body, true );
			} else {
				$data = $body;
			}
			if (
				!empty($data) &&
				is_array($data) &&
				isset($data['choices']) &&
				is_array($data['choices']) &&
				isset($data['choices'][0]) &&
				isset($data['choices'][0]['message']) &&
				is_array($data['choices'][0]['message']) &&
				isset($data['choices'][0]['message']['content']) &&
				!is_array($data['choices'][0]['message']['content'])
			) {
				return $data['choices'][0]['message']['content'] ?? '';
			}


			return '';
		} catch (\Exception $e) {
			return '';
		}

	}


}
