<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class VI_WNOTIFICATION_Admin_Settings {

    public static $setting;
    public static $VI_WNOTIFICATION_Admin_Gemini;
    public static $VI_WNOTIFICATION_Admin_OpenAI;

    public function __construct() {
        self::$setting = VI_WNOTIFICATION_Data::get_instance();
        add_action( 'admin_init', [ $this, 'save_meta_boxes' ] );
        add_action( 'wp_ajax_wcn_search_product', [ $this, 'search_product' ] );
        add_action( 'wp_ajax_wcn_search_product_parent', [ $this, 'search_product_parent' ] );
        add_action( 'wp_ajax_wcn_search_cate', [ $this, 'search_cate' ] );
        add_action( 'wp_ajax_ai_generator', [ $this, 'ai_generator' ] );
        self::$VI_WNOTIFICATION_Admin_Gemini = new VI_WNOTIFICATION_Admin_Gemini();
        self::$VI_WNOTIFICATION_Admin_OpenAI = new VI_WNOTIFICATION_Admin_OpenAi();
    }

    /**
     * Search product category ajax
     */

    public function search_cate() {
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        ob_start();
        $keyword = isset( $_GET['keyword'] ) ? sanitize_text_field( $_GET['keyword'] ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

        if ( empty( $keyword ) ) {
            die();
        }
        $categories = get_terms( [
            'taxonomy' => 'product_cat',
            'orderby'  => 'name',
            'order'    => 'ASC',
            'search'   => $keyword,
            'number'   => 100,
        ] );
        $items      = [];
        if ( count( $categories ) ) {
            foreach ( $categories as $category ) {
                $item    = [
                    'id'   => $category->term_id,
                    'text' => $category->name,
                ];
                $items[] = $item;
            }
        }
        wp_send_json( $items );
        die;
    }

    /*Ajax Product Search*/
    public function search_product( $x = '', $post_types = [ 'product' ] ) {
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        ob_start();

        $keyword = isset( $_GET['keyword'] ) ? sanitize_text_field( $_GET['keyword'] ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

        if ( empty( $keyword ) ) {
            die();
        }
        $arg            = [
            'post_status'    => 'publish',
            'post_type'      => $post_types,
            'posts_per_page' => 50,
            's'              => $keyword,

        ];
        $the_query      = new WP_Query( $arg );
        $found_products = [];
        if ( $the_query->have_posts() ) {
            while ( $the_query->have_posts() ) {
                $the_query->the_post();
                $prd           = wc_get_product( get_the_ID() );
                $product_id    = get_the_ID();
                $product_title = get_the_title() . '(#' . $product_id . ')';
                $the_product   = new WC_Product( $product_id );
                if ( ! $the_product->is_in_stock() ) {
                    $product_title .= ' (out-of-stock)';
                }

                if ( $prd->has_child() && $prd->is_type( 'variable' ) ) {
                    $product_title    .= '(#VARIABLE)';
                    $product          = [ 'id' => $product_id, 'text' => $product_title ];
                    $found_products[] = $product;
                    $product_children = $prd->get_children();
                    if ( count( $product_children ) ) {
                        foreach ( $product_children as $product_child ) {
                            if ( woocommerce_version_check() ) {
                                $product = [
                                    'id'   => $product_child,
                                    'text' => get_the_title( $product_child ) . '(#' . $product_child . ')',
                                ];
                            } else {
                                $child_wc  = wc_get_product( $product_child );
                                $get_atts  = $child_wc->get_variation_attributes();
                                $attr_name = array_values( $get_atts )[0];
                                $product   = [
                                    'id'   => $product_child,
                                    'text' => get_the_title() . ' - ' . $attr_name,
                                ];
                            }
                            $found_products[] = $product;
                        }
                    }
                } else {
                    $product          = [ 'id' => $product_id, 'text' => $product_title ];
                    $found_products[] = $product;
                }
            }
        }
        wp_send_json( $found_products );
        die;
    }

    /*Ajax Product Search*/
    public function search_product_parent( $x = '', $post_types = [ 'product' ] ) {
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        ob_start();

        $keyword = isset( $_GET['keyword'] ) ? sanitize_text_field( $_GET['keyword'] ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

        if ( empty( $keyword ) ) {
            die();
        }
        $arg            = [
            'post_status'    => 'publish',
            'post_type'      => $post_types,
            'posts_per_page' => 50,
            's'              => $keyword,

        ];
        $the_query      = new WP_Query( $arg );
        $found_products = [];
        if ( $the_query->have_posts() ) {
            while ( $the_query->have_posts() ) {
                $the_query->the_post();

                $product_id    = get_the_ID();
                $product_title = get_the_title() . '(#' . $product_id . ')';
                $the_product   = wc_get_product( $product_id );
                if ( $the_product->is_type( 'variation' ) ) {
                    continue;
                }
                if ( ! $the_product->is_in_stock() ) {
                    $product_title .= ' (out-of-stock)';
                }
                $product          = [ 'id' => $product_id, 'text' => $product_title ];
                $found_products[] = $product;
            }
        }
        wp_send_json( $found_products );
        die;
    }

    /*Ajax Generator via AI*/
    public function ai_generator() {
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        if ( ! check_ajax_referer( 'woocommerce_notification_admin_nonce', 'nonce', false ) ) {
            wp_send_json_error( 'invalid_nonce' );
        }
        $result = [ 'status' => 'error' ];
        $type   = isset( $_POST['type'] ) ? sanitize_text_field( $_POST['type'] ) : '';
        $lang   = isset( $_POST['lang'] ) ? sanitize_text_field( $_POST['lang'] ) : '';
        $ai     = isset( $_POST['ai_engineering'] ) ? sanitize_text_field( $_POST['ai_engineering'] ) : '';
        if ( empty( $ai ) ) {
            $result = [ 'message' => 'error' ];
            wp_send_json( $result );
        }
        switch ( $ai ) {
            case 'gemini':
                $ai_gemini = self::$VI_WNOTIFICATION_Admin_Gemini->generator( $type, $lang );
                if ( ! empty( $ai_gemini ) ) {
                    $result['content_generator'] = $ai_gemini;
                    $result['status']            = 'success';
                }
                break;
            case 'openai':
                $ai_openai = self::$VI_WNOTIFICATION_Admin_OpenAI->generator( $type, $lang );
                if ( ! empty( $ai_openai ) ) {
                    $result['content_generator'] = $ai_openai;
                    $result['status']            = 'success';
                }
                break;
        }


        wp_send_json( $result );
        die;
    }

    /**
     * Get files in directory
     *
     * @param $dir
     *
     * @return array|bool
     */
    static private function scan_dir( $dir ) {
        $ignored = [ '.', '..', '.svn', '.htaccess', 'test-log.log' ];

        $files = [];
        foreach ( scandir( $dir ) as $file ) {
            if ( in_array( $file, $ignored ) ) {
                continue;
            }
            $files[ $file ] = filemtime( $dir . '/' . $file );
        }
        arsort( $files );
        $files = array_keys( $files );

        return ( $files ) ? $files : false;
    }

    private function stripslashes_deep( $value ) {
        $value = is_array( $value ) ? array_map( 'stripslashes_deep', $value ) : stripslashes( $value );

        return $value;
    }

    /**
     * Save post meta
     *
     *
     * @return mixed
     */
    public function save_meta_boxes() {
        global $woocommerce_notification_settings;
        if ( ! isset( $_POST['_wnotification_nonce'] ) || ! isset( $_POST['wnotification_params'] ) ) {
            return;
        }
        if ( ! wp_verify_nonce( sanitize_text_field( $_POST['_wnotification_nonce'] ), 'wnotification_save_email_settings' ) ) {
            return;
        }
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        $data                      = wc_clean( $_POST['wnotification_params'] );
        $data['message_purchased'] = $this->stripslashes_deep( $data['message_purchased'] );
        $data['custom_shortcode']  = $this->stripslashes_deep( $data['custom_shortcode'] );
        $data['name_by_country']   = $this->stripslashes_deep( $data['name_by_country'] ?? [] );
        $data['enable']            = $data['enable'] ?? 0;
        $data['enable_mobile']     = $data['enable_mobile'] ?? 0;
        $data['preview_rating']    = $data['preview_rating'] ?? 0;
        $data['preview_atc']       = $data['preview_atc'] ?? 0;
        $data['non_ajax']          = $data['non_ajax'] ?? 0;
        $data['close_icon_style']  = isset( $data['close_icon_style'] ) ? sanitize_text_field( wp_unslash( $data['close_icon_style'] ) ) : 0;

        /* Because name contain slashes, need to handle separately*/
        $args         = array(
            'virtual_name',
            'conditional_tags',
            'virtual_city',
            'custom_css',
            'virtual_country',
        );
        $languages    = [];
        $default_lang = '';
        if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
            $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );
            if ( ! empty( $langs ) ) {
                foreach ( $langs as $key => $language ) {
                    if ( ! empty( $language['active'] ) ) {
                        $default_lang = $key;
                    }
                    $languages[] = $key;
                }
            }
        } elseif ( class_exists( 'Polylang' ) ) {
            $languages    = pll_languages_list();
            $default_lang = pll_default_language( 'slug' );
        }
        if ( ! empty( $languages ) && $default_lang ) {
            foreach ( $languages as $language ) {
                if ( $language == $default_lang ) {
                    continue;
                }
                $args[] = 'virtual_name_' . $language;
                $args[] = 'virtual_city_' . $language;
                $args[] = 'virtual_country_' . $language;
            }
        }

        foreach ( $args as $field ) {
            $data[ $field ] = isset( $_POST['wnotification_params'][ $field ] ) ? wp_kses_post( $this->stripslashes_deep( $_POST['wnotification_params'][ $field ] ) ) : "";
        }

        update_option( '_woocommerce_notification_prefix', substr( md5( gmdate( "YmdHis" ) ), 0, 10 ) );

        if ( isset( $data['check_key'] ) ) {
            unset( $data['check_key'] );
            delete_transient( 'update_plugins' );
            delete_transient( 'villatheme_item_5846' );
            delete_option( 'woocommerce-notification_messages' );
            do_action( 'villatheme_save_and_check_key_woocommerce-notification', $data['key'] );
        }
        //delete
        $data ['avartar_user_enable']             = $woocommerce_notification_settings['avartar_user_enable'] ?? '';
        $data ['avartar_count_notify']            = $woocommerce_notification_settings['avartar_count_notify'] ?? '3';
        $data ['avartar_message_title']           = $woocommerce_notification_settings['avartar_message_title'] ?? '';
        $data ['avartar_message_in_single']       = $woocommerce_notification_settings['avartar_message_in_single'] ?? '';
        $data ['avartar_message_in_archive_page'] = $woocommerce_notification_settings['avartar_message_in_archive_page'] ?? '';
        //delete
        update_option( 'wnotification_params', $data );

        if ( is_plugin_active( 'wp-fastest-cache/wpFastestCache.php' ) ) {
            $cache = new WpFastestCache();
            $cache->deleteCache( true );
        }

        $woocommerce_notification_settings = $data;
    }

    /**
     * Set Nonce
     *
     * @return void
     */
    protected static function set_nonce() {
        wp_nonce_field( 'wnotification_save_email_settings', '_wnotification_nonce' );
    }

    /**
     * Set field in meta box
     *
     * @param      $field
     * @param bool $multi
     *
     * @return string
     */
    protected static function set_field( $field, $multi = false ) {
        if ( $field ) {
            if ( $multi ) {
                return 'wnotification_params[' . $field . '][]';
            } else {
                return 'wnotification_params[' . $field . ']';
            }
        } else {
            return '';
        }
    }

    /**
     * Get Post Meta
     *
     * @param $field
     * @param string $default
     *
     * @return bool
     */
    public static function get_field( $field, $default = '' ) {
        return self::$setting->get_params( $field, $default );
    }

    /**
     *
     */

    public static function page_callback() {
        self::$setting = VI_WNOTIFICATION_Data::get_instance( true );
        $ai_types      = [
            'gemini' => esc_html__( 'Gemini', 'woocommerce-notification' ),
            'openai' => esc_html__( 'Open AI', 'woocommerce-notification' )
        ];

        $get_ai_type = self::get_field( 'ai_type' );
        if ( ! is_array( $get_ai_type ) ) {
            $get_ai_type = (array) $get_ai_type;
        }

        ?>
        <div class="wrap woocommerce-notification">
            <h2><?php esc_html_e( 'WooCommerce Notification Settings', 'woocommerce-notification' ) ?></h2>
            <form method="post" action="" class="vi-ui form small">
                <?php self::set_nonce() ?>

                <div class="vi-ui attached tabular menu">
                    <div class="item active" data-tab="general">
                        <a href="#general"><?php esc_html_e( 'General', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="design">
                        <a href="#design"><?php esc_html_e( 'Design', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="messages">
                        <a href="#messages"><?php esc_html_e( 'Messages', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="products">
                        <a href="#products"><?php esc_html_e( 'Products', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="product-detail">
                        <a href="#product-detail"><?php esc_html_e( 'Product Detail', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="time">
                        <a href="#time"><?php esc_html_e( 'Time', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="sound">
                        <a href="#sound"><?php esc_html_e( 'Sound', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="assign">
                        <a href="#assign"><?php esc_html_e( 'Assign', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="logs">
                        <a href="#logs"><?php esc_html_e( 'Report', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="ai-engine">
                        <a href="#ai-engine"><?php esc_html_e( 'AI Engine', 'woocommerce-notification' ) ?></a>
                    </div>
                    <div class="item" data-tab="update">
                        <a href="#update"><?php esc_html_e( 'Update', 'woocommerce-notification' ) ?></a>
                    </div>
                </div>
                <!--General-->
                <div class="vi-ui bottom attached tab segment active" data-tab="general">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'enable' ) ) ?>">
                                    <?php esc_html_e( 'Enable', 'woocommerce-notification' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'enable' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'enable' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'enable' ) ) ?>"/>
                                    <label></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'enable_mobile' ) ) ?>">
                                    <?php esc_html_e( 'Mobile', 'woocommerce-notification' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'enable_mobile' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'enable_mobile' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'enable_mobile' ) ) ?>"/>
                                    <label></label>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!--Products-->
                <div class="vi-ui bottom attached tab segment" data-tab="products">
                    <!-- Tab Content !-->
                    <?php
                    $product_visibility = self::get_field( 'product_visibility', [ 'visible', 'catalog', 'search' ] );
                    ?>
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Show Products', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <select name="<?php echo esc_attr( self::set_field( 'archive_page' ) ) ?>"
                                        class="vi-ui fluid dropdown">
                                    <option <?php selected( self::get_field( 'archive_page' ), 0 ) ?>
                                            value="0"><?php esc_attr_e( 'Get from Billing', 'woocommerce-notification' ) ?></option>
                                    <option <?php selected( self::get_field( 'archive_page' ), 1 ) ?>
                                            value="1"><?php esc_attr_e( 'Select Products', 'woocommerce-notification' ) ?></option>
                                    <option <?php selected( self::get_field( 'archive_page' ), 2 ) ?>
                                            value="2"><?php esc_attr_e( 'Latest Products', 'woocommerce-notification' ) ?></option>
                                    <option <?php selected( self::get_field( 'archive_page' ), 3 ) ?>
                                            value="3"><?php esc_attr_e( 'Select Categories', 'woocommerce-notification' ) ?></option>
                                    <option <?php selected( self::get_field( 'archive_page' ), 4 ) ?>
                                            value="4"><?php esc_attr_e( 'Recently Viewed Products', 'woocommerce-notification' ) ?></option>
                                </select>

                                <p class="description"><?php esc_html_e( 'Select a product type to display on Notification.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Mask Customer Info', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'mask_customer_info' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'mask_customer_info' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'mask_customer_info' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description">
                                    <?php esc_html_e( 'Enable this option to partially mask sensitive order information such as customer name and address using the * character. Example: admin => ad**n.', 'woocommerce-notification' ); ?>
                                </p>
                            </td>
                        </tr>
                        <tr class="select-categories vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'Select Categories', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <?php
                                $cates = self::get_field( 'select_categories', [] ); ?>
                                <select multiple="multiple"
                                        name="<?php echo esc_attr( self::set_field( 'select_categories', true ) ) ?>"
                                        class="category-search"
                                        placeholder="<?php esc_attr_e( 'Please select category', 'woocommerce-notification' ) ?>">
                                    <?php
                                    if ( count( $cates ) ) {
                                        $categories = get_terms( [
                                            'taxonomy' => 'product_cat',
                                            'include'  => $cates,
                                        ] );
                                        if ( count( $categories ) ) {
                                            foreach ( $categories as $category ) { ?>
                                                <option selected="selected"
                                                        value="<?php echo esc_attr( $category->term_id ) ?>"><?php echo esc_html( $category->name ) ?></option>
                                                <?php
                                            }
                                        }
                                    } ?>
                                </select>
                            </td>
                        </tr>
                        <tr class="vi_hidden select-categories">
                            <th scope="row">
                                <label><?php esc_html_e( 'Exclude Products', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <?php $products = self::get_field( 'cate_exclude_products', [] ); ?>
                                <select multiple="multiple"
                                        name="<?php echo esc_attr( self::set_field( 'cate_exclude_products', true ) ) ?>"
                                        class="product-search-parent">
                                    <?php if ( count( $products ) ) {
                                        $args_p      = [
                                            'post_type'      => [ 'product' ],
                                            'post_status'    => 'publish',
                                            'post__in'       => $products,
                                            'posts_per_page' => - 1,
                                        ];
                                        $the_query_p = new WP_Query( $args_p );
                                        if ( $the_query_p->have_posts() ) {
                                            $products = $the_query_p->posts;
                                            foreach ( $products as $product ) {
                                                $data = wc_get_product( $product );
                                                if ( $data ) {
                                                    $product_id = $data->get_id();
                                                    if ( woocommerce_version_check() ) {
                                                        if ( $data->get_type() == 'variation' ) {
                                                            $name_prd = $data->get_name();
                                                        } else {
                                                            $name_prd = $data->get_title();
                                                        }
                                                        $name_prd .= '(#' . $product_id . ')';
                                                        if ( ! $data->is_in_stock() ) {
                                                            $name_prd .= ' (out-of-stock)';
                                                        }
                                                    } else {
                                                        $prd_var_title = $data->post->post_title;
                                                        $prd_var_title .= '(#' . $product_id . ')';
                                                        if ( $data->get_type() == 'variation' ) {
                                                            $prd_var_attr = $data->get_variation_attributes();
                                                            $attr_name1   = array_values( $prd_var_attr )[0];
                                                            $name_prd     = $prd_var_title . ' - ' . $attr_name1;
                                                        } else {
                                                            $name_prd = $prd_var_title;
                                                        }
                                                    }
                                                    if ( $data->is_type( 'variable' ) ) {
                                                        $name_prd .= '(#VARIABLE)';
                                                    }
                                                    ?>
                                                    <option selected="selected"
                                                            value="<?php echo esc_attr( $product_id ) ?>"><?php echo esc_html( $name_prd ) ?></option>
                                                    <?php
                                                }
                                            }
                                        }
                                        // Reset Post Data
                                        wp_reset_postdata();
                                    } ?>
                                </select>

                                <p class="description"><?php esc_html_e( 'These products will not display on notification.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="get_from_billing vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'From order', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <?php
                                $order_statuses = self::get_field( 'order_statuses', [ 'wc-completed' ] );
                                $statuses       = wc_get_order_statuses();

                                ?>
                                <div class="vi-ui field">
                                    <select multiple="multiple"
                                            name="<?php echo esc_attr( self::set_field( 'order_statuses', true ) ) ?>"
                                            class="vi-ui fluid dropdown">
                                        <?php foreach ( $statuses as $k => $status ) {
                                            $selected = '';
                                            if ( in_array( $k, $order_statuses ) ) {
                                                $selected = 'selected="selected"';
                                            }
                                            ?>
                                            <option <?php echo esc_attr( $selected ); ?>
                                                    value="<?php echo esc_attr( $k ) ?>"><?php echo esc_html( $status ) ?></option>
                                        <?php } ?>
                                    </select>
                                    <p class="description"><?php esc_html_e( 'Order status', 'woocommerce-notification' ) ?></p>
                                </div>
                                <div class="field vi-ui">
                                    <div class="vi-ui right labeled input">
                                        <input type="number" min="0"
                                               value="<?php echo esc_attr( self::get_field( 'order_threshold_num', 30 ) ) ?>"
                                               name="<?php echo esc_attr( self::set_field( 'order_threshold_num' ) ) ?>"
                                               class="vi-ui fluid right twelve wide"
                                        />
                                        <select name="<?php echo esc_attr( self::set_field( 'order_threshold_time' ) ) ?>"
                                                class="vi-ui dropdown label">
                                            <option <?php selected( self::get_field( 'order_threshold_time' ), 0 ) ?>
                                                    value="0"><?php esc_attr_e( 'Hours', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'order_threshold_time', 1 ), 1 ) ?>
                                                    value="1"><?php esc_attr_e( 'Days', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'order_threshold_time' ), 2 ) ?>
                                                    value="2"><?php esc_attr_e( 'Minutes', 'woocommerce-notification' ) ?></option>
                                        </select>
                                    </div>
                                    <p class="description"><?php esc_html_e( 'Actual products displayed on the notification will get from the orders placed within this period of time.  ', 'woocommerce-notification' ) ?></p>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Product image size', 'woocommerce-notification' ) ?></label>
                            </th>

                            <td>
                                <?php
                                $additional_image_sizes = wp_get_additional_image_sizes();
                                $default_image_sizes    = [ 'thumbnail', 'medium', 'medium_large', 'large' ];
                                $image_sizes            = [];

                                foreach ( $default_image_sizes as $size ) {
                                    $image_sizes[ $size ] = [
                                        'width'  => (int) get_option( $size . '_size_w' ),
                                        'height' => (int) get_option( $size . '_size_h' ),
                                        'crop'   => (bool) get_option( $size . '_crop' ),
                                    ];
                                }

                                if ( $additional_image_sizes ) {
                                    $image_sizes = array_merge( $image_sizes, $additional_image_sizes );
                                }

                                $image_sizes['full'] = [];

                                ?>
                                <select name="<?php echo esc_attr( self::set_field( 'product_sizes' ) ) ?>"
                                        class="vi-ui fluid dropdown">

                                    <?php
                                    $selected_product_sizes = self::get_field( 'product_sizes' );
                                    $mapping                = [
                                        'shop_thumbnail' => 'woocommerce_thumbnail',
                                        'shop_catalog'   => 'woocommerce_gallery_thumbnail',
                                        'shop_single'    => 'woocommerce_single',
                                    ];
                                    if ( isset( $mapping[ $selected_product_sizes ] ) ) {
                                        $selected_product_sizes = $mapping[ $selected_product_sizes ];
                                    }

                                    foreach ( $image_sizes as $slug => $info ) {
                                        $display_size = ! empty( $info['width'] ) ? " - {$info['width']}" : '';
                                        $display_size .= ! empty( $info['height'] ) ? "x{$info['height']}" : '';

                                        printf( "<option value='%s' %s>%s</option>", esc_attr( $slug ), selected( $selected_product_sizes, $slug, false ), esc_html( $slug . $display_size ) );
                                    }
                                    ?>
                                </select>

                                <p class="description"><?php esc_html_e( 'Choose a size for product images on the notification, get from one of these size source', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label
                                        for="<?php echo esc_attr( self::set_field( 'Show Products' ) ) ?>"><?php esc_html_e( 'Show Products', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="field">
                                    <select name="<?php echo esc_attr( self::set_field( 'product_visibility', true ) ) ?>"
                                            class="vi-ui fluid dropdown" multiple>
                                        <option <?php selected( in_array( 'visible', $product_visibility ), true ) ?>
                                                value="visible"><?php esc_attr_e( 'Shop and search results', 'woocommerce-notification' ) ?></option>
                                        <option <?php selected( in_array( 'catalog', $product_visibility ), true ) ?>
                                                value="catalog"><?php esc_attr_e( 'Shop only', 'woocommerce-notification' ) ?></option>
                                        <option <?php selected( in_array( 'search', $product_visibility ), true ) ?>
                                                value="search"><?php esc_attr_e( 'Search results only', 'woocommerce-notification' ) ?></option>
                                        <option <?php selected( in_array( 'hidden', $product_visibility ), true ) ?>
                                                value="hidden"><?php esc_attr_e( 'Hidden', 'woocommerce-notification' ) ?></option>
                                    </select>
                                    <p class="description"><?php esc_html_e( 'Products which have this product visibility status will appear on Notification.', 'woocommerce-notification' ) ?></p>
                                </div>
                                <div class="vi-ui three fields">
                                    <div class="field">
                                        <label
                                                for="<?php echo esc_attr( self::set_field( 'enable_current_category' ) ) ?>"><?php esc_html_e( 'Current category', 'woocommerce-notification' ) ?></label>
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'enable_current_category' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'enable_current_category' ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'enable_current_category' ) ) ?>"/>
                                            <label></label>
                                        </div>
                                        <p class="description"><?php esc_html_e( 'Display products in the same category with the being displayed product.', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field">
                                        <label
                                                for="<?php echo esc_attr( self::set_field( 'enable_out_of_stock_product' ) ) ?>"><?php esc_html_e( 'Out-of-stock products', 'woocommerce-notification' ) ?></label>
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'enable_out_of_stock_product' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'enable_out_of_stock_product' ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'enable_out_of_stock_product' ) ) ?>"/>
                                            <label></label>
                                        </div>
                                        <p class="description"><?php esc_html_e( 'Turn on to show out-of-stock products on notifications.', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field">
                                        <label for="<?php echo esc_attr( self::set_field( 'product_link' ) ) ?>"><?php esc_html_e( 'External link', 'woocommerce-notification' ) ?></label>
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'product_link' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'product_link' ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'product_link' ) ) ?>"/>
                                            <label></label>
                                        </div>
                                        <p class="description"><?php esc_html_e( 'Working with  External/Affiliate product. Product link is product URL.', 'woocommerce-notification' ) ?></p>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr class="vi_hidden latest-product-select-categories">
                            <th scope="row">
                                <label><?php esc_html_e( 'Product limit', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <input id="<?php echo esc_attr( self::set_field( 'limit_product' ) ) ?>" type="number"
                                       tabindex="0"
                                       min="0"
                                       value="<?php echo esc_attr( self::get_field( 'limit_product', 50 ) ) ?>"
                                       name="<?php echo esc_attr( self::set_field( 'limit_product' ) ) ?>"/>

                                <p class="description"><?php esc_html_e( 'The maximum number of product is displayed in Notification got from the list of latest products.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="select_product vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'Virtual Time', 'woocommerce-notification' ) ?></label></th>
                            <td>
                                <div class="two fields">
                                    <div class="field">
                                        <div class="vi-ui fluid right labeled input">
                                            <input type="number"
                                                   name="<?php echo esc_attr( self::set_field( 'virtual_time' ) ) ?>"
                                                   min="0"
                                                   value="<?php echo esc_attr( self::get_field( 'virtual_time', '10' ) ) ?>"/>
                                            <label class="vi-ui label"><?php esc_html_e( 'hours', 'woocommerce-notification' ) ?></label>
                                        </div>
                                        <p class="description"><?php esc_html_e( 'Virtual time will randomly get in this threshold.', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'change_virtual_time_enable' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'change_virtual_time_enable' ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'change_virtual_time_enable' ) ) ?>"/>
                                            <label></label>
                                        </div>
                                        <p class="description"><?php esc_html_e( 'Enable to change the virtual time matched your site’s timezone.', 'woocommerce-notification' ) ?></p>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <!--	Select Categories-->
                        <tr class="vi_hidden exclude_products">
                            <th scope="row">
                                <label><?php esc_html_e( 'Exclude Products', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <?php $products = self::get_field( 'exclude_products', [] ); ?>
                                <select multiple="multiple"
                                        name="<?php echo esc_attr( self::set_field( 'exclude_products', true ) ) ?>"
                                        class="product-search-parent">
                                    <?php if ( count( $products ) ) {
                                        $args_p      = [
                                            'post_type'      => [ 'product', 'product_variation' ],
                                            'post_status'    => 'publish',
                                            'post__in'       => $products,
                                            'posts_per_page' => - 1,
                                        ];
                                        $the_query_p = new WP_Query( $args_p );
                                        if ( $the_query_p->have_posts() ) {
                                            $products = $the_query_p->posts;
                                            foreach ( $products as $product ) {
                                                $data = wc_get_product( $product );
                                                if ( $data ) {
                                                    $product_id = $data->get_id();
                                                    if ( woocommerce_version_check() ) {
                                                        if ( $data->get_type() == 'variation' ) {
                                                            $name_prd = $data->get_name();
                                                        } else {
                                                            $name_prd = $data->get_title();
                                                        }
                                                        $name_prd .= '(#' . $product_id . ')';
                                                        if ( ! $data->is_in_stock() ) {
                                                            $name_prd .= ' (out-of-stock)';
                                                        }
                                                    } else {
                                                        $prd_var_title = $data->post->post_title;
                                                        $prd_var_title .= '(#' . $product_id . ')';
                                                        if ( $data->get_type() == 'variation' ) {
                                                            $prd_var_attr = $data->get_variation_attributes();
                                                            $attr_name1   = array_values( $prd_var_attr )[0];
                                                            $name_prd     = $prd_var_title . ' - ' . $attr_name1;
                                                        } else {
                                                            $name_prd = $prd_var_title;
                                                        }
                                                    }
                                                    if ( $data->is_type( 'variable' ) ) {
                                                        $name_prd .= '(#VARIABLE)';
                                                    }

                                                    ?>
                                                    <option selected="selected"
                                                            value="<?php echo esc_attr( $product_id ) ?>"><?php echo esc_html( $name_prd ) ?></option>
                                                    <?php
                                                }
                                            }
                                        }
                                        // Reset Post Data
                                        wp_reset_postdata();
                                    } ?>
                                </select>

                                <p class="description"><?php esc_html_e( 'These products will not show on notification.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>

                        <tr class="select_only_product vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'Select Products', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <?php
                                $products_ach = self::get_field( 'archive_products', [] ); ?>
                                <select multiple="multiple"
                                        name="<?php echo esc_attr( self::set_field( 'archive_products', true ) ) ?>"
                                        class="product-search"
                                        placeholder="<?php esc_attr_e( 'Please select products', 'woocommerce-notification' ) ?>">
                                    <?php if ( count( $products_ach ) ) {
                                        $args_p      = [
                                            'post_type'      => [ 'product', 'product_variation' ],
                                            'post_status'    => 'publish',
                                            'post__in'       => $products_ach,
                                            'posts_per_page' => - 1,
                                        ];
                                        $the_query_p = new WP_Query( $args_p );
                                        if ( $the_query_p->have_posts() ) {
                                            $products_ach = $the_query_p->posts;
                                            foreach ( $products_ach as $product_ach ) {
                                                $data_ach = wc_get_product( $product_ach );
                                                if ( woocommerce_version_check() ) {
                                                    if ( $data_ach->get_type() == 'variation' ) {
                                                        $name_prd = $data_ach->get_name();
                                                    } else {
                                                        $name_prd = $data_ach->get_title();
                                                    }
                                                    if ( ! $data_ach->is_in_stock() ) {
                                                        $name_prd .= ' (out-of-stock)';
                                                    }
                                                } else {
                                                    $prd_var_title = $data_ach->post->post_title;
                                                    if ( $data_ach->get_type() == 'variation' ) {
                                                        $prd_var_attr = $data_ach->get_variation_attributes();
                                                        $attr_name1   = array_values( $prd_var_attr )[0];
                                                        $name_prd     = $prd_var_title . ' - ' . $attr_name1;
                                                    } else {
                                                        $name_prd = $prd_var_title;
                                                    }
                                                }
                                                if ( $data_ach ) { ?>
                                                    <option selected="selected"
                                                            value="<?php echo esc_attr( $data_ach->get_id() ); ?>"><?php echo esc_html( $name_prd ); ?></option>
                                                <?php }
                                            }
                                        }
                                        // Reset Post Data
                                        wp_reset_postdata();
                                    } ?>
                                </select>
                            </td>
                        </tr>
                        <tr class="select_product vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'Virtual First Name', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <?php
                                $first_names = self::get_field( 'virtual_name' )
                                ?>
                                <textarea name="<?php echo esc_attr( self::set_field( 'virtual_name' ) ) ?>"><?php echo esc_html( $first_names ) ?></textarea>
                                <div class="container_gen_text">
                                    <?php
                                    foreach ( $get_ai_type as $ai_type ) {
                                        if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                            ?>
                                            <div class="wrap_gen_text">
                                                <ul></ul>
                                                <span class="vi-ui button generate-message blue" data-type="first_name" data-language="" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                                <p class="description"><?php esc_html_e( 'Create virtual first names displayed on Notification. Each name in a row.', 'woocommerce-notification' ) ?></p>
                                <?php
                                /*WPML.org*/
                                if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                    $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                    if ( count( $languages ) ) {
                                        foreach ( $languages as $key => $language ) {
                                            if ( $language['active'] ) {
                                                continue;
                                            }
                                            $wpml_name = self::get_field( 'virtual_name_' . $key );
                                            if ( ! $wpml_name ) {
                                                $wpml_name = $first_names;
                                            }
                                            ?>
                                            <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                            <textarea name="<?php echo esc_attr( self::set_field( 'virtual_name_' . $key ) ) ?>"><?php echo esc_html( $wpml_name ) ?></textarea>
                                            <div class="container_gen_text">
                                                <?php
                                                foreach ( $get_ai_type as $ai_type ) {
                                                    if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                                        ?>
                                                        <div class="wrap_gen_text">
                                                            <ul></ul>
                                                            <span class="vi-ui button generate-message blue" data-type="first_name" data-language="<?php echo esc_attr( $key ) ?>" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                                        </div>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </div>
                                        <?php }
                                    }
                                } /*Polylang*/ elseif ( class_exists( 'Polylang' ) ) {
                                    $languages = pll_languages_list();

                                    foreach ( $languages as $language ) {
                                        $default_lang = pll_default_language( 'slug' );

                                        if ( $language == $default_lang ) {
                                            continue;
                                        }
                                        $wpml_name = self::get_field( 'virtual_name_' . $language );
                                        if ( ! $wpml_name ) {
                                            $wpml_name = $first_names;
                                        }
                                        ?>
                                        <h4><?php echo esc_html( $language ) ?></h4>
                                        <textarea name="<?php echo esc_attr( self::set_field( 'virtual_name_' . $language ) ) ?>"><?php echo esc_html( $wpml_name ) ?></textarea>
                                        <div class="container_gen_text">
                                            <?php
                                            foreach ( $get_ai_type as $ai_type ) {
                                                if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                                    ?>
                                                    <div class="wrap_gen_text">
                                                        <ul></ul>
                                                        <span class="vi-ui button generate-message blue" data-type="first_name" data-language="<?php echo esc_attr( $language ) ?>" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                                    </div>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <?php
                                    }
                                }
                                ?>
                            </td>
                        </tr>

                        <tr class="select_product vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'Address', 'woocommerce-notification' ) ?></label></th>
                            <td>
                                <select name="<?php echo esc_attr( self::set_field( 'country' ) ) ?>"
                                        class="vi-ui fluid dropdown">
                                    <option <?php selected( self::get_field( 'country' ), 0 ) ?>
                                            value="0"><?php esc_attr_e( 'Auto Detect', 'woocommerce-notification' ) ?></option>
                                    <option <?php selected( self::get_field( 'country' ), 2 ) ?>
                                            value="2"><?php esc_attr_e( 'WooCommerce Geolocation', 'woocommerce-notification' ) ?></option>
                                    <option <?php selected( self::get_field( 'country' ), 1 ) ?>
                                            value="1"><?php esc_attr_e( 'Virtual', 'woocommerce-notification' ) ?></option>
                                </select>
                                <p class="description"><?php esc_html_e( 'You can use auto detect address or make virtual address of customer.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="wn-name-by-country">
                            <th scope="row">
                                <label><?php esc_html_e( 'Name by country', 'woocommerce-notification' ) ?></label></th>
                            <td>
                                <table class="vi-ui table wn-name-by-country-list fluid">
                                    <colgroup>
                                        <col/>
                                        <col/>
                                        <col width="10%"/>
                                    </colgroup>
                                    <thead>
                                    <tr>
                                        <th><?php esc_html_e( 'Names', 'woocommerce-notification' ) ?></th>
                                        <th><?php esc_html_e( 'Countries', 'woocommerce-notification' ) ?></th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $name_by_countries = self::get_field( 'name_by_country' );
                                    if ( ! empty( $name_by_countries ) && is_array( $name_by_countries ) ) {
                                        foreach ( $name_by_countries as $i => $name_by_country ) {
                                            ?>
                                            <tr class="wn-name-by-country-row">
                                                <td>
                                                    <textarea rows="3" name="wnotification_params[name_by_country][<?php echo esc_attr( $i ) ?>][names]"
                                                    ><?php echo esc_attr( $name_by_country['names'] ?? '' ) ?></textarea>
                                                </td>
                                                <td>
                                                    <select class="wn-name-by-country-row-countries vi-ui dropdown fluid"
                                                            name="wnotification_params[name_by_country][<?php echo esc_attr( $i ) ?>][countries][]" multiple>
                                                        <?php
                                                        $wc_countries = $countries = WC()->countries->get_countries();
                                                        if ( ! empty( $wc_countries ) ) {
                                                            foreach ( $wc_countries as $country_code => $country_name ) {
                                                                $saved_countries = (array) $name_by_country['countries'] ?? [];
                                                                $selected        = in_array( $country_code, $saved_countries ) ? 'selected' : '';
                                                                printf( '<option value="%s" %s>%s</option>', esc_attr( $country_code ), esc_attr( $selected ), esc_html( $country_name ) );
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                                <td><span class="vi-ui icon button mini red wn-name-by-country-remove"><i class="icon x"> </i></span></td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                    </tbody>
                                </table>
                                <span class="wn-add-name-by-country vi-ui icon button small"><i class="icon plus"> </i></span>

                                <!--Modal-->
                                <div class="vi-ui small wn-modal-generate-name-by-country modal transition hidden">
                                    <div class="header">
                                        <?php esc_html_e( 'Generate name by country', 'woocommerce-notification' ); ?>
                                    </div>
                                    <div class="content">
                                        <table class="form-table">
                                            <tr>
                                                <th><?php esc_html_e( 'Quantity', 'woocommerce-notification' ); ?></th>
                                                <td>
                                                    <input type="number" value="10" min="0" class="wn-generate-name-quantity vi-ui input fluid">
                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php esc_html_e( 'Gender', 'woocommerce-notification' ); ?></th>
                                                <td>
                                                    <select class="wn-generate-name-gender vi-ui dropdown fluid">
                                                        <option value="both"><?php esc_html_e( 'Both of male and female', 'woocommerce-notification' ); ?></option>
                                                        <option value="male"><?php esc_html_e( 'Male', 'woocommerce-notification' ); ?></option>
                                                        <option value="female"><?php esc_html_e( 'Female', 'woocommerce-notification' ); ?></option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php esc_html_e( 'Language', 'woocommerce-notification' ); ?></th>
                                                <td>
                                                    <select class="wn-generate-name-language vi-ui dropdown fluid">

                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th><?php esc_html_e( 'Countries', 'woocommerce-notification' ); ?></th>
                                                <td>
                                                    <select class="wn-generate-name-countries vi-ui dropdown fluid" multiple>
                                                        <option value=""><?php esc_html_e( 'Select countries', 'woocommerce-notification' ); ?></option>
                                                        <?php
                                                        $wc_countries = WC()->countries->get_countries();
                                                        if ( ! empty( $wc_countries ) ) {
                                                            $wc_country = explode( ':', get_option( 'woocommerce_default_country', 'US:CA' ) )[0] ?? '';
                                                            foreach ( $wc_countries as $country_code => $country_name ) {
                                                                echo wp_kses( sprintf( '<option value="%s" %s >%s</option>', $country_code, selected( $country_code, $wc_country ), $country_name ),
                                                                    [ 'option' => [ 'value' => 1, 'selected' => 1, 'data-*' => 1 ] ] );
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="actions">
                                        <div class="vi-ui positive button wn-do-generate">
                                            <?php esc_html_e( 'Generate', 'woocommerce-notification' ); ?>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>

                        <tr class="virtual_address vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'Virtual City', 'woocommerce-notification' ) ?></label></th>
                            <td>
                                <?php
                                $virtual_city = self::get_field( 'virtual_city' );
                                ?>
                                <textarea name="<?php echo esc_attr( self::set_field( 'virtual_city' ) ) ?>"><?php echo esc_attr( $virtual_city ) ?></textarea>
                                <div class="container_gen_text">
                                    <?php
                                    foreach ( $get_ai_type as $ai_type ) {
                                        if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                            ?>
                                            <div class="wrap_gen_text">
                                                <ul></ul>
                                                <span class="vi-ui button generate-message blue" data-type="city" data-language="" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                                <p class="description"><?php esc_html_e( 'Create virtual city names displayed on Notification. Each name in a row', 'woocommerce-notification' ) ?></p>
                                <?php
                                /*WPML.org*/
                                if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                    $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                    if ( count( $languages ) ) {
                                        foreach ( $languages as $key => $language ) {
                                            if ( $language['active'] ) {
                                                continue;
                                            }
                                            $wpml_city = self::get_field( 'virtual_city_' . $key );
                                            if ( ! $wpml_city ) {
                                                $wpml_city = $virtual_city;
                                            }
                                            ?>
                                            <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                            <textarea name="<?php echo esc_attr( self::set_field( 'virtual_city_' . $key ) ) ?>"><?php echo esc_html( $wpml_city ) ?></textarea>
                                            <div class="container_gen_text">
                                                <?php
                                                foreach ( $get_ai_type as $ai_type ) {
                                                    if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                                        ?>
                                                        <div class="wrap_gen_text">
                                                            <ul></ul>
                                                            <span class="vi-ui button generate-message blue" data-type="city" data-language="<?php echo esc_attr( $key ); ?>" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                                        </div>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                    }
                                } elseif ( class_exists( 'Polylang' ) ) {
                                    /*Polylang*/
                                    $languages = pll_languages_list();

                                    foreach ( $languages as $language ) {
                                        $default_lang = pll_default_language( 'slug' );

                                        if ( $language == $default_lang ) {
                                            continue;
                                        }

                                        $wpml_city = self::get_field( 'virtual_city_' . $language );
                                        if ( ! $wpml_city ) {
                                            $wpml_city = $virtual_city;
                                        }
                                        ?>
                                        <h4><?php echo esc_html( $language ) ?></h4>
                                        <textarea name="<?php echo esc_attr( self::set_field( 'virtual_city_' . $language ) ) ?>"><?php echo esc_html( $wpml_city ) ?></textarea>
                                        <div class="container_gen_text">
                                            <?php
                                            foreach ( $get_ai_type as $ai_type ) {
                                                if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                                    ?>
                                                    <div class="wrap_gen_text">
                                                        <ul></ul>
                                                        <span class="vi-ui button generate-message blue" data-type="city" data-language="<?php echo esc_attr( $language ); ?>" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                                    </div>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <?php
                                    }
                                } ?>
                            </td>
                        </tr>
                        <tr class="virtual_address vi_hidden">
                            <th scope="row">
                                <label><?php esc_html_e( 'Virtual Country', 'woocommerce-notification' ) ?></label></th>
                            <td>
                                <?php $virtual_country = self::get_field( 'virtual_country' ) ?>
                                <input type="text" name="<?php echo esc_attr( self::set_field( 'virtual_country' ) ) ?>"
                                       value="<?php echo esc_attr( $virtual_country ) ?>"/>

                                <p class="description"><?php esc_html_e( 'Display a virtual country name shown on notification.', 'woocommerce-notification' ) ?></p>
                                <?php /*WPML.org*/
                                if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                    $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                    if ( count( $languages ) ) {
                                        foreach ( $languages as $key => $language ) {
                                            if ( $language['active'] ) {
                                                continue;
                                            }
                                            $wpml_country = self::get_field( 'virtual_country_' . $key );
                                            if ( ! $wpml_country ) {
                                                $wpml_country = $virtual_country;
                                            }
                                            ?>
                                            <label><?php echo esc_html( $language['native_name'] ) ?></label>
                                            <input type="text"
                                                   name="<?php echo esc_attr( self::set_field( 'virtual_country_' . $key ) ) ?>"
                                                   value="<?php echo esc_attr( $wpml_country ) ?>"/>
                                        <?php }
                                    }
                                } elseif ( class_exists( 'Polylang' ) ) {
                                    $languages = pll_languages_list();

                                    foreach ( $languages as $language ) {
                                        //										$cur_language = pll_current_language( 'slug' );
                                        $default_lang = pll_default_language( 'slug' );

                                        if ( $language == $default_lang ) {
                                            continue;
                                        }
                                        $wpml_country = self::get_field( 'virtual_country_' . $language );
                                        if ( ! $wpml_country ) {
                                            $wpml_country = $virtual_country;
                                        }
                                        ?>
                                        <h4><?php echo esc_html( $language ) ?></h4>
                                        <input type="text"
                                               name="<?php echo esc_attr( self::set_field( 'virtual_country_' . $language ) ) ?>"
                                               value="<?php echo esc_attr( $wpml_country ) ?>"/>
                                        <?php
                                    }
                                } ?>
                            </td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'non_ajax' ) ) ?>"><?php esc_html_e( 'Non Ajax', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'non_ajax' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'non_ajax' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'non_ajax' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Enable to not load popup notification using Ajax, your site will load faster if cache is being used. This option will not apply for the “Get product from billing” feature and the options in Product detail tab.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!-- Product detail !-->
                <div class="vi-ui bottom attached tab segment" data-tab="product-detail">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label
                                        for="<?php echo esc_attr( self::set_field( 'enable_single_product' ) ) ?>"><?php esc_html_e( 'Run single product', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'enable_single_product' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'enable_single_product' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'enable_single_product' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Enable, the Notification will only display the currently viewed product or products in the same category on single product page.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label
                                        for="<?php echo esc_attr( self::set_field( 'notification_product_show_type' ) ) ?>"><?php esc_html_e( 'Notification show', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>

                                <select name="<?php echo esc_attr( self::set_field( 'notification_product_show_type' ) ) ?>"
                                        class="vi-ui fluid dropdown">
                                    <option <?php selected( self::get_field( 'notification_product_show_type', 0 ), '0' ) ?>
                                            value="0"><?php echo esc_html__( 'Current product', 'woocommerce-notification' ) ?></option>
                                    <option <?php selected( self::get_field( 'notification_product_show_type' ) ) ?>
                                            value="1"><?php echo esc_html__( 'Products in the same category', 'woocommerce-notification' ) ?></option>
                                </select>

                                <p class="description"><?php esc_html_e( 'In product single page, Notification can only display current product or other products in the same category.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="only_current_product vi_hidden">
                            <th scope="row">
                                <label
                                        for="<?php echo esc_attr( self::set_field( 'show_variation' ) ) ?>"><?php esc_html_e( 'Show variation', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'show_variation' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'show_variation' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'show_variation' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Show variation instead of product variable.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>

                        </tbody>
                    </table>
                </div>
                <!-- Design !-->
                <div class="vi-ui bottom attached tab segment" data-tab="design">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Templates', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="wn-slider-wrapper">
                                    <div class="wn-slider-slides">
                                        <?php
                                        $b_images = woocommerce_notification_background_images();
                                        foreach ( $b_images as $k => $b_image ) {
                                            $value = $k;
                                            if ( 'none' === $k ) {
                                                $value = 0;
                                            }
                                            $bg_name = str_replace( 'v1', 'basic', $k );
                                            ?>
                                            <div class="wn-slider-item">
                                                <input id="<?php echo esc_attr( 'background_image_' . $k ) ?>"
                                                       type="radio" <?php echo checked( self::get_field( 'background_image' ), $value ) ?>
                                                       class="vi_hidden input"
                                                       value="<?php echo esc_attr( $value ) ?>"
                                                       name="<?php echo esc_attr( self::set_field( 'background_image' ) ) ?>"/>
                                                <label class="vi-ui center aligned wn-slider-item__info" for="<?php echo esc_attr( 'background_image_' . $k ) ?>">
                                                    <div class="wn-slider-item__info-bg">
                                                        <img src="<?php echo esc_url( $b_image ) ?>"/>
                                                    </div>
                                                    <div class="wn-slider-item__info-name">
                                                        <span>
                                                            <?php echo esc_html( ucwords( str_replace( '_', ' ', esc_attr( $bg_name ) ) ) ) ?>
                                                        </span>
                                                    </div>
                                                </label>
                                            </div>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="wn-all-templates">
                                    <div class="wn-view-all-tmpl">
                                        <?php esc_html_e( 'See all', 'woocommerce-notification' ) ?>
                                    </div>
                                    <div class="vi-ui modal wn-all-tmpl-modal">
                                        <span class="close wn-close-all-tmpl-modal"></span>
                                        <div class="header"><?php esc_html_e( 'All Templates', 'woocommerce-notification' ) ?></div>
                                        <div class="content">
                                            <div class="vi-ui three column grid">
                                                <div class="row">
                                                    <?php
                                                    $b_images = woocommerce_notification_background_images();
                                                    foreach ( $b_images as $k => $b_image ) {
                                                        $value = $k;
                                                        if ( 'none' === $k ) {
                                                            $value = '0';
                                                        }
                                                        $bg_name = str_replace( 'v1', 'basic', $k );
                                                        ?>
                                                        <div class="wn-slider-item column <?php echo self::get_field( 'background_image' ) === $value ? 'active' : '' ?>">
                                                            <label class="vi-ui center aligned wn-slider-item__info" for="<?php echo esc_attr( 'background_image_' . $k ) ?>">
                                                                <div class="wn-slider-item__info-bg">
                                                                    <img src="<?php echo esc_url( $b_image ) ?>"/>
                                                                </div>
                                                                <div class="wn-slider-item__info-name">
                                                                    <span>
                                                                        <?php echo esc_html( ucwords( str_replace( '_', ' ', $bg_name ) ) ) ?>
                                                                    </span>
                                                                </div>
                                                            </label>
                                                        </div>
                                                        <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Position & effect', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="equal width fields">
                                    <div class="field">
                                        <select name="<?php echo esc_attr( self::set_field( 'position' ) ) ?>"
                                                class="vi-ui fluid dropdown">
                                            <option <?php selected( self::get_field( 'position', 0 ), 0 ) ?>
                                                    value="0"><?php esc_attr_e( 'Bottom left', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'position' ), 1 ) ?>
                                                    value="1"><?php esc_attr_e( 'Bottom right', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'position' ), 2 ) ?>
                                                    value="2"><?php esc_attr_e( 'Top left', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'position' ), 3 ) ?>
                                                    value="3"><?php esc_attr_e( 'Top right', 'woocommerce-notification' ) ?></option>
                                        </select>
                                    </div>
                                    <div class="field">
                                        <select name="<?php echo esc_attr( self::set_field( 'message_display_effect' ) ) ?>"
                                                class="vi-ui fluid dropdown"
                                                id="<?php echo esc_attr( self::set_field( 'message_display_effect' ) ) ?>">
                                            <optgroup label="Bouncing Entrances">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'bounceIn' ) ?>
                                                        value="bounceIn"><?php esc_attr_e( 'bounceIn', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'bounceInDown' ) ?>
                                                        value="bounceInDown"><?php esc_attr_e( 'bounceInDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'bounceInLeft' ) ?>
                                                        value="bounceInLeft"><?php esc_attr_e( 'bounceInLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'bounceInRight' ) ?>
                                                        value="bounceInRight"><?php esc_attr_e( 'bounceInRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'bounceInUp' ) ?>
                                                        value="bounceInUp"><?php esc_attr_e( 'bounceInUp', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Fading Entrances">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fade-in' ) ?>
                                                        value="fade-in"><?php esc_attr_e( 'fadeIn', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInDown' ) ?>
                                                        value="fadeInDown"><?php esc_attr_e( 'fadeInDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInDownBig' ) ?>
                                                        value="fadeInDownBig"><?php esc_attr_e( 'fadeInDownBig', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInLeft' ) ?>
                                                        value="fadeInLeft"><?php esc_attr_e( 'fadeInLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInLeftBig' ) ?>
                                                        value="fadeInLeftBig"><?php esc_attr_e( 'fadeInLeftBig', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInRight' ) ?>
                                                        value="fadeInRight"><?php esc_attr_e( 'fadeInRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInRightBig' ) ?>
                                                        value="fadeInRightBig"><?php esc_attr_e( 'fadeInRightBig', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInUp' ) ?>
                                                        value="fadeInUp"><?php esc_attr_e( 'fadeInUp', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'fadeInUpBig' ) ?>
                                                        value="fadeInUpBig"><?php esc_attr_e( 'fadeInUpBig', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Flippers">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'flipInX' ) ?>
                                                        value="flipInX"><?php esc_attr_e( 'flipInX', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'flipInY' ) ?>
                                                        value="flipInY"><?php esc_attr_e( 'flipInY', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Lightspeed">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'lightSpeedIn' ) ?>
                                                        value="lightSpeedIn"><?php esc_attr_e( 'lightSpeedIn', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Rotating Entrances">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'rotateIn' ) ?>
                                                        value="rotateIn"><?php esc_attr_e( 'rotateIn', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'rotateInDownLeft' ) ?>
                                                        value="rotateInDownLeft"><?php esc_attr_e( 'rotateInDownLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'rotateInDownRight' ) ?>
                                                        value="rotateInDownRight"><?php esc_attr_e( 'rotateInDownRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'rotateInUpLeft' ) ?>
                                                        value="rotateInUpLeft"><?php esc_attr_e( 'rotateInUpLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'rotateInUpRight' ) ?>
                                                        value="rotateInUpRight"><?php esc_attr_e( 'rotateInUpRight', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Sliding Entrances">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'slideInUp' ) ?>
                                                        value="slideInUp"><?php esc_attr_e( 'slideInUp', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'slideInDown' ) ?>
                                                        value="slideInDown"><?php esc_attr_e( 'slideInDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'slideInLeft' ) ?>
                                                        value="slideInLeft"><?php esc_attr_e( 'slideInLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'slideInRight' ) ?>
                                                        value="slideInRight"><?php esc_attr_e( 'slideInRight', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Zoom Entrances">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'zoomIn' ) ?>
                                                        value="zoomIn"><?php esc_attr_e( 'zoomIn', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'zoomInDown' ) ?>
                                                        value="zoomInDown"><?php esc_attr_e( 'zoomInDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'zoomInLeft' ) ?>
                                                        value="zoomInLeft"><?php esc_attr_e( 'zoomInLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'zoomInRight' ) ?>
                                                        value="zoomInRight"><?php esc_attr_e( 'zoomInRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'zoomInUp' ) ?>
                                                        value="zoomInUp"><?php esc_attr_e( 'zoomInUp', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Special">
                                                <option <?php selected( self::get_field( 'message_display_effect' ), 'rollIn' ) ?>
                                                        value="rollIn"><?php esc_attr_e( 'rollIn', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                        </select>
                                        <p class="description"><?php esc_html_e( 'Show notification effect', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field">
                                        <select name="<?php echo esc_attr( self::set_field( 'message_hidden_effect' ) ) ?>"
                                                class="vi-ui fluid dropdown"
                                                id="<?php echo esc_attr( self::set_field( 'message_hidden_effect' ) ) ?>">
                                            <optgroup label="Bouncing Exits">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'bounceOut' ) ?>
                                                        value="bounceOut"><?php esc_attr_e( 'bounceOut', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'bounceOutDown' ) ?>
                                                        value="bounceOutDown"><?php esc_attr_e( 'bounceOutDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'bounceOutLeft' ) ?>
                                                        value="bounceOutLeft"><?php esc_attr_e( 'bounceOutLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'bounceOutRight' ) ?>
                                                        value="bounceOutRight"><?php esc_attr_e( 'bounceOutRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'bounceOutUp' ) ?>
                                                        value="bounceOutUp"><?php esc_attr_e( 'bounceOutUp', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Fading Exits">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fade-out' ) ?>
                                                        value="fade-out"><?php esc_attr_e( 'fadeOut', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutDown' ) ?>
                                                        value="fadeOutDown"><?php esc_attr_e( 'fadeOutDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutDownBig' ) ?>
                                                        value="fadeOutDownBig"><?php esc_attr_e( 'fadeOutDownBig', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutLeft' ) ?>
                                                        value="fadeOutLeft"><?php esc_attr_e( 'fadeOutLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutLeftBig' ) ?>
                                                        value="fadeOutLeftBig"><?php esc_attr_e( 'fadeOutLeftBig', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutRight' ) ?>
                                                        value="fadeOutRight"><?php esc_attr_e( 'fadeOutRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutRightBig' ) ?>
                                                        value="fadeOutRightBig"><?php esc_attr_e( 'fadeOutRightBig', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutUp' ) ?>
                                                        value="fadeOutUp"><?php esc_attr_e( 'fadeOutUp', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'fadeOutUpBig' ) ?>
                                                        value="fadeOutUpBig"><?php esc_attr_e( 'fadeOutUpBig', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Flippers">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'flipOutX' ) ?>
                                                        value="flipOutX"><?php esc_attr_e( 'flipOutX', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'flipOutY' ) ?>
                                                        value="flipOutY"><?php esc_attr_e( 'flipOutY', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Lightspeed">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'lightSpeedOut' ) ?>
                                                        value="lightSpeedOut"><?php esc_attr_e( 'lightSpeedOut', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Rotating Exits">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'rotateOut' ) ?>
                                                        value="rotateOut"><?php esc_attr_e( 'rotateOut', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'rotateOutDownLeft' ) ?>
                                                        value="rotateOutDownLeft"><?php esc_attr_e( 'rotateOutDownLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'rotateOutDownRight' ) ?>
                                                        value="rotateOutDownRight"><?php esc_attr_e( 'rotateOutDownRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'rotateOutUpLeft' ) ?>
                                                        value="rotateOutUpLeft"><?php esc_attr_e( 'rotateOutUpLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'rotateOutUpRight' ) ?>
                                                        value="rotateOutUpRight"><?php esc_attr_e( 'rotateOutUpRight', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Sliding Exits">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'slideOutUp' ) ?>
                                                        value="slideOutUp"><?php esc_attr_e( 'slideOutUp', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'slideOutDown' ) ?>
                                                        value="slideOutDown"><?php esc_attr_e( 'slideOutDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'slideOutLeft' ) ?>
                                                        value="slideOutLeft"><?php esc_attr_e( 'slideOutLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'slideOutRight' ) ?>
                                                        value="slideOutRight"><?php esc_attr_e( 'slideOutRight', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Zoom Exits">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'zoomOut' ) ?>
                                                        value="zoomOut"><?php esc_attr_e( 'zoomOut', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'zoomOutDown' ) ?>
                                                        value="zoomOutDown"><?php esc_attr_e( 'zoomOutDown', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'zoomOutLeft' ) ?>
                                                        value="zoomOutLeft"><?php esc_attr_e( 'zoomOutLeft', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'zoomOutRight' ) ?>
                                                        value="zoomOutRight"><?php esc_attr_e( 'zoomOutRight', 'woocommerce-notification' ) ?></option>
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'zoomOutUp' ) ?>
                                                        value="zoomOutUp"><?php esc_attr_e( 'zoomOutUp', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                            <optgroup label="Special">
                                                <option <?php selected( self::get_field( 'message_hidden_effect' ), 'rollOut' ) ?>
                                                        value="rollOut"><?php esc_attr_e( 'rollOut', 'woocommerce-notification' ) ?></option>
                                            </optgroup>
                                        </select>
                                        <p class="description"><?php esc_html_e( 'Hide notification effect', 'woocommerce-notification' ) ?></p>
                                    </div>
                                </div>

                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label>
                                    <?php esc_html_e( 'Preview widget', 'woocommerce-notification' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="equal width fields">
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'preview_rating' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'preview_rating', 0 ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'preview_rating' ) ) ?>"/>
                                            <label for="<?php echo esc_attr( self::set_field( 'preview_rating' ) ) ?>">
                                                <?php esc_html_e( 'Product rating', 'woocommerce-notification' ) ?></label>
                                        </div>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'preview_atc' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'preview_atc', 0 ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'preview_atc' ) ) ?>"/>
                                            <label for="<?php echo esc_attr( self::set_field( 'preview_atc' ) ) ?>">
                                                <?php esc_html_e( 'Add to cart button', 'woocommerce-notification' ) ?></label>
                                        </div>
                                    </div>
                                </div>
                                <p class="description">
                                    <?php echo wp_kses_post( __( 'This feature enables you to preview the display section when using the shortcodes to show the add-to-cart button and product rating within the message. Please set up the message and shortcode in <a href="#messages"><strong>the \'Message\' tab</strong></a> for display on your website, and enable the corresponding option for preview on this \'Design\' tab.', 'woocommerce-notification' ) ) ?>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'rounded_corner' ) ) ?>">
                                    <?php esc_html_e( 'Style', 'woocommerce-notification' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="equal width fields">
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'rounded_corner' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'rounded_corner' ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'rounded_corner' ) ) ?>"/>
                                            <label></label>
                                        </div>
                                        <p class="description"><?php echo esc_html__( 'Message will be rounded and product image is round instead of square', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field wn-rounded-conner-depending">
                                        <div class="vi-ui fluid right labeled input">
                                            <input type="number"
                                                   name="<?php echo esc_attr( self::set_field( 'border_radius' ) ) ?>" min="0"
                                                   value="<?php echo esc_attr( self::get_field( 'border_radius', '9' ) ) ?>"/>
                                            <label class="vi-ui label"><?php esc_html_e( 'px', 'woocommerce-notification' ) ?></label>
                                        </div>
                                        <p class="description"><?php echo esc_html__( 'Custom rounded corner', 'woocommerce-notification' ) ?></p>
                                    </div>
                                </div>
                                <div class="three fields">
                                    <div class="field">
                                        <div class="vi-ui labeled input">
                                            <div class="vi-ui label">
                                                <?php esc_html_e( 'Background', 'woocommerce-notification' ) ?>
                                            </div>
                                            <input style="background-color: <?php echo esc_attr( self::get_field( 'background_color', '#ffffff' ) ) ?>"
                                                   data-ele="backgroundcolor" type="text" class="color-picker"
                                                   name="<?php echo esc_attr( self::set_field( 'background_color' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'background_color', '#ffffff' ) ) ?>"/>
                                        </div>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui labeled input">
                                            <div class="vi-ui label">
                                                <?php esc_html_e( 'Text message', 'woocommerce-notification' ) ?>
                                            </div>
                                            <input data-ele="textcolor"
                                                   style="background-color: <?php echo esc_attr( self::get_field( 'text_color', '#000000' ) ) ?>"
                                                   type="text" class="color-picker"
                                                   name="<?php echo esc_attr( self::set_field( 'text_color' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'text_color', '#000000' ) ) ?>"/>
                                        </div>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui labeled input">
                                            <div class="vi-ui label">
                                                <?php esc_html_e( 'Product name', 'woocommerce-notification' ) ?>
                                            </div>
                                            <input data-ele="highlight" type="text" class="color-picker"
                                                   name="<?php echo esc_attr( self::set_field( 'highlight_color' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'highlight_color', '#000000' ) ) ?>"
                                                   style="background-color: <?php echo esc_attr( self::get_field( 'highlight_color', '#000000' ) ) ?>"/>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Image', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="three fields">
                                    <div class="field">
                                        <select name="<?php echo esc_attr( self::set_field( 'image_position' ) ) ?>"
                                                class="vi-ui fluid dropdown">
                                            <option <?php selected( self::get_field( 'image_position' ), 0 ) ?>
                                                    value="0"><?php esc_attr_e( 'Left', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'image_position' ), 1 ) ?>
                                                    value="1"><?php esc_attr_e( 'Right', 'woocommerce-notification' ) ?></option>
                                        </select>
                                        <p class="description"><?php esc_html_e( 'Image Position', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field image_border_radius">
                                        <div class="vi-ui fluid right labeled input">
                                            <input type="number"
                                                   name="<?php echo esc_attr( self::set_field( 'image_border_radius' ) ) ?>" min="0"
                                                   value="<?php echo esc_attr( self::get_field( 'image_border_radius', '6' ) ) ?>"/>
                                            <label class="vi-ui label"><?php esc_html_e( 'px', 'woocommerce-notification' ) ?></label>
                                        </div>
                                        <p class="description"><?php echo esc_html__( 'The custom-rounded corner of the image', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui fluid right labeled input">
                                            <input type="number" min="0" max="15"
                                                   name="<?php echo esc_attr( self::set_field( 'image_padding' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'image_padding', '0' ) ) ?>"/>
                                            <label class="vi-ui label"><?php esc_html_e( 'px', 'woocommerce-notification' ) ?></label>
                                        </div>
                                        <p class="description"><?php echo esc_html__( 'Gap between product image and notification\'s border', 'woocommerce-notification' ) ?></p>
                                    </div>
                                </div>
                                <div class="two fields">
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'image_redirect' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'image_redirect' ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'image_redirect' ) ) ?>"/>
                                            <label></label>
                                        </div>
                                        <p class="description"><?php echo esc_html__( 'When click image, you will redirect to product single page.', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="field">
                                        <div class="vi-ui toggle checkbox">
                                            <input id="<?php echo esc_attr( self::set_field( 'image_redirect_target' ) ) ?>"
                                                   type="checkbox" <?php checked( self::get_field( 'image_redirect_target' ), 1 ) ?>
                                                   tabindex="0" class="vi_hidden" value="1"
                                                   name="<?php echo esc_attr( self::set_field( 'image_redirect_target' ) ) ?>"/>
                                            <label></label>
                                        </div>
                                        <p class="description"><?php echo esc_html__( 'When click image, you will be redirected to the product\'s single page on a new tab.', 'woocommerce-notification' ) ?></p>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'show_close_icon' ) ) ?>">
                                    <?php esc_html_e( 'Show Close Icon', 'woocommerce-notification' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="field">
                                    <div class="vi-ui toggle checkbox">
                                        <input id="<?php echo esc_attr( self::set_field( 'show_close_icon' ) ) ?>"
                                               type="checkbox" <?php checked( self::get_field( 'show_close_icon' ), 1 ) ?>
                                               tabindex="0" class="vi_hidden" value="1"
                                               name="<?php echo esc_attr( self::set_field( 'show_close_icon' ) ) ?>"/>
                                        <label><?php esc_html_e( 'Enable', 'woocommerce-notification' ); ?></label>
                                    </div>
                                </div>
                                <div class="field show-close-icon">
                                    <div class="field">
                                        <select name="<?php echo esc_attr( self::set_field( 'close_icon_style' ) ) ?>"
                                                class="vi-ui fluid dropdown">
                                            <option <?php selected( self::get_field( 'close_icon_style', 0 ), 0 ) ?>
                                                    value="0"><?php esc_attr_e( 'Default', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'close_icon_style' ), 1 ) ?>
                                                    value="1"><?php esc_attr_e( 'Classic', 'woocommerce-notification' ) ?></option>
                                        </select>
                                        <p class="description"><?php esc_html_e( 'Close icon style', 'woocommerce-notification' ) ?></p>
                                    </div>
                                    <div class="equal width fields">
                                        <div class="field">
                                            <div class="vi-ui fluid right labeled input">
                                                <input type="number"
                                                       name="<?php echo esc_attr( self::set_field( 'time_close' ) ) ?>" min="0"
                                                       value="<?php echo esc_attr( self::get_field( 'time_close', '24' ) ) ?>"/>
                                                <label class="vi-ui label"><?php esc_html_e( 'hour', 'woocommerce-notification' ) ?></label>
                                            </div>
                                            <p class="description"><?php esc_html_e( 'Time close', 'woocommerce-notification' ) ?></p>
                                        </div>
                                        <div class="field close_icon_color_default">
                                            <input data-ele="close_icon_color_default"
                                                   style="background-color: <?php echo esc_attr( self::get_field( 'close_icon_color_default', '#ffffff' ) ) ?>"
                                                   type="text" class="color-picker"
                                                   name="<?php echo esc_attr( self::set_field( 'close_icon_color_default' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'close_icon_color_default', '#ffffff' ) ) ?>"/>
                                            <p class="description"><?php esc_html_e( 'Close icon color', 'woocommerce-notification' ) ?></p>
                                        </div>
                                        <div class="field close_icon_color_classic">
                                            <input data-ele="close_icon_color_classic"
                                                   style="background-color: <?php echo esc_attr( self::get_field( 'close_icon_color_classic', '#000000' ) ) ?>"
                                                   type="text" class="color-picker"
                                                   name="<?php echo esc_attr( self::set_field( 'close_icon_color_classic' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'close_icon_color_classic', '#000000' ) ) ?>"/>
                                            <p class="description"><?php esc_html_e( 'Close icon color', 'woocommerce-notification' ) ?></p>
                                        </div>
                                        <div class="field close_icon_background">
                                            <input data-ele="close_icon_background"
                                                   style="background-color: <?php echo esc_attr( self::get_field( 'close_icon_background', '#000000' ) ) ?>"
                                                   type="text" class="color-picker"
                                                   name="<?php echo esc_attr( self::set_field( 'close_icon_background' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'close_icon_background', '#000000' ) ) ?>"/>
                                            <p class="description"><?php esc_html_e( 'Close icon background', 'woocommerce-notification' ) ?></p>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'custom_css' ) ) ?>">
                                    <?php esc_html_e( 'Custom CSS', 'woocommerce-notification' ) ?>
                                </label>
                            </th>
                            <td>
                                <textarea class=""
                                          name="<?php echo esc_attr( self::set_field( 'custom_css' ) ) ?>"><?php echo wp_kses_post( self::get_field( 'custom_css' ) ) ?></textarea>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <?php
                    $class = [];
                    switch ( self::get_field( 'position' ) ) {
                        case 1:
                            $class[] = 'bottom_right';
                            break;
                        case 2:
                            $class[] = 'top_left';
                            break;
                        case 3:
                            $class[] = 'top_right';
                            break;
                        default:
                            $class[] = '';
                    }
                    $background_image = self::get_field( 'background_image' );
                    if ( $background_image ) {
                        $class[] = 'wn-extended';
                        $class[] = 'wn-' . $background_image;
                    }
                    $class[] = 'wn-show';

                    if ( self::get_field( 'rounded_corner' ) ) {
                        $class[] = 'wn-rounded-corner';
                    }
                    $class[] = 'wn-product-with-image';
                    $class[] = self::get_field( 'image_position' ) ? 'img-right' : '';
                    ?>
                    <div class="<?php echo esc_attr( implode( ' ', $class ) ) ?>"
                         id="message-purchased"
                         data-effect_display="<?php echo esc_attr( self::get_field( 'message_display_effect' ) ); ?>"
                         data-effect_hidden="<?php echo esc_attr( self::get_field( 'message_hidden_effect' ) ); ?>">
                        <div class="message-purchase-main">
                            <span class="wn-notification-image-wrapper"><img class="wn-notification-image"
                                                                             src="<?php echo esc_url( VI_WNOTIFICATION_IMAGES . 'demo-image.jpg' ) ?>"></span>
                            <div class="wn-notification-message-container">
                                Joe Doe in London, England purchased a
                                <a href="#">Ninja Silhouette</a>
                                <div class="wn-notification-star-rating">★★★★★
                                </div>
                                <div class="wn-notification-atc"><i><img src="<?php echo esc_url( VI_WNOTIFICATION_IMAGES . 'add-cart.png' ) ?>" alt=""></i><a href="#">Add to cart</a></div>
                                <small>About 9 hours ago</small>
                            </div>
                        </div>
                        <div id="notify-close" class="default"></div>
                    </div>
                </div>
                <!-- Time !-->
                <div class="vi-ui bottom attached tab segment" data-tab="time">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Display time', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui fluid right labeled input">
                                    <input type="number"
                                           name="<?php echo esc_attr( self::set_field( 'display_time' ) ) ?>"
                                           value="<?php echo esc_attr( self::get_field( 'display_time', 5 ) ) ?>"/>
                                    <label class="vi-ui label"><?php esc_html_e( 'second', 'woocommerce-notification' ) ?></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Time your notification display.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Initial delay', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui fluid right labeled input">
                                    <input type="number"
                                           name="<?php echo esc_attr( self::set_field( 'initial_delay' ) ) ?>" min="0"
                                           value="<?php echo esc_attr( self::get_field( 'initial_delay', 0 ) ) ?>"/>
                                    <label class="vi-ui label"><?php esc_html_e( 'second', 'woocommerce-notification' ) ?></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'When your site loads, notifications will show after this amount of time', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label
                                        for="<?php echo esc_attr( self::set_field( 'initial_delay_random' ) ) ?>"><?php esc_html_e( 'Initial time random', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="field">
                                    <div class="vi-ui toggle checkbox">
                                        <input id="<?php echo esc_attr( self::set_field( 'initial_delay_random' ) ) ?>"
                                               type="checkbox" <?php checked( self::get_field( 'initial_delay_random' ), 1 ) ?>
                                               tabindex="0" class="vi_hidden" value="1"
                                               name="<?php echo esc_attr( self::set_field( 'initial_delay_random' ) ) ?>"/>
                                        <label></label>
                                    </div>
                                    <p class="description"><?php esc_html_e( 'Make the initial time random.', 'woocommerce-notification' ) ?></p>
                                </div>
                                <div class="field vi_hidden initial_delay_random">
                                    <div class="vi-ui input fluid right labeled">
                                        <input type="number"
                                               name="<?php echo esc_attr( self::set_field( 'initial_delay_min' ) ) ?>"
                                               min="0"
                                               value="<?php echo esc_attr( self::get_field( 'initial_delay_min', 0 ) ) ?>"/>
                                        <label class="vi-ui label"><?php esc_html_e( 'seconds', 'woocommerce-notification' ) ?></label>
                                    </div>
                                    <p class="description"><?php esc_html_e( 'Time will be random from Minimum initial delay time to Initial delay.', 'woocommerce-notification' ) ?></p>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'loop' ) ) ?>"><?php esc_html_e( 'Loop', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'loop' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'loop' ), 1 ) ?> tabindex="0"
                                           class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'loop' ) ) ?>"/>
                                    <label></label>
                                </div>
                            </td>
                        </tr>
                        <tr class="vi_hidden time_loop">
                            <th scope="row">
                                <label><?php esc_html_e( 'Next time display', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui input fluid right labeled">
                                    <input type="number"
                                           name="<?php echo esc_attr( self::set_field( 'next_time' ) ) ?>" min="0"
                                           value="<?php echo esc_attr( self::get_field( 'next_time', 60 ) ) ?>"/>
                                    <label class="vi-ui label"><?php esc_html_e( 'seconds', 'woocommerce-notification' ) ?></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Time to show next notification ', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="vi_hidden time_loop">
                            <th scope="row">
                                <label><?php esc_html_e( 'Notifications per page', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <input type="number"
                                       name="<?php echo esc_attr( self::set_field( 'notification_per_page' ) ) ?>"
                                       min="0"
                                       value="<?php echo esc_attr( self::get_field( 'notification_per_page', 30 ) ) ?>"/>

                                <p class="description"><?php esc_html_e( 'Number of notifications on a page.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="vi_hidden time_loop">
                            <th scope="row">
                                <label
                                        for="<?php echo esc_attr( self::set_field( 'loop_session' ) ) ?>"><?php esc_html_e( 'Loop by session', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'loop_session' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'loop_session' ), 1 ) ?>
                                           tabindex="0"
                                           class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'loop_session' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description"><?php esc_html_e( '"Next time display" applies for notifications of the whole site instead of each page', 'woocommerce-notification' ) ?></p>
                                <p class="description"><?php esc_html_e( '"Initial time" is applied only for the first notification of a session', 'woocommerce-notification' ) ?></p>
                                <p class="description"><?php esc_html_e( 'Number of notifications on a page is reset after a session expires', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="vi_hidden session_time_loop">
                            <th scope="row">
                                <label><?php esc_html_e( 'Notifications per session', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <input type="number"
                                       name="<?php echo esc_attr( self::set_field( 'loop_session_total' ) ) ?>"
                                       min="0"
                                       value="<?php echo esc_attr( self::get_field( 'loop_session_total', 60 ) ) ?>"/>
                                <p class="description"><?php esc_html_e( 'Number of notifications in a session.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr class="vi_hidden session_time_loop">
                            <th scope="row">
                                <label><?php esc_html_e( 'Session duration', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui action input fluid">
                                    <input type="number" min="0"
                                           name="<?php echo esc_attr( self::set_field( 'loop_session_duration' ) ) ?>"
                                           value="<?php echo esc_attr( self::get_field( 'loop_session_duration', 1 ) ) ?>"
                                           class="eleven wide"
                                    />
                                    <select class="vi-ui dropdown five wide"
                                            name="<?php echo esc_attr( self::set_field( 'loop_session_duration_unit' ) ) ?>">
                                        <option
                                                value="h" <?php selected( self::get_field( 'loop_session_duration_unit', 'h' ), 'h' ) ?>><?php esc_html_e( 'Hour', 'woocommerce-notification' ) ?></option>
                                        <option
                                                value="m" <?php selected( self::get_field( 'loop_session_duration_unit', 'h' ), 'm' ) ?>><?php esc_html_e( 'Minute', 'woocommerce-notification' ) ?></option>
                                        <option
                                                value="s" <?php selected( self::get_field( 'loop_session_duration_unit', 'h' ), 's' ) ?>><?php esc_html_e( 'Second', 'woocommerce-notification' ) ?></option>
                                    </select>
                                </div>
                                <p class="description"><?php esc_html_e( 'How long should a session last?', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!-- Sound !-->
                <div class="vi-ui bottom attached tab segment" data-tab="sound">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'sound_enable' ) ) ?>"><?php esc_html_e( 'Enable', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'sound_enable' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'sound_enable' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'sound_enable' ) ) ?>"/>
                                    <label></label>
                                </div>

                                <p class="description">
                                    <?php
                                    /* translators: %1$s: Google policy link, %2$s: Google policy link */
                                    echo wp_kses_post( sprintf( __( 'Enable to play a sound when notification appears. More details at: <a href="%1$s" target="_blank">%2$s</a>', 'woocommerce-notification' ), 'https://developers.google.com/web/updates/2017/09/autoplay-policy-changes', 'https://developers.google.com/web/updates/2017/09/autoplay-policy-changes' ) )
                                    ?>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Sound', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td class="wn-table-td-sound-list">
                                <?php
                                $sounds = self::scan_dir( VI_WNOTIFICATION_SOUNDS );
                                ?>
                                <select name="<?php echo esc_attr( self::set_field( 'sound' ) ) ?>" class="vi-ui fluid dropdown viwn-list-sound" data-sound_url="<?php echo esc_attr( VI_WNOTIFICATION_SOUNDS_URL ); ?>">
                                    <?php foreach ( $sounds as $sound ) { ?>
                                        <option <?php selected( self::get_field( 'sound', 'cool' ), $sound ) ?>
                                                value="<?php echo esc_attr( $sound ) ?>"><?php echo esc_html( $sound ) ?></option>
                                    <?php } ?>
                                </select>
                                <a href="#" class="vi-ui button green tiny viwn-play-preview-sound"><?php echo esc_html__( 'Play Review', 'woocommerce-notification' ) ?></a>
                                <?php foreach ( $sounds as $sound ) { ?>
                                    <audio id="viwn-preview-sound-<?php echo esc_attr( $sound ); ?>">
                                        <source src="<?php echo esc_url( VI_WNOTIFICATION_SOUNDS_URL . $sound ); ?>" type="audio/mpeg"/>
                                    </audio>
                                <?php } ?>

                                <p class="description"><?php echo esc_html__( 'Select a sound, notification will ring when it appears.', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!-- Messages !-->
                <div class="vi-ui bottom attached tab segment" data-tab="messages">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Message purchased', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <table class="vi-ui message-purchased optiontable form-table" data-type="mess_purchase">
                                    <?php $messages = self::get_field( 'message_purchased' );
                                    if ( ! $messages ) {
                                        $messages = [ 'Someone in {city}, {country} purchased a {product_with_link} {time_ago}' ];
                                    } elseif ( ! is_array( $messages ) && $messages ) {
                                        $messages = [ $messages ];
                                    }

                                    if ( count( $messages ) ) {
                                        foreach ( $messages as $k => $message ) {
                                            ?>
                                            <tr>
                                                <td width="80%">
                                                    <textarea name="<?php echo esc_attr( self::set_field( 'message_purchased', 1 ) ) ?>"><?php echo wp_kses_post( wp_strip_all_tags( $message ) ) ?></textarea>
                                                    <div class="container_gen_text">
                                                        <?php
                                                        foreach ( $get_ai_type as $ai_type ) {
                                                            if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                                                ?>
                                                                <div class="wrap_gen_text">
                                                                    <ul></ul>
                                                                    <span class="vi-ui button generate-message blue" data-type="mess_purchase" data-language="" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                                                </div>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </div>
                                                    <?php
                                                    /*WPML.org*/
                                                    if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                                        $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                                        if ( count( $languages ) ) {
                                                            foreach ( $languages as $key => $language ) {
                                                                if ( $language['active'] ) {
                                                                    continue;
                                                                }
                                                                $wpml_messages = self::get_field( 'message_purchased_' . $key );
                                                                if ( ! $wpml_messages ) {
                                                                    $wpml_messages = [ 'Someone in {city}, {country} purchased a {product_with_link} {time_ago}' ];
                                                                } elseif ( ! is_array( $wpml_messages ) && $wpml_messages ) {
                                                                    $wpml_messages = [ $wpml_messages ];
                                                                }
                                                                ?>
                                                                <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                                                <textarea name="<?php echo esc_attr( self::set_field( 'message_purchased_' . $key, 1 ) ) ?>"><?php echo esc_html( isset( $wpml_messages[ $k ] ) ? wp_strip_all_tags( $wpml_messages[ $k ] ) : $message ) ?></textarea>
                                                                <div class="container_gen_text">
                                                                    <?php
                                                                    foreach ( $get_ai_type as $ai_type ) {
                                                                        if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                                                            ?>
                                                                            <div class="wrap_gen_text">
                                                                                <ul></ul>
                                                                                <span class="vi-ui button generate-message blue" data-type="mess_purchase" data-language="<?php echo esc_attr( $key ) ?>" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                                                            </div>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </div>
                                                                <?php
                                                            }
                                                        }
                                                    } /*Polylang*/ elseif ( class_exists( 'Polylang' ) ) {
                                                        $languages = pll_languages_list();

                                                        foreach ( $languages as $language ) {
                                                            $default_lang = pll_default_language( 'slug' );

                                                            if ( $language == $default_lang ) {
                                                                continue;
                                                            }
                                                            $wpml_messages = self::get_field( 'message_purchased_' . $language );
                                                            if ( ! $wpml_messages ) {
                                                                $wpml_messages = [ 'Someone in {city}, {country} purchased a {product_with_link} {time_ago}' ];
                                                            } elseif ( ! is_array( $wpml_messages ) && $wpml_messages ) {
                                                                $wpml_messages = [ $wpml_messages ];
                                                            }
                                                            ?>
                                                            <h4><?php echo esc_html( $language ) ?></h4>
                                                            <textarea name="<?php echo esc_attr( self::set_field( 'message_purchased_' . $language, 1 ) ) ?>"><?php echo esc_html( isset( $wpml_messages[ $k ] ) ? wp_strip_all_tags( $wpml_messages[ $k ] ) : $message ) ?></textarea>
                                                            <div class="container_gen_text">
                                                                <?php
                                                                foreach ( $get_ai_type as $ai_type ) {
                                                                    if ( self::get_field( 'ai_' . $ai_type . '_api_key' ) ) {
                                                                        ?>
                                                                        <div class="wrap_gen_text">
                                                                            <ul></ul>
                                                                            <span class="vi-ui button generate-message blue" data-type="mess_purchase" data-language="<?php echo esc_attr( $language ) ?>" data-ai="<?php echo esc_attr( $ai_type ) ?>"><?php echo esc_html( $ai_type . ' generator' ) ?></span>
                                                                        </div>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </div>
                                                            <?php
                                                        }
                                                    }
                                                    ?>

                                                </td>
                                                <td>
                                                    <span class="vi-ui button remove-message red"><?php esc_html_e( 'Remove', 'woocommerce-notification' ) ?></span>
                                                </td>
                                            </tr>
                                        <?php }
                                    } ?>
                                </table>
                                <p>
                                    <span class="vi-ui button add-message green"><?php esc_html_e( 'Add New', 'woocommerce-notification' ) ?></span>

                                </p>
                                <ul class="description" style="list-style: none">
                                    <li>
                                        <span>{first_name}</span>
                                        - <?php esc_html_e( 'Customer\'s first name', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{short_name}</span>
                                        - <?php esc_html_e( 'Customer\'s first name', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{city}</span>
                                        - <?php esc_html_e( 'Customer\'s city', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{state}</span>
                                        - <?php esc_html_e( 'Customer\'s state', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{country}</span>
                                        - <?php esc_html_e( 'Customer\'s country', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product}</span>
                                        - <?php esc_html_e( 'Product title', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product_with_rating}</span>
                                        - <?php esc_html_e( 'Product with star rating', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product_with_atc}</span>
                                        - <?php esc_html_e( 'Product with add to cart button', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product_with_rating_atc}</span>
                                        - <?php esc_html_e( 'Product with rating and add to cart button', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product_with_link}</span>
                                        - <?php esc_html_e( 'Product title with link', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product_with_link_rating}</span>
                                        - <?php esc_html_e( 'Product with link and star rating', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product_with_link_atc}</span>
                                        - <?php esc_html_e( 'Product with link and add to cart button', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{product_with_link_rating_atc}</span>
                                        - <?php esc_html_e( 'Product with link, star rating and add to cart button', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{time_ago}</span>
                                        - <?php esc_html_e( 'Time after purchase', 'woocommerce-notification' ) ?>
                                    </li>
                                    <li>
                                        <span>{custom}</span>
                                        - <?php esc_html_e( 'Use custom shortcode', 'woocommerce-notification' ) ?>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'custom_shortcode' ) ) ?>"><?php esc_html_e( 'Custom', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <?php $custom_shortcode = self::get_field( 'custom_shortcode', esc_attr( '{number} people seeing this product right now' ) ); ?>
                                <input id="<?php echo esc_attr( self::set_field( 'custom_shortcode' ) ) ?>" type="text"
                                       tabindex="0"
                                       value="<?php echo esc_attr( $custom_shortcode ) ?>"
                                       name="<?php echo esc_attr( self::set_field( 'custom_shortcode' ) ) ?>"/>

                                <p class="description"><?php esc_html_e( 'This is {custom} shortcode content.', 'woocommerce-notification' ) ?></p>
                                <?php
                                /*WPML.org*/
                                if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                    $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                    if ( count( $languages ) ) {
                                        foreach ( $languages as $key => $language ) {
                                            if ( $language['active'] ) {
                                                continue;
                                            }
                                            $wpml_custom_shortcode = self::get_field( 'custom_shortcode_' . $key );
                                            if ( ! $wpml_custom_shortcode ) {
                                                $wpml_custom_shortcode = $custom_shortcode;
                                            }
                                            ?>
                                            <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                            <input id="<?php echo esc_attr( self::set_field( 'custom_shortcode_' . $key ) ) ?>"
                                                   type="text"
                                                   tabindex="0"
                                                   value="<?php echo esc_attr( $wpml_custom_shortcode ) ?>"
                                                   name="<?php echo esc_attr( self::set_field( 'custom_shortcode_' . $key ) ) ?>"/>
                                        <?php }
                                    }
                                } /*Polylang*/ elseif ( class_exists( 'Polylang' ) ) {
                                    $languages = pll_languages_list();

                                    foreach ( $languages as $language ) {
                                        $default_lang = pll_default_language( 'slug' );

                                        if ( $language == $default_lang ) {
                                            continue;
                                        }
                                        $wpml_custom_shortcode = self::get_field( 'custom_shortcode_' . $language );
                                        if ( ! $wpml_custom_shortcode ) {
                                            $wpml_custom_shortcode = $custom_shortcode;
                                        }
                                        ?>
                                        <h4><?php echo esc_html( $language ) ?></h4>
                                        <input id="<?php echo esc_attr( self::set_field( 'custom_shortcode_' . $language ) ) ?>"
                                               type="text"
                                               tabindex="0"
                                               value="<?php echo esc_attr( $wpml_custom_shortcode ) ?>"
                                               name="<?php echo esc_attr( self::set_field( 'custom_shortcode_' . $language ) ) ?>"/>
                                        <?php
                                    }
                                }
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'min_number' ) ) ?>"><?php esc_html_e( 'Min Number', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <input id="<?php echo esc_attr( self::set_field( 'min_number' ) ) ?>" type="number"
                                       tabindex="0"
                                       min="0"
                                       value="<?php echo esc_attr( self::get_field( 'min_number', 100 ) ) ?>"
                                       name="<?php echo esc_attr( self::set_field( 'min_number' ) ) ?>"/>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'max_number' ) ) ?>"><?php esc_html_e( 'Max number', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <input id="<?php echo esc_attr( self::set_field( 'max_number' ) ) ?>" type="number"
                                       tabindex="0"
                                       min="0"
                                       value="<?php echo esc_attr( self::get_field( 'max_number', 200 ) ) ?>"
                                       name="<?php echo esc_attr( self::set_field( 'max_number' ) ) ?>"/>

                                <p class="description"><?php esc_html_e( 'Number will random from Min number to Max number', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'change_message_number_enable' ) ) ?>">
                                    <?php esc_html_e( 'Flexible number', 'woocommerce-notification' ) ?>
                                </label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'change_message_number_enable' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'change_message_number_enable' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'change_message_number_enable' ) ) ?>"/>
                                    <label></label>
                                </div>

                                <p class="description">
                                    <?php esc_html_e( 'The number changes reasonably on the time in a day when there is supposedly more or less traffic', 'woocommerce-notification' ) ?>
                                </p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!-- Assign !-->
                <div class="vi-ui bottom attached tab segment" data-tab="assign">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'is_home' ) ) ?>"><?php esc_html_e( 'Home page', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'is_home' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'is_home' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'is_home' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Turn on to hide notification on Home page', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'is_checkout' ) ) ?>"><?php esc_html_e( 'Checkout page', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'is_checkout' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'is_checkout' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'is_checkout' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Turn on to hide notification on Checkout page', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'is_cart' ) ) ?>"><?php esc_html_e( 'Cart page', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'is_cart' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'is_cart' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'is_cart' ) ) ?>"/>
                                    <label></label>
                                </div>
                                <p class="description"><?php esc_html_e( 'Turn on to hide notification on Cart page', 'woocommerce-notification' ) ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <?php esc_html_e( 'Conditional Tags', 'woocommerce-notification' ) ?>
                            </th>
                            <td>
                                <input placeholder="<?php esc_html_e( 'eg: !is_page(array(34,98,73))', 'woocommerce-notification' ) ?>"
                                       type="text"
                                       value="<?php echo esc_attr( htmlentities( self::get_field( 'conditional_tags' ) ) ) ?>"
                                       name="<?php echo esc_attr( self::set_field( 'conditional_tags' ) ) ?>"/>
                                <p class="description"><?php esc_html_e( 'Let you control on which pages Notification will appear using ', 'woocommerce-notification' ) ?>
                                    <a class="wn-notification-link" href="http://codex.wordpress.org/Conditional_Tags" target="_blank"><?php esc_html_e( 'WP\'s conditional tags,', 'woocommerce-notification' ) ?></a>
                                    <a class="wn-notification-link" href="http://developer.woocommerce.com/docs/conditional-tags-in-woocommerce/" target="_blank"><?php esc_html_e( 'Woo\'s conditional tags', 'woocommerce-notification' ) ?></a>
                                </p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!-- Logs !-->
                <div class="vi-ui bottom attached tab segment" data-tab="logs">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'save_logs' ) ) ?>"><?php esc_html_e( 'Save Logs', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui toggle checkbox">
                                    <input id="<?php echo esc_attr( self::set_field( 'save_logs' ) ) ?>"
                                           type="checkbox" <?php checked( self::get_field( 'save_logs' ), 1 ) ?>
                                           tabindex="0" class="vi_hidden" value="1"
                                           name="<?php echo esc_attr( self::set_field( 'save_logs' ) ) ?>"/>
                                    <label></label>
                                </div>
                            </td>
                        </tr>
                        <tr class="vi_hidden save_logs">
                            <th scope="row">
                                <label><?php esc_html_e( 'History time', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui fluid right labeled input">
                                    <input type="text"
                                           name="<?php echo esc_attr( self::set_field( 'history_time' ) ) ?>"
                                           value="<?php echo esc_attr( self::get_field( 'history_time', 30 ) ) ?>"/>
                                    <label class="vi-ui label"><?php esc_html_e( 'days', 'woocommerce-notification' ) ?></label>
                                </div>
                                <p class="description">
                                    <?php
                                    echo wp_kses_post( sprintf( __( 'Logs will be saved at %s during this time', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                    ?>
                                </p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <!-- AI Engine !-->
                <div class="vi-ui bottom attached tab segment" data-tab="ai-engine">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'ai_type' ) ) ?>"><?php esc_html_e( 'AI Type', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <select name="<?php echo esc_attr( self::set_field( 'ai_type', true ) ) ?>"
                                        class="vi-ui fluid dropdown"
                                        id="wn_ai_type" multiple>
                                    <option selected value=""><?php esc_attr_e( '---Choose AI technology---', 'woocommerce-notification' ) ?></option>
                                    <option <?php echo in_array( 'gemini', $get_ai_type ) ? 'selected' : ''; ?>
                                            value="gemini"><?php esc_attr_e( 'Gemini', 'woocommerce-notification' ) ?></option>
                                    <option <?php echo in_array( 'openai', $get_ai_type ) ? 'selected' : ''; ?>
                                            value="openai"><?php esc_attr_e( 'OpenAi', 'woocommerce-notification' ) ?></option>
                                </select>

                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'ai_command_min_characters' ) ) ?>"><?php esc_html_e( 'Min characters', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui fluid input">
                                    <input type="number"
                                           name="<?php echo esc_attr( self::set_field( 'ai_command_min_characters' ) ) ?>"
                                           value="<?php echo esc_attr( self::get_field( 'ai_command_min_characters' ) ) ?>"/>
                                    <label class=""></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'ai_command_max_characters' ) ) ?>"><?php esc_html_e( 'Max characters', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui fluid input">
                                    <input type="number"
                                           name="<?php echo esc_attr( self::set_field( 'ai_command_max_characters' ) ) ?>"
                                           value="<?php echo esc_attr( self::get_field( 'ai_command_max_characters' ) ) ?>"/>
                                    <label class=""></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'ai_command_writing_style' ) ) ?>"><?php esc_html_e( 'Writing style', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui fluid input">
                                    <input type="text"
                                           name="<?php echo esc_attr( self::set_field( 'ai_command_writing_style' ) ) ?>"
                                           value="<?php echo esc_attr( self::get_field( 'ai_command_writing_style' ) ) ?>"/>
                                    <label class=""></label>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( self::set_field( 'ai_command_writing_tone' ) ) ?>"><?php esc_html_e( 'Writing tone', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="vi-ui fluid input">
                                    <input type="text"
                                           name="<?php echo esc_attr( self::set_field( 'ai_command_writing_tone' ) ) ?>"
                                           value="<?php echo esc_attr( self::get_field( 'ai_command_writing_tone' ) ) ?>"/>
                                    <label class=""></label>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <div class="vi-ui styled fluid accordion woonotification-accordion-setting-ai">
                        <div class="title active <?php echo esc_attr( 'ai_type_gemini' ); ?>">
                            <i class="dropdown icon"></i><?php esc_html_e( 'Gemini', 'woocommerce-notification' ); ?>
                        </div>
                        <div class="content active <?php echo esc_attr( 'ai_type_gemini' ); ?>">
                            <table class="form-table vi-ui form">
                                <tbody>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( 'API key', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid input">
                                            <input type="text"
                                                   name="<?php echo esc_attr( self::set_field( 'ai_gemini_api_key' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'ai_gemini_api_key' ) ) ?>"/>
                                            <label class=""></label>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( '<strong>Follow these steps to get API:</strong>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li>
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Go to <a href="https://ai.google.dev/gemini-api">https://ai.google.dev/gemini-api</a>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </li>
                                            <li>
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Select "Get an API key from Google AI Studio"', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </li>
                                            <li>
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Click "Create API key"', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </li>
                                            <li>
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Then, configure your key. And copy the key and paste it to this field', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </li>
                                        </ol>
                                    </td>
                                </tr>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( 'API version', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <select name="<?php echo esc_attr( self::set_field( 'ai_gemini_version' ) ) ?>"
                                                class="vi-ui fluid dropdown">
                                            <option <?php selected( self::get_field( 'ai_gemini_version' ), 'v1' ) ?>
                                                    value="v1"><?php esc_attr_e( 'V1', 'woocommerce-notification' ) ?></option>
                                            <option <?php selected( self::get_field( 'ai_gemini_version' ), 'v1beta' ) ?>
                                                    value="v1beta"><?php esc_attr_e( 'V1 Beta', 'woocommerce-notification' ) ?></option>
                                        </select>

                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( 'API version supported by Gemini. Read more details of each version in <a href="https://ai.google.dev/gemini-api/docs/api-versions">this article</a>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                    </td>
                                </tr>
                                <?php
                                if ( ! empty( self::$setting->get_params( 'ai_gemini_api_key' ) ) ) {
                                    ?>
                                    <tr class="">
                                        <th scope="row">
                                            <label><?php esc_html_e( 'API model list', 'woocommerce-notification' ) ?></label>
                                        </th>
                                        <td>
                                            <div class="wn-notification-wrap_select">
                                                <?php
                                                $gemini_list = self::$VI_WNOTIFICATION_Admin_Gemini->get_model_list();

                                                ?>
                                                <select name="<?php echo esc_attr( self::set_field( 'ai_gemini_model' ) ) ?>" class="vi-ui fluid dropdown">
                                                    <?php
                                                    if ( ! empty( $gemini_list ) ) {
                                                        foreach ( $gemini_list as $model_item ) {
                                                            ?>
                                                            <option value="<?php echo esc_attr( $model_item['name'] ) ?>" <?php selected( self::get_field( 'ai_gemini_model' ), $model_item['name'] ) ?>><?php echo esc_html( $model_item['displayName'] ); ?></option>
                                                            <?php
                                                        }
                                                    } else {
                                                        ?>
                                                        <option value="gemini-pro" <?php selected( self::get_field( 'ai_gemini_model' ), 'models/gemini-pro' ) ?>>Gemini 1.0 Pro</option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                                <!--button id="syncGoogleButton" class="button button-primary wn-notification-sync_google_models">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-refresh-cw">
                                                        <polyline points="23 4 23 10 17 10"></polyline>
                                                        <polyline points="1 20 1 14 7 14"></polyline>
                                                        <path d="M3.51 9a9 9 0 0 1 14.85-3.36L23 10M1 14l4.64 4.36A9 9 0 0 0 20.49 15"></path>
                                                    </svg>
                                                </button-->
                                            </div>
                                            <p class="description">
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Choose a model. Gemini models are designed for multimodal applications, processing prompts with both text and images to generate text responses. Read more details in <a href="https://ai.google.dev/gemini-api/docs/models/gemini">this article.</a>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </p>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( '"Message purchased" prompt', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid ">
                                            <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_purchase_mess' ) ) ?>"><?php echo esc_html( self::get_field( 'ai_gemini_key_purchase_mess' ) ) ?></textarea>

                                            <?php
                                            /*WPML.org*/
                                            if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                                $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                                if ( count( $languages ) ) {
                                                    foreach ( $languages as $key => $language ) {
                                                        if ( $language['active'] ) {
                                                            continue;
                                                        }
                                                        $wpml_ai_gemini_key_purchase_mess = self::get_field( 'ai_gemini_key_purchase_mess_' . $key );
                                                        if ( ! $wpml_ai_gemini_key_purchase_mess ) {
                                                            $wpml_ai_gemini_key_purchase_mess = self::get_field( 'ai_gemini_key_purchase_mess' );
                                                        }
                                                        ?>
                                                        <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                                        <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_purchase_mess_' . $key ) ) ?>"><?php echo esc_html( $wpml_ai_gemini_key_purchase_mess ) ?></textarea>
                                                    <?php }
                                                }
                                            } /*Polylang*/ elseif ( class_exists( 'Polylang' ) ) {
                                                $languages = pll_languages_list();

                                                foreach ( $languages as $language ) {
                                                    $default_lang = pll_default_language( 'slug' );

                                                    if ( $language == $default_lang ) {
                                                        continue;
                                                    }

                                                    $wpml_ai_gemini_key_purchase_mess = self::get_field( 'ai_gemini_key_purchase_mess_' . $language );
                                                    if ( ! $wpml_ai_gemini_key_purchase_mess ) {
                                                        $wpml_ai_gemini_key_purchase_mess = self::get_field( 'ai_gemini_key_purchase_mess' );
                                                    }
                                                    ?>
                                                    <h4><?php echo esc_html( $language ) ?></h4>
                                                    <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_purchase_mess_' . $language ) ) ?>"><?php echo esc_html( $wpml_ai_gemini_key_purchase_mess ) ?></textarea>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( 'Provide your prompt or specific instructions for the AI to generate messages in the \'Message Purchased\' input field under Messages. Ex:', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li><?php echo esc_html__( 'Generate notification sentences that simulate recent purchases, product views, or inquiries, using numbers and locations, without urgency or exclamation marks', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Generate urgency-driven notification sentences, mentioning recent purchases, product views, inquiries, or popular demand, using numbers, locations, and a sense of immediacy', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MIN_CHARACTERS} : is min characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MAX_CHARACTERS} : is max characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_STYLE} : is writing style', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_TONE} : is writing tone', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                        </ol>
                                    </td>
                                </tr>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( '"Virtual First Name" prompt', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid ">
                                            <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_virtual_first_name' ) ) ?>"><?php echo esc_html( self::get_field( 'ai_gemini_key_virtual_first_name' ) ) ?></textarea
                                            <?php
                                            /*WPML.org*/
                                            if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                                $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                                if ( count( $languages ) ) {
                                                    foreach ( $languages as $key => $language ) {
                                                        if ( $language['active'] ) {
                                                            continue;
                                                        }
                                                        $wpml_ai_gemini_key_virtual_first_name = self::get_field( 'ai_gemini_key_virtual_first_name_' . $key );
                                                        if ( ! $wpml_ai_gemini_key_virtual_first_name ) {
                                                            $wpml_ai_gemini_key_virtual_first_name = self::get_field( 'ai_gemini_key_virtual_first_name' );
                                                        }
                                                        ?>
                                                        <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                                        <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_virtual_first_name_' . $key ) ) ?>"><?php echo esc_html( $wpml_ai_gemini_key_virtual_first_name ) ?></textarea>
                                                    <?php }
                                                }
                                            } elseif ( class_exists( 'Polylang' ) ) {
                                                /*Polylang*/
                                                $languages = pll_languages_list();

                                                foreach ( $languages as $language ) {
                                                    $default_lang = pll_default_language( 'slug' );

                                                    if ( $language == $default_lang ) {
                                                        continue;
                                                    }

                                                    $wpml_ai_gemini_key_virtual_first_name = self::get_field( 'ai_gemini_key_virtual_first_name_' . $language );
                                                    if ( ! $wpml_ai_gemini_key_virtual_first_name ) {
                                                        $wpml_ai_gemini_key_virtual_first_name = self::get_field( 'ai_gemini_key_virtual_first_name' );
                                                    }
                                                    ?>
                                                    <h4><?php echo esc_html( $language ) ?></h4>
                                                    <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_virtual_first_name_' . $language ) ) ?>"><?php echo esc_html( $wpml_ai_gemini_key_virtual_first_name ) ?></textarea>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( 'Provide your prompt or specific instructions for the AI to generate customers\' names in the \'Virtual First Name\' input field under Products', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li><?php echo esc_html__( 'Shortcode {MIN_CHARACTERS} : is min characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MAX_CHARACTERS} : is max characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_STYLE} : is writing style', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_TONE} : is writing tone', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                        </ol>
                                    </td>
                                </tr>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( '"Virtual City" prompt', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid ">
                                            <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_virtual_city' ) ) ?>"><?php echo esc_html( self::get_field( 'ai_gemini_key_virtual_city' ) ) ?></textarea>
                                            <?php
                                            /*WPML.org*/
                                            if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                                $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                                if ( count( $languages ) ) {
                                                    foreach ( $languages as $key => $language ) {
                                                        if ( $language['active'] ) {
                                                            continue;
                                                        }
                                                        $wpml_ai_gemini_key_virtual_city = self::get_field( 'ai_gemini_key_virtual_city_' . $key );
                                                        if ( ! $wpml_ai_gemini_key_virtual_city ) {
                                                            $wpml_ai_gemini_key_virtual_city = self::get_field( 'ai_gemini_key_virtual_city' );
                                                        }
                                                        ?>
                                                        <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                                        <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_virtual_city_' . $key ) ) ?>"><?php echo esc_html( $wpml_ai_gemini_key_virtual_city ) ?></textarea>
                                                    <?php }
                                                }
                                            } /*Polylang*/ elseif ( class_exists( 'Polylang' ) ) {
                                                $languages = pll_languages_list();

                                                foreach ( $languages as $language ) {
                                                    $default_lang = pll_default_language( 'slug' );

                                                    if ( $language == $default_lang ) {
                                                        continue;
                                                    }

                                                    $wpml_ai_gemini_key_virtual_city = self::get_field( 'ai_gemini_key_virtual_city_' . $language );
                                                    if ( ! $wpml_ai_gemini_key_virtual_city ) {
                                                        $wpml_ai_gemini_key_virtual_city = self::get_field( 'ai_gemini_key_virtual_city' );
                                                    }
                                                    ?>
                                                    <h4><?php echo esc_html( $language ) ?></h4>
                                                    <textarea name="<?php echo esc_attr( self::set_field( 'ai_gemini_key_virtual_city_' . $language ) ) ?>"><?php echo esc_html( $wpml_ai_gemini_key_virtual_city ) ?></textarea>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( 'Provide your prompt or specific instructions for the AI to generate cities in the \'Virtual City\' input field under Products', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li><?php echo esc_html__( 'Shortcode {MIN_CHARACTERS} : is min characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MAX_CHARACTERS} : is max characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_STYLE} : is writing style', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_TONE} : is writing tone', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                        </ol>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="title active <?php echo esc_attr( 'ai_type_openai' ); ?>">
                            <i class="dropdown icon"></i><?php esc_html_e( 'OpenAI', 'woocommerce-notification' ); ?>
                        </div>
                        <div class="content active <?php echo esc_attr( 'ai_type_openai' ); ?>">
                            <table class="form-table vi-ui form">
                                <tbody>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( 'API key', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid input">
                                            <input type="text"
                                                   name="<?php echo esc_attr( self::set_field( 'ai_openai_api_key' ) ) ?>"
                                                   value="<?php echo esc_attr( self::get_field( 'ai_openai_api_key' ) ) ?>"/>
                                            <label class=""></label>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( '<strong>Follow these steps to get API:</strong>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li>
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Sign up/Login at <a href="https://platform.openai.com/">OpenAI</a>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </li>
                                            <li>
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Get an API Key from the <a href="https://platform.openai.com/account/api-keys">API Keys page.</a>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </li>
                                            <li>
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Then, configure your key. And copy the key and paste it to this field', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </li>
                                        </ol>
                                    </td>
                                </tr>
                                <?php
                                if ( ! empty( self::$setting->get_params( 'ai_openai_api_key' ) ) ) {
                                    ?>
                                    <tr class="">
                                        <th scope="row">
                                            <label><?php esc_html_e( 'API model list', 'woocommerce-notification' ) ?></label>
                                        </th>
                                        <td>
                                            <div class="wn-notification-wrap_select">
                                                <?php
                                                $openai_list = self::$VI_WNOTIFICATION_Admin_OpenAI->get_model_list();
                                                ?>
                                                <select name="<?php echo esc_attr( self::set_field( 'ai_openai_model' ) ) ?>" class="vi-ui fluid dropdown">
                                                    <option value=""><?php esc_html_e( '---Choose model---', 'woocommerce-notification' ) ?></option>
                                                    <?php
                                                    if ( ! empty( $openai_list ) ) {
                                                        foreach ( $openai_list as $model_item ) {
                                                            ?>
                                                            <option value="<?php echo esc_attr( $model_item['id'] ) ?>" <?php selected( self::get_field( 'ai_openai_model' ), $model_item['id'] ) ?>><?php echo esc_html( str_replace( '-', ' ', $model_item['id'] ) ); ?></option>
                                                            <?php
                                                        }
                                                    } else {
                                                        ?>
                                                        <option value="gpt-4o-mini" <?php selected( self::get_field( 'ai_openai_model' ), 'gpt-4o-mini' ) ?>>gpt 4o mini</option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                                <!--button id="syncGoogleButton" class="button button-primary wn-notification-sync_google_models">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-refresh-cw">
                                                        <polyline points="23 4 23 10 17 10"></polyline>
                                                        <polyline points="1 20 1 14 7 14"></polyline>
                                                        <path d="M3.51 9a9 9 0 0 1 14.85-3.36L23 10M1 14l4.64 4.36A9 9 0 0 0 20.49 15"></path>
                                                    </svg>
                                                </button-->
                                            </div>
                                            <p class="description">
                                                <?php
                                                echo wp_kses_post( sprintf( __( 'Choose a model. OpenAI models are designed for multimodal applications, processing prompts with both text and images to generate text responses. Read more details in <a href="https://platform.openai.com/docs/models#models-overview">this article.</a>', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                                ?>
                                            </p>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( '"Message purchased" prompt', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid ">
                                            <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_purchase_mess' ) ) ?>"><?php echo esc_html( self::get_field( 'ai_openai_key_purchase_mess' ) ) ?></textarea>

                                            <?php
                                            /*WPML.org*/
                                            if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                                $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                                if ( count( $languages ) ) {
                                                    foreach ( $languages as $key => $language ) {
                                                        if ( $language['active'] ) {
                                                            continue;
                                                        }
                                                        $wpml_ai_openai_key_purchase_mess = self::get_field( 'ai_openai_key_purchase_mess_' . $key );
                                                        if ( ! $wpml_ai_openai_key_purchase_mess ) {
                                                            $wpml_ai_openai_key_purchase_mess = self::get_field( 'ai_openai_key_purchase_mess' );
                                                        }
                                                        ?>
                                                        <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                                        <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_purchase_mess_' . $key ) ) ?>"><?php echo esc_html( $wpml_ai_openai_key_purchase_mess ) ?></textarea>
                                                    <?php }
                                                }
                                            } /*Polylang*/ elseif ( class_exists( 'Polylang' ) ) {
                                                $languages = pll_languages_list();

                                                foreach ( $languages as $language ) {
                                                    $default_lang = pll_default_language( 'slug' );

                                                    if ( $language == $default_lang ) {
                                                        continue;
                                                    }

                                                    $wpml_ai_openai_key_purchase_mess = self::get_field( 'ai_openai_key_purchase_mess_' . $language );
                                                    if ( ! $wpml_ai_openai_key_purchase_mess ) {
                                                        $wpml_ai_openai_key_purchase_mess = self::get_field( 'ai_openai_key_purchase_mess' );
                                                    }
                                                    ?>
                                                    <h4><?php echo esc_html( $language ) ?></h4>
                                                    <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_purchase_mess_' . $language ) ) ?>"><?php echo esc_html( $wpml_ai_openai_key_purchase_mess ) ?></textarea>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( 'Provide your prompt or specific instructions for the AI to generate messages in the \'Message Purchased\' input field under Messages. Ex:', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li><?php echo wp_kses_post( sprintf( __( 'Generate notification sentences that simulate recent purchases, product views, or inquiries, using numbers and locations, without urgency or exclamation marks', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo wp_kses_post( sprintf( __( 'Generate urgency-driven notification sentences, mentioning recent purchases, product views, inquiries, or popular demand, using numbers, locations, and a sense of immediacy', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MIN_CHARACTERS} : is min characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MAX_CHARACTERS} : is max characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_STYLE} : is writing style', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_TONE} : is writing tone', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                        </ol>
                                    </td>
                                </tr>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( '"Virtual First Name" prompt', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid ">
                                            <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_virtual_first_name' ) ) ?>"><?php echo esc_html( self::get_field( 'ai_openai_key_virtual_first_name' ) ) ?></textarea
                                            <?php
                                            /*WPML.org*/
                                            if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                                $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                                if ( count( $languages ) ) {
                                                    foreach ( $languages as $key => $language ) {
                                                        if ( $language['active'] ) {
                                                            continue;
                                                        }
                                                        $wpml_ai_openai_key_virtual_first_name = self::get_field( 'ai_openai_key_virtual_first_name_' . $key );
                                                        if ( ! $wpml_ai_openai_key_virtual_first_name ) {
                                                            $wpml_ai_openai_key_virtual_first_name = self::get_field( 'ai_openai_key_virtual_first_name' );
                                                        }
                                                        ?>
                                                        <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                                        <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_virtual_first_name_' . $key ) ) ?>"><?php echo esc_html( $wpml_ai_openai_key_virtual_first_name ) ?></textarea>
                                                    <?php }
                                                }
                                            } elseif ( class_exists( 'Polylang' ) ) {
                                                /*Polylang*/
                                                $languages = pll_languages_list();

                                                foreach ( $languages as $language ) {
                                                    $default_lang = pll_default_language( 'slug' );

                                                    if ( $language == $default_lang ) {
                                                        continue;
                                                    }

                                                    $wpml_ai_openai_key_virtual_first_name = self::get_field( 'ai_openai_key_virtual_first_name_' . $language );
                                                    if ( ! $wpml_ai_openai_key_virtual_first_name ) {
                                                        $wpml_ai_openai_key_virtual_first_name = self::get_field( 'ai_openai_key_virtual_first_name' );
                                                    }
                                                    ?>
                                                    <h4><?php echo esc_html( $language ) ?></h4>
                                                    <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_virtual_first_name_' . $language ) ) ?>"><?php echo esc_html( $wpml_ai_openai_key_virtual_first_name ) ?></textarea>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( 'Provide your prompt or specific instructions for the AI to generate customers\' names in the \'Virtual First Name\' input field under Products', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li><?php echo esc_html__( 'Shortcode {MIN_CHARACTERS} : is min characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MAX_CHARACTERS} : is max characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_STYLE} : is writing style', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_TONE} : is writing tone', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                        </ol>
                                    </td>
                                </tr>
                                <tr class="">
                                    <th scope="row">
                                        <label><?php esc_html_e( '"Virtual City" prompt', 'woocommerce-notification' ) ?></label>
                                    </th>
                                    <td>
                                        <div class="vi-ui fluid ">
                                            <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_virtual_city' ) ) ?>"><?php echo esc_html( self::get_field( 'ai_openai_key_virtual_city' ) ) ?></textarea>
                                            <?php
                                            /*WPML.org*/
                                            if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
                                                $languages = $langs = icl_get_languages( 'skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str' );

                                                if ( count( $languages ) ) {
                                                    foreach ( $languages as $key => $language ) {
                                                        if ( $language['active'] ) {
                                                            continue;
                                                        }
                                                        $wpml_ai_openai_key_virtual_city = self::get_field( 'ai_openai_key_virtual_city_' . $key );
                                                        if ( ! $wpml_ai_openai_key_virtual_city ) {
                                                            $wpml_ai_openai_key_virtual_city = self::get_field( 'ai_openai_key_virtual_city' );
                                                        }
                                                        ?>
                                                        <h4><?php echo esc_html( $language['native_name'] ) ?></h4>
                                                        <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_virtual_city_' . $key ) ) ?>"><?php echo esc_html( $wpml_ai_openai_key_virtual_city ) ?></textarea>
                                                    <?php }
                                                }
                                            } /*Polylang*/ elseif ( class_exists( 'Polylang' ) ) {
                                                $languages = pll_languages_list();

                                                foreach ( $languages as $language ) {
                                                    $default_lang = pll_default_language( 'slug' );

                                                    if ( $language == $default_lang ) {
                                                        continue;
                                                    }

                                                    $wpml_ai_openai_key_virtual_city = self::get_field( 'ai_openai_key_virtual_city_' . $language );
                                                    if ( ! $wpml_ai_openai_key_virtual_city ) {
                                                        $wpml_ai_openai_key_virtual_city = self::get_field( 'ai_openai_key_virtual_city' );
                                                    }
                                                    ?>
                                                    <h4><?php echo esc_html( $language ) ?></h4>
                                                    <textarea name="<?php echo esc_attr( self::set_field( 'ai_openai_key_virtual_city_' . $language ) ) ?>"><?php echo esc_html( $wpml_ai_openai_key_virtual_city ) ?></textarea>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </div>
                                        <p class="description">
                                            <?php
                                            echo wp_kses_post( sprintf( __( 'Provide your prompt or specific instructions for the AI to generate cities in the \'Virtual City\' input field under Products', 'woocommerce-notification' ), VI_WNOTIFICATION_CACHE ) );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
                                            ?>
                                        </p>
                                        <ol class="description">
                                            <li><?php echo esc_html__( 'Shortcode {MIN_CHARACTERS} : is min characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {MAX_CHARACTERS} : is max characters', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_STYLE} : is writing style', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                            <li><?php echo esc_html__( 'Shortcode {WRITING_TONE} : is writing tone', 'woocommerce-notification' );// phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment?></li>
                                        </ol>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Update !-->
                <div class="vi-ui bottom attached tab segment" data-tab="update">
                    <!-- Tab Content !-->
                    <table class="optiontable form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e( 'Auto Update Key', 'woocommerce-notification' ) ?></label>
                            </th>
                            <td>
                                <div class="fields">
                                    <div class="ten wide field">
                                        <input class="villatheme-autoupdate-key-field" type="text"
                                               name="<?php echo esc_attr( self::set_field( 'key' ) ) ?>"
                                               value="<?php echo esc_attr( self::get_field( 'key' ) ) ?>"/>
                                    </div>
                                    <div class="six wide field">
                                        <span class="vi-ui button small green villatheme-get-key-button"
                                              data-href="https://api.envato.com/authorization?response_type=code&client_id=villatheme-download-keys-6wzzaeue&redirect_uri=https://villatheme.com/update-key"
                                              data-id="16586926"><?php echo esc_html__( 'Get Key', 'woocommerce-notification' ) ?></span>
                                    </div>
                                </div>
                                <?php do_action( 'woocommerce-notification_key' ) ?>
                                <p class="description">
                                    <?php
                                    printf( "%s <a target='_blank' href='https://villatheme.com/my-download'>https://villatheme.com/my-download</a>. %s <a href='https://villatheme.com/knowledge-base/how-to-use-auto-update-feature/' target='_blank'>%s</a>", esc_html__( 'Please fill your key what you get from', 'woocommerce-notification' ), esc_html__( 'You can auto update WooCommerce Notification plugin.', 'woocommerce-notification' ), esc_html__( 'See guide', 'woocommerce-notification' ) );
                                    ?>
                                </p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <p style="position: relative; margin-bottom: 70px; display: inline-block;">
                    <button class="vi-ui button labeled icon primary wn-submit">
                        <i class="send icon"></i> <?php esc_html_e( 'Save', 'woocommerce-notification' ) ?>
                    </button>
                    <button class="vi-ui button labeled icon wn-submit"
                            name="<?php echo esc_attr( self::set_field( 'check_key' ) ) ?>">
                        <i class="send icon"></i> <?php esc_html_e( 'Save & Check Key', 'woocommerce-notification' ) ?>
                    </button>
                </p>
            </form>
            <?php do_action( 'villatheme_support_woocommerce-notification' ) ?>
        </div>
    <?php }

} ?>