<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Get WooCommerce Notification Data Setting
 * Class VI_WNOTIFICATION_Data
 */
class VI_WNOTIFICATION_Data {

    protected static $instance;
    private          $params;
    public static    $cache = [];

    public static function get_instance( $new = false ) {
        if ($new || null === self::$instance) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * WOOMULTI_CURRENCY_Data constructor.
     * Init setting
     */
    public function __construct() {
        global $woocommerce_notification_settings;
        if (!$woocommerce_notification_settings) {
            $woocommerce_notification_settings = get_option('wnotification_params', array());
        }

        $args = array(
            'enable'                           => 1,
            'enable_mobile'                    => 1,
            'enable_rtl'                       => 0,
            'highlight_color'                  => '#212121',
            'text_color'                       => '#212121',
            'background_color'                 => '#ffffff',
            'background_image'                 => '0',
            'image_position'                   => 0,
            'position'                         => 0,
            'border_radius'                    => 0,
            'image_border_radius'              => 0,
            'show_close_icon'                  => 1,
            'time_close'                       => 24,
            'image_redirect'                   => 0,
            'image_redirect_target'            => 0,
            'message_display_effect'           => 'bounceIn',
            'message_hidden_effect'            => 'bounceOutDown',
            'custom_css'                       => '',
            'message_purchased'                => array('Someone in {city} purchased a {product_with_link} {time_ago}', 'Someone in {city} purchased a {product_with_link_rating_atc} {time_ago}', '{custom}{product_with_link_rating}'),
            'custom_shortcode'                 => '{number} people seeing this product right now',
            'min_number'                       => '100',
            'max_number'                       => '200',
            'archive_page'                     => 2,
            'mask_customer_info'               => 0,
            'select_categories'                => array(),
            'cate_exclude_products'            => array(),
            'limit_product'                    => 50,
            'exclude_products'                 => array(),
            'order_threshold_num'              => 30,
            'order_threshold_time'             => 1,
            'order_statuses'                   => array('wc-processing', 'wc-completed'),
            'archive_products'                 => array(),
            'virtual_name'                     => "Oliver\r\nJack\r\nHarry\r\nJacob\r\nCharlie",
            'virtual_time'                     => 10,
            'country'                          => 1,
            'virtual_city'                     => "New York City, New York, USA\r\nEkwok, Alaska, USA\r\nLondon, England\r\nAldergrove, British Columbia, Canada\r\nURRAWEEN, Queensland, Australia\r\nBernau, Freistaat Bayern, Germany",
            'virtual_country'                  => '',
            'ipfind_auth_key'                  => '',
            'product_sizes'                    => 'shop_thumbnail',
            'non_ajax'                         => 1,
            'enable_single_product'            => 0,
            'enable_out_of_stock_product'      => 0,
            'notification_product_show_type'   => 1,
            'show_variation'                   => 0,
            'loop'                             => 1,
            'next_time'                        => 30,
            'notification_per_page'            => 60,
            'initial_delay_random'             => 0,
            'initial_delay_min'                => 0,
            'initial_delay'                    => 5,
            'display_time'                     => 5,
            'sound_enable'                     => 0,
            'sound'                            => 'cool.mp3',
            'is_home'                          => 0,
            'is_checkout'                      => 0,
            'is_cart'                          => 0,
            'conditional_tags'                 => '',
            'save_logs'                        => 0,
            'history_time'                     => 30,
            'key'                              => '',
            'product_link'                     => 0,
            'rounded_corner'                   => 0,
            'loop_session'                     => 0,
            'loop_session_duration'            => 1,
            'loop_session_duration_unit'       => 'h',
            'loop_session_total'               => '60',

            //new option
            'change_virtual_time_enable'       => '',
            'change_message_number_enable'     => '',
            'product_visibility'               => array('visible', 'catalog', 'search'),
            'enable_current_category'          => 0,
            'name_by_country'                  => [],

            /* New options */
            'close_icon_style'                 => 1,
            'close_icon_background'            => '#000000',
            'close_icon_color_default'         => '#ffffff',
            'close_icon_color_classic'         => '#000000',
            'image_padding'                    => 0,
            'preview_rating'                   => 1,
            'preview_atc'                      => 1,

            /*AI engine*/
            'ai_type'                          => [],
            'ai_command_min_characters'        => 20,
            'ai_command_max_characters'        => 100,
            'ai_command_writing_style'         => 'Descriptive',
            'ai_command_writing_tone'          => 'Neutral',
            /*Gemini*/
            'ai_gemini_api_key'                => '',
            'ai_gemini_version'                => 'v1beta',
            'ai_gemini_model'                  => 'models/gemini-pro',
            'ai_gemini_key_purchase_mess'      => 'Write 1 short different social proof notifications for purchase purpose. Must be between {MIN_CHARACTERS} and {MAX_CHARACTERS} characters. Style: {WRITING_STYLE}. Tone: {WRITING_TONE}.',
            'ai_gemini_key_virtual_first_name' => '5 virtual people first names, one name per line. Style: {WRITING_STYLE}. Tone: {WRITING_TONE}.',
            'ai_gemini_key_virtual_city'       => '5 cities address. Ex:New York City, New York, USA. Style: {WRITING_STYLE}. Tone: {WRITING_TONE}.',
            /*OpenAI*/
            'ai_openai_api_key'                => '',
            'ai_openai_model'                  => 'gpt-4o-mini',
            'ai_openai_key_purchase_mess'      => 'Write 1 short different social proof notifications for purchase purpose. Must be between {MIN_CHARACTERS} and {MAX_CHARACTERS} characters. Style: {WRITING_STYLE}. Tone: {WRITING_TONE}.',
            'ai_openai_key_virtual_first_name' => '5 virtual people first names, one name per line. Style: {WRITING_STYLE}. Tone: {WRITING_TONE}.',
            'ai_openai_key_virtual_city'       => '5 cities address. Ex:New York City, New York, USA. Style: {WRITING_STYLE}. Tone: {WRITING_TONE}.',
        );

        $this->params = apply_filters('woonotification_settings_args', wp_parse_args($woocommerce_notification_settings, $args));
    }

    public function get_params( $name = "", $default = null ) {
        if (!$name) {
            return $this->params;
        }
        $language = $this->get_current_lang();
        if ($language && strpos($language, '_') !== 0) {
            $language = '_' . $language;
        }
        $name_t      = $name . $language;
        $name_filter = 'woonotification_' . $name_t;
        switch ($name) {
            case 'image_padding':
            case 'loop_session':
            case 'loop_session_duration':
            case 'loop_session_duration_unit':
            case 'loop_session_total':
            case 'rounded_corner':
            case 'time_close':
            case 'highlight_color':
            case 'text_color':
            case 'background_color':
            case 'background_image':
            case 'image_position':
            case 'position':
            case 'border_radius':
            case 'image_border_radius':
            case 'message_display_effect':
            case 'message_hidden_effect':
            case 'custom_css':
            case 'message_purchased':
            case 'custom_shortcode':
            case 'min_number':
            case 'max_number':
            case 'archive_page':
            case 'select_categories':
            case 'cate_exclude_products':
            case 'limit_product':
            case 'exclude_products':
            case 'order_threshold_num':
            case 'order_threshold_time':
            case 'order_statuses':
            case 'archive_products':
            case 'virtual_name':
            case 'virtual_time':
            case 'virtual_city':
            case 'virtual_country':
            case 'notification_product_show_type':
            case 'next_time':
            case 'notification_per_page':
            case 'initial_delay_min':
            case 'initial_delay':
            case 'display_time':
            case 'sound':
            case 'conditional_tags':
            case 'history_time':
                $name_filter = 'woonotification_get_' . $name_t;
                break;
        }

        return apply_filters($name_filter, $this->params[$name_t] ?? $this->params[$name] ?? $default);
    }

    public static function get_current_lang() {
        if (isset(self::$cache['current_lang'])) {
            return self::$cache['current_lang'];
        }
        if (is_plugin_active('sitepress-multilingual-cms/sitepress.php')) {
            $current_lang = wpml_get_current_language();
        } elseif (class_exists('Polylang')) {
            $current_lang = pll_current_language('slug');
        }

        return self::$cache['current_lang'] = $current_lang ?? '';
    }

    /**
     * Get product image size
     *
     * @return mixed|void
     */
    public function get_product_sizes() {
        $selected_product_sizes = $this->get_params('product_sizes');
        $mapping                = [
            'shop_thumbnail' => 'woocommerce_thumbnail',
            'shop_catalog'   => 'woocommerce_gallery_thumbnail',
            'shop_single'    => 'woocommerce_single',
        ];

        return apply_filters('woonotification_get_product_sizes', $mapping[$selected_product_sizes] ?? $selected_product_sizes);
    }


    /**
     * Enable RTL
     *
     * @return mixed|void
     */
    public function enable_rtl() {
        if (isset(self::$cache['is_rtl'])) {
            return self::$cache['is_rtl'];
        }

        return self::$cache['is_rtl'] = is_rtl();
    }

    public function get_button_atc_html( $product ) {
        $product = wc_get_product($product);
        if (!$product) {
            return '';
        }
        if (!$product->is_purchasable() && !$product->is_type(['external'])) {
            return '';
        }
        if ($product->is_type(['simple']) && !$product->is_in_stock()) {
            return '';
        }
        $can_atc = true;
        if ($product->is_type(['variation'])) {
            $attributes = $product->get_attributes();
            if (!empty($attributes)) {
                foreach ($attributes as $k => $v) {
                    ob_start();
                    var_dump($k . ' : ' . $v);
                    error_log(ob_get_clean());
                    if ($v == '') {
                        $can_atc = false;
                        break;
                    }
                }
            } else {
                $can_atc = false;
            }
        }
        $atc_args = apply_filters('woocommerce_loop_add_to_cart_args', wp_parse_args(array(
            'quantity'              => 1,
            'class'                 => implode(
                ' ',
                array_filter(
                    array(
                        'button viwn-add-to-cart-button',
                        wc_wp_theme_get_element_class_name('button'), // escaped in the template.
                        'product_type_' . $product->get_type(),
                        $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $can_atc ? 'viwn-can-add-to-cart' : '',
                        $can_atc && $product->supports('ajax_add_to_cart') && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'aria-describedby_text' => $product->add_to_cart_aria_describedby(),
            'attributes'            => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        )), $product);

        if (!empty($atc_args['attributes']['aria-describedby'])) {
            $atc_args['attributes']['aria-describedby'] = wp_strip_all_tags($atc_args['attributes']['aria-describedby']);
        }

        if (isset($atc_args['attributes']['aria-label'])) {
            $atc_args['attributes']['aria-label'] = wp_strip_all_tags($atc_args['attributes']['aria-label']);
        }

        return apply_filters(
            'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
            sprintf(
                '<a href="%s" aria-describedby="woocommerce_loop_add_to_cart_link_describedby_%s" data-quantity="%s" class="%s" %s>%s</a>',
                esc_url($product->add_to_cart_url()),
                esc_attr($product->get_id()),
                esc_attr(isset($atc_args['quantity']) ? $atc_args['quantity'] : 1),
                esc_attr(isset($atc_args['class']) ? $atc_args['class'] : 'button'),
                isset($atc_args['attributes']) ? wc_implode_html_attributes($atc_args['attributes']) : '',
                esc_html($product->add_to_cart_text())
            ),
            $product,
            $atc_args
        );
    }

    /**
     * @param $message
     * @param $data
     * @return array|string|string[]
     */
    public function ai_command_replace_shortcodes( $message, $data = [] ) {
        $arr = array(
            '{WRITING_STYLE}'  => isset($data['writing_style']) ? $data['writing_style'] : '',
            '{WRITING_TONE}'   => isset($data['writing_tone']) ? $data['writing_tone'] : '',
            '{MIN_CHARACTERS}' => isset($data['min_characters']) ? $data['min_characters'] : '',
            '{MAX_CHARACTERS}' => isset($data['max_characters']) ? $data['max_characters'] : '',
        );

        return str_replace(array_keys($arr), array_values($arr), $message);
    }

    /**
     * Get Virtual Country
     * @return mixed|void
     */
    public function get_virtual_country() {
        if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
            $current_lang = wpml_get_current_language();
            if ( isset( $this->params[ 'virtual_country_' . $current_lang ] ) ) {
                return apply_filters( 'woonotification_get_virtual_country_' . $current_lang, $this->params[ 'virtual_country_' . $current_lang ] );
            } elseif ( class_exists( 'Polylang' ) ) {
                $current_lang = pll_current_language( 'slug' );
                if ( isset( $this->params[ 'message_purchased_' . $current_lang ] ) ) {
                    return apply_filters( 'woonotification_get_message_purchased_' . $current_lang, $this->params[ 'message_purchased_' . $current_lang ] );
                }
            }
        }

        return apply_filters( 'woonotification_get_virtual_country', $this->params['virtual_country'] );
    }

}