/*!
 * dependsOn v1.0.2
 * a jQuery plugin to facilitate the handling of form field dependencies.
 *
 * Copyright (c) 2015 David Street
 * @license the MIT license.
 */
(function($){var Dependency=function(selector,qualifiers){this.selector=selector;this.$dependencyObj=$(selector);this.qualifiers=qualifiers};Dependency.prototype.enabled=function(checkAgainst){if($(this.selector+"[disabled]").length>0){if(checkAgainst){return false}}else{if(!checkAgainst){return false}}return true};Dependency.prototype.checked=function(checkAgainst){if(this.$dependencyObj.attr("type")==="checkbox"){if(!this.$dependencyObj.is(":checked")&&checkAgainst||this.$dependencyObj.is(":checked")&&!checkAgainst){return false}}return true};Dependency.prototype.values=function(checkAgainst){var dependencyValue=this.$dependencyObj.val(),length=checkAgainst.length,i=0,match=false;if(this.$dependencyObj.attr("type")==="radio"){dependencyValue=this.$dependencyObj.filter(":checked").val()}for(i;i<length;i+=1){if(typeof dependencyValue==="array"||typeof dependencyValue==="object"){if($(this.$dependencyObj.val()).not($(checkAgainst[i])).length===0&&$(checkAgainst[i]).not($(this.$dependencyObj.val())).length===0){match=true;break}}else{if(checkAgainst[i]===dependencyValue){match=true;break}}}return match};Dependency.prototype.not=function(checkAgainst){var dependencyValue=this.$dependencyObj.val(),length=checkAgainst.length,i=0;if(this.$dependencyObj.attr("type")==="radio"){dependencyValue=this.$dependencyObj.filter(":checked").val()}for(i;i<length;i+=1){if(checkAgainst[i]===dependencyValue){return false}}return true};Dependency.prototype.match=function(checkAgainst){var dependencyValue=this.$dependencyObj.val(),pattern=checkAgainst;return pattern.test(dependencyValue)};Dependency.prototype.contains=function(checkAgainst){var dependencyValue=this.$dependencyObj.val(),i=0;if(typeof dependencyValue==="array"||typeof dependencyValue==="object"){for(i in checkAgainst){if($.inArray(checkAgainst[i],dependencyValue)!==-1){return true}}}else{return this.values(checkAgainst)}return false};Dependency.prototype.email=function(checkAgainst){var emailPattern=/^[_a-zA-Z0-9\-]+(\.[_a-zA-Z0-9\-]+)*@[a-zA-Z0-9\-]+(\.[a-zA-Z0-9\-]+)*\.(([0-9]{1,3})|([a-zA-Z]{2,3})|(aero|coop|info|museum|name))$/;return this.match(emailPattern)===checkAgainst};Dependency.prototype.url=function(checkAgainst){var urlPattern=/(((http|ftp|https):\/\/)|www\.)[\w\-_]+(\.[\w\-_]+)+([\w\-\.,@?\^=%&:\/~\+#!]*[\w\-\@?\^=%&\/~\+#])?/g;return this.match(urlPattern)===checkAgainst};Dependency.prototype.doesQualify=function(){var q=0;for(q in this.qualifiers){if(Dependency.prototype.hasOwnProperty(q)&&typeof Dependency.prototype[q]==="function"){if(!this[q](this.qualifiers[q])){return false}}else{if(typeof(this.qualifiers[q]==="function")){return this.qualifiers[q](this.$dependencyObj.val())}}}return true};var DependencySet=function(dependencies){var d=0;this.dependencies=[];for(d in dependencies){this.dependencies.push(new Dependency(d,dependencies[d]))}};DependencySet.prototype.doesQualify=function(){var length=this.dependencies.length,d=0,qualifies=true;for(d;d<length;d+=1){if(!this.dependencies[d].doesQualify()){qualifies=false;break}}return qualifies};var DependencyCollection=function($subject,initalSet,options){this.dependencySets=[];this.$subject=$subject;this.settings=$.extend({disable:true,hide:true,duration:200,onEnable:function(){},onDisable:function(){}},options);this.enableCallback=function(){};this.disableCallback=function(){};this.init(initalSet)};DependencyCollection.prototype.init=function(dependencies){this.addSet(dependencies);this.check(true)};DependencyCollection.prototype.addSet=function(set){var self=this,thisSet=0,numDependencies=0,d=0,dependency;this.dependencySets.push(new DependencySet(set));thisSet=this.dependencySets.length-1;numDependencies=this.dependencySets[thisSet].dependencies.length;for(d;d<numDependencies;d+=1){dependency=this.dependencySets[thisSet].dependencies[d];dependency.$dependencyObj.on("change",function(e){self.triggeredEvent=e;self.triggeredDependency=this;self.check()});if(dependency.$dependencyObj.attr("type")==="text"){dependency.$dependencyObj.on("keypress",function(e){if(e.which&&dependency.$dependencyObj.is(":focus")){if(self.check()){self.triggeredEvent=e;self.triggeredDependency=this;self.check()}}})}}};DependencyCollection.prototype.or=function(dependencies){this.addSet(dependencies);this.check(false);return this};DependencyCollection.prototype.enable=function(noFade){var valueSubject=this.$subject,subjectId=this.$subject.attr("id"),$hideObject;if(this.settings.hasOwnProperty("valueTarget")&&this.settings.valueTarget!==undefined){valueSubject=$(this.settings.valueTarget)}else if(this.$subject[0].nodeName.toLowerCase()!=="input"&&this.$subject[0].nodeName.toLowerCase()!=="textarea"&&this.$subject[0].nodeName.toLowerCase()!=="select"){valueSubject=this.$subject.find("input, textarea, select")}if(this.settings.disable){this.$subject.removeAttr("disabled")}if(this.settings.hide){if(this.$subject.parent()[0].nodeName.toLowerCase()==="label"){$hideObject=this.$subject.parent()}else{$hideObject=this.$subject.add('label[for="'+subjectId+'"]')}if($hideObject.css("display")==="none"){if(noFade){$hideObject.show()}else{$hideObject.fadeIn(this.settings.duration)}}}if(this.settings.hasOwnProperty("valueOnEnable")&&this.settings.valueOnEnable!==undefined){valueSubject.val(this.settings.valueOnEnable)}if(this.settings.hasOwnProperty("checkOnEnable")){if(this.settings.checkOnEnable){valueSubject.attr("checked","checked")}else{valueSubject.removeAttr("checked")}}if(this.settings.hasOwnProperty("toggleClass")&&this.settings.toggleClass!==undefined){this.$subject.addClass(this.settings.toggleClass)}this.settings.onEnable.call(this.triggeredDependency,this.triggeredEvent)};DependencyCollection.prototype.disable=function(noFade){var valueSubject=this.$subject,subjectId=this.$subject.attr("id"),$hideObject;if(this.settings.hasOwnProperty("valueTarget")&&this.settings.valueTarget!==undefined){valueSubject=$(this.settings.valueTarget)}else if(this.$subject[0].nodeName.toLowerCase()!=="input"&&this.$subject[0].nodeName.toLowerCase()!=="textarea"&&this.$subject[0].nodeName.toLowerCase()!=="select"){valueSubject=this.$subject.find("input, textarea, select")}if(this.settings.disable){this.$subject.attr("disabled","disabled")}if(this.settings.hide){if(this.$subject.parent()[0].nodeName.toLowerCase()==="label"){$hideObject=this.$subject.parent()}else{$hideObject=this.$subject.add('label[for="'+subjectId+'"]')}if(noFade){$hideObject.css({display:"none"})}else{$hideObject.fadeOut(this.settings.duration)}}if(this.settings.hasOwnProperty("valueOnDisable")&&this.settings.valueOnDisable!==undefined){valueSubject.val(this.settings.valueOnDisable)}if(this.settings.hasOwnProperty("checkOnDisable")){if(this.settings.checkOnDisable){valueSubject.attr("checked","checked")}else{valueSubject.removeAttr("checked")}}if(this.settings.hasOwnProperty("toggleClass")&&this.settings.toggleClass!==undefined){this.$subject.removeClass(this.settings.toggleClass)}this.settings.onDisable.call(this.triggeredDependency,this.triggeredEvent)};DependencyCollection.prototype.check=function(firstRun){var length=this.dependencySets.length,i=0,qualifies=false;for(i;i<length;i+=1){if(this.dependencySets[i].doesQualify()){qualifies=true;break}}if(qualifies){this.enable(firstRun);return true}else{this.disable(firstRun);return false}};$.fn.dependsOn=function(dependencies,options){var dependencyCollection=new DependencyCollection(this,dependencies,options);return dependencyCollection}})(jQuery);