(function () {
    "use strict";

    document.addEventListener('appReady.EappsPricingTable', function() {
        var widgets = document.querySelectorAll('[data-elfsight-pricing-table-options]');

        Array.prototype.slice.call(widgets).forEach(function(widget) {
            var version = widget.getAttribute('data-elfsight-pricing-table-version');
            var options = widget.getAttribute('data-elfsight-pricing-table-options');
            var data = JSON.parse(decodeURIComponent(options));

            window.eappsPricingTable(widget, data);
            
            widget.removeAttribute('data-elfsight-pricing-table-options');
            widget.removeAttribute('data-elfsight-pricing-table-version');
            
            widget.data = {
                options: data,
                version: version
            };
        });
    });

    //= ../app/app/dist/pricing-table.js
})();