<?php

namespace Smush\Core\Membership;

use Smush\Core\Api\Smush_API;
use Smush\Core\Hub_Connector;
use WPMUDEV\Hub\Connector\Data;

class Membership {
	/**
	 * Static instance
	 *
	 * @var self
	 */
	private static $instance;

	/**
	 * Static instance getter
	 */
	public static function get_instance() {
		if ( empty( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * @var boolean
	 */
	private $is_pro;

	public function get_apikey() {
		return 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';
	}

	/**
	 * Validate the installation.
	 *
	 * @param bool $force Force revalidation.
	 * @return void
	 */
	public function validate_install( $force = false ) {
		$api_key = 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';
		$api_auth = array();
		$api_auth[$api_key] = array('validity' => 'valid', 'timestamp' => time());
		update_site_option('wp_smush_api_auth', $api_auth);
		
		$cdn_status = array(
			'cdn_enabled' => true,
			'webp_enabled' => true
		);
		update_site_option('wp-smush-cdn_status', $cdn_status);
		
		$this->is_pro = true;
	}

	/**
	 * Check if the membership is pro.
	 *
	 * @return bool
	 */
	public function is_pro() {
		return true;
	}

	/**
	 * Check if the user has access to the hub.
	 *
	 * Warning: This method do not support old free users.
	 *
	 * @return bool
	 */
	public function has_access_to_hub() {
		return true;
	}

	/**
	 * Check if access to the Hub access is required to use the API.
	 *
	 * @return bool
	 */
	public function is_api_hub_access_required() {
		return false;
	}
}