<?php
// Register license page in admin menu
add_action('admin_menu', 'eventer_register_license_page');
function eventer_register_license_page() {
    add_submenu_page(
        'edit.php?post_type=eventer',
        __('License', 'eventer'),
        __('License', 'eventer'),
        'manage_options',
        'eventer-license',
        'eventer_license_callback'
    );
}

define('EVENTER_PRODUCT_ID', '20972534');
define('EVENTER_LICENSE_OPTION_CODE', 'eventer_auth_code');
define('EVENTER_LICENSE_OPTION_STATUS', 'eventer_authenticate');
define('EVENTER_SUPPORT_UNTIL_OPTION', 'eventer_support_until');

require_once EVENTER__PLUGIN_PATH . '/admin/lib/imi-license-helper.php';

imi_register_auth_ajax_handler(
	'eventer_processAuthentication',
	EVENTER_LICENSE_OPTION_CODE,
	EVENTER_LICENSE_OPTION_STATUS,
	EVENTER_SUPPORT_UNTIL_OPTION
);
imi_schedule_license_check(
	EVENTER_PRODUCT_ID,
	EVENTER_LICENSE_OPTION_CODE,
	EVENTER_LICENSE_OPTION_STATUS,
	EVENTER_SUPPORT_UNTIL_OPTION
);

add_action('admin_notices', function () {
	imi_fetch_and_display_banners(
		EVENTER_PRODUCT_ID,
		EVENTER_LICENSE_OPTION_CODE
	);
});
imi_register_license_guard([
    'purchase_option'  => EVENTER_LICENSE_OPTION_CODE,
    'welcome_page'     => 'eventer-license',
    'restricted_pages' => [
        'eventer_settings_options',
        'eventer_bookings',
    ],
    'skip_on_local'    => true,
]);

// Display callback for the license activation page
function eventer_license_callback() {
  ?>
  <div class="wrap about-wrap">
    <h1><?php esc_html_e('License Activation', 'eventer'); ?></h1>
    <?php
    $purchaseCode = $purchaseCodeRaw = $showRegisterForm = "";
    $showUnRegisterForm = ' style="display: none;"';

    $purchase_code = imi_get_purchase_code( EVENTER_LICENSE_OPTION_CODE );
    if (!empty($purchase_code)) {
      $purchaseCode = "xxxxxx-xxxx-xxxxxxx-xxxxx" . substr($purchase_code, -4);
      $purchaseCodeRaw = $purchase_code;
      $showRegisterForm = ' style="display: none;"';
      $showUnRegisterForm = "";
    }
    ?>
    <div class="imi-box-content activation_welcome_box" <?php echo $showRegisterForm; ?>>
      <p>
        <?php echo esc_html__('Thank you for choosing Eventer! Please register it to get access to all the features & settings. The instructions below must be followed exactly to successfully register your purchase.', 'eventer'); ?>
      </p>
      <div class="eventer-activate"></div>
    </div>
    <div class="eventer-validation-steps">
      <div class="imi-box-content imi-theme-reg-box" <?php echo $showUnRegisterForm; ?>>
        <h3 style="color: green; text-align: left"><?php esc_html_e('Plugin is active', 'eventer'); ?></h3>
      </div>
      <div class="imi-box-content imi-theme-reg-box" <?php echo $showRegisterForm; ?>>
        <h3 style="color: red; text-align: left"><?php esc_html_e('Please activate your Eventer purchase code', 'eventer'); ?></h3>
      </div>
      <div class="imi-box-content">
        <form class="imi_eventer_val" <?php echo $showRegisterForm; ?>>
          <label for="imi_purchase_code"><?php esc_html_e('Purchase Code:', 'framework') ?></label>
          <input type="text" value="" class="eventer-purchase-code">
          <input type="hidden" value="<?php echo urlencode(site_url()); ?>" class="eventer-verified-dm">
          <button type="submit" class="imi-submit-btn">Register</button>
          <div class="eventer-message"></div>
        </form>
        <form class="imi_eventer_vals" <?php echo $showUnRegisterForm; ?>>
          <label for="imi_purchase_code"><?php esc_html_e('Purchase Code:', 'framework') ?></label>
          <input type="text" class="eventer-hidden-code" value="<?php echo esc_attr($purchaseCode); ?>">
          <input type="hidden" value="<?php echo urlencode(site_url()) ?>" class="eventer-verified-dm">
          <input type="hidden" value="<?php echo esc_attr($purchaseCodeRaw); ?>" class="eventer-purchase-code">
          <button type="submit" class="imi-submit-btn">Unregister</button>
          <p><small><?php esc_html_e('Unregister the purchase code to use it on any other domain/website.', 'eventer'); ?></small></p>
          <div class="eventer-message"></div>
        </form>
        <div <?php echo $showRegisterForm; ?>>
          <h3><?php esc_html_e('Instructions for registering your purchase code', 'framework'); ?></h3>
          <p><?php esc_html_e('Whenever you purchase an item via Codecanyon, they will provide you with a purchase code for each item purchased. The purchase code is used for purchase validation for use of the item and also so that you can access the support.', 'eventer'); ?></p>
          <ol>
            <li><?php esc_html_e('Log in to Codecanyon with your Envato account.', 'eventer'); ?></li>
            <li><?php esc_html_e('Navigate to the Downloads tab. Your all purchases and items appear in this page.', 'eventer'); ?></li>
            <li><?php esc_html_e('Locate your item, and click the Download button.', 'eventer'); ?></li>
            <li><?php esc_html_e('Choose between License Certificate & Purchase Code (PDF) or License Certificate & Purchase Code (Text).', 'eventer'); ?></li>
            <li><?php esc_html_e('Open the file to find the purchase code.', 'eventer'); ?></li>
          </ol>
          <p><a href="https://www.youtube.com/watch?v=yTScONNFnZ8" target="_blank"><?php esc_html_e('See instructions video', 'eventer'); ?></a></p>
        </div>
      </div>
    </div>
  </div>
  <?php
}

add_action('admin_enqueue_scripts', function () {
    if ( defined('EVENTER__PLUGIN_URL') ) {
        wp_enqueue_script('imi-banners', EVENTER__PLUGIN_URL . '/admin/lib/imi-banners.js', [], null, true);
    }
});
