jQuery(document).ready(function($){
   $('#filter_eventer_bookins').on('click', function(event) {
        event.preventDefault();

        var searchEvent = $('select[name="eventer"]').val();
        var startDate = $('input[name="start_date"]').val();
        var endDate = $('input[name="end_date"]').val();
        var eventDate = $('input[name="event_date"]').val();
        var orderStatus = $('select[name="order_status"]').val();
        var selectedCheckboxes = $('.form-eventer_bookins input[type="checkbox"]:checked');

        var newUrl = $('.form-eventer_bookins').attr('action');

        if (searchEvent.length) {
            newUrl += '&eventer=' + encodeURIComponent(searchEvent);
        }

        if (startDate.length) {
            newUrl += '&start_date=' + encodeURIComponent(startDate);
        }

        if (endDate.length) {
            newUrl += '&end_date=' + encodeURIComponent(endDate);
        }

        if (eventDate.length) {
            newUrl += '&event_date=' + encodeURIComponent(eventDate);
        }
        if (orderStatus.length) {
            newUrl += '&order_status=' + encodeURIComponent(orderStatus);
        }

        var bookings = [];
        selectedCheckboxes.each(function() {
            bookings.push($(this).val());
        });

        if (bookings.length) {
            newUrl += '&multipleslect[]=' + bookings.join(',');
        }

        newUrl += '&action=filter_action';

        window.location.replace(newUrl);
    });
    $(document).on('focus', '.eventer-bookings-date', function () {
        if (!$(this).hasClass('hasDatepicker')) {
            $(this).datepicker({
                dateFormat: 'yy-mm-dd',
                changeMonth: true,
                changeYear: true
            });
        }
    });

    // Handle reset button to clear date fields
    $('#reset_eventer_filters').on('click', function(event) {
        event.preventDefault();

        var form = $('.form-eventer_bookins');
        form.find('select[name="eventer"]').val('');
        form.find('input[name="start_date"]').val('');
        form.find('input[name="end_date"]').val('');
        form.find('input[name="event_date"]').val('');
        form.find('select[name="order_status"]').val('');

        form.submit(); // Refresh form
    });


    $(".custom-bulk-delete").on("click", function() { // Target all buttons
        var selectedBookings = [];
        $("input[name='bulk-delete[]']:checked").each(function() {
            selectedBookings.push($(this).val());
        });

        if (selectedBookings.length === 0) {
            alert("Please select at least one booking to delete.");
            return;
        }

        if (!confirm("Are you sure you want to delete selected bookings?")) {
            return;
        }

        $.ajax({
            url: ajaxurl,
            type: "POST",
            data: {
                action: "custom_bulk_delete_bookings",
                delete_bookings: selectedBookings,
                _ajax_nonce: "<?php echo wp_create_nonce('bulk-delete-bookings'); ?>"
            },
            beforeSend: function() {
                $(".custom-bulk-delete").text("Deleting...").prop("disabled", true);
            },
            success: function(response) {
                if (response.success) {
                    alert(response.data.message);
                    location.reload();
                } else {
                    alert("Error: " + response.data.message);
                }
            },
            error: function() {
                alert("Something went wrong.");
            },
            complete: function() {
                $(".custom-bulk-delete").text("Delete Selected").prop("disabled", false);
            }
        });
    }); 
});

jQuery(function ($) {
    
    if ($.fn.select2) {
        $('select[name="eventer"]').select2({
            width: '300px',
            placeholder: 'Select an event',
            allowClear: true
        });
    }

    function initDatepicker(dates) {
    const input = $('input[name="event_date"]');

    input.datepicker('destroy');

    if (!dates || !dates.length) {
        input.val('');
        input.datepicker({
            dateFormat: 'yy-mm-dd',
            changeMonth: true,
            changeYear: true,
            beforeShowDay: () => [false], // disables all
            onSelect: function () {
                input.blur();
                input.datepicker('hide');
            }
        });
        return;
    }

    const dateObjects = dates.map(d => $.datepicker.parseDate('yy-mm-dd', d));
    const firstValidDate = dateObjects[0];
    const lastValidDate = dateObjects[dateObjects.length - 1];

    input.datepicker({
        dateFormat: 'yy-mm-dd',
        changeMonth: true,
        changeYear: true,
        minDate: firstValidDate,
        maxDate: lastValidDate,
        defaultDate: null,
        beforeShow: function () {
            // Open to selected date if valid, else to first valid
            const selected = input.val();
            const openTo = dates.includes(selected)
                ? $.datepicker.parseDate('yy-mm-dd', selected)
                : new Date();

            setTimeout(() => {
                $(this).datepicker('setDate', openTo);
            }, 10);
        },
        beforeShowDay: function (date) {
            const ymd = $.datepicker.formatDate('yy-mm-dd', date);
            return [dates.includes(ymd)];
        },
        onSelect: function (dateText) {
            input.val(dateText);
            input.datepicker('hide');
            input.blur();
        }
    });

    // ✅ Do NOT set value
    // Just leave input empty unless already valid
    const prevDate = input.val();
    if (!dates.includes(prevDate)) {
        input.val('');
    }
}

    // Initial load
    initDatepicker(eventerBookingData.validDates || []);

    // On event change
    $('select[name="eventer"]').on('change', function () {
        var eventID = $(this).val();

        if (!eventID) {
            initDatepicker([]);
            return;
        }

        $.post(ajaxurl, {
            action: 'eventer_get_event_dates_woo_bookings',
            eventer: eventID
        }, function (res) {
            if (res.success && Array.isArray(res.data)) {
                initDatepicker(res.data);
            } else {
                initDatepicker([]);
            }
        });
    });
});

