jQuery(document).ready(function ($) {
    $('.eventer-check-in-dropdown').on('change', function () {
        const $dropdown = $(this);
        const ticketId = $dropdown.data('ticket-id'); // Get the ticket ID
        const status = $dropdown.val();

        // Update the class based on the selected value
        $dropdown
            .removeClass('checked-in not-checked-in')
            .addClass(status === 'Yes' ? 'checked-in' : 'not-checked-in');

        $.ajax({
            url: eventerCheckIn.ajax_url,
            type: 'POST',
            data: {
                action: 'eventer_update_check_in',
                security: eventerCheckIn.nonce,
                ticket_id: ticketId, // Send ticket ID
                status: status,
            },
            beforeSend: function () {
                $dropdown.prop('disabled', true);
            },
            success: function (response) {
                if (response.success) {
                    alert(response.data.message);
                } else {
                    alert(response.data.message || 'Error updating status.');
                }
            },
            complete: function () {
                $dropdown.prop('disabled', false);
            },
        });
    });
});
