(function () {
  function initImiBanners(root = document) {
    // 1) Hide any banners the user has previously dismissed
    root.querySelectorAll('.imi-notice[data-banner-id]').forEach(function (el) {
      const id = el.getAttribute('data-banner-id');
      if (!id) return;
      if (sessionStorage.getItem('imi_banner_dismissed_' + id) === '1') {
        el.remove();
      }
    });

    // 2) De-dupe banners by data-banner-id (keep the first one)
    const seen = new Set();
    root.querySelectorAll('.imi-notice[data-banner-id]').forEach(function (el) {
      const id = el.getAttribute('data-banner-id');
      if (!id) return;
      if (seen.has(id)) {
        el.remove();
      } else {
        seen.add(id);
      }
    });

    // 3) Persist dismiss clicks
    root.querySelectorAll('.imi-notice[data-banner-id]').forEach(function (el) {
      const id = el.getAttribute('data-banner-id');
      const closeBtn = el.querySelector('.notice-dismiss');
      if (!id || !closeBtn) return;

      closeBtn.addEventListener('click', function () {
        sessionStorage.setItem('imi_banner_dismissed_' + id, '1');
      });
    });
  }

  // Run once when admin DOM is ready
  document.addEventListener('DOMContentLoaded', function () {
    initImiBanners();

    // Optional: If other code injects notices later, keep things tidy
    // by watching for inserted nodes and re-running just for those.
    const observer = new MutationObserver(function (mutations) {
      mutations.forEach(function (m) {
        m.addedNodes.forEach(function (node) {
          if (node.nodeType === 1 && node.matches && node.matches('.imi-notice')) {
            initImiBanners(node.parentNode || document);
          }
        });
      });
    });

    observer.observe(document.body, { childList: true, subtree: true });
  });
})();
