<?php
// This template is used to show how your shortcode will look when creating from settings of Eventer plugin
defined('ABSPATH') or die('No script kiddies please!');

get_header();

echo '<div class="eventer-preview-container" style="max-width:1140px; margin:0 auto;">';

if (!current_user_can('manage_options')) {
    wp_die(__('Unauthorized access', 'eventer'));
}

if (isset($_POST['shortcode'])) {
    esc_html_e('This page is only used to show how your shortcode will look. Some features might not work here. Please use this shortcode on a regular page for full functionality.', 'eventer');

    $allowed_shortcodes = [
        'eventer_grid',
        'eventer_list',
        'eventer_slider',
        'eventer_counter',
        'eventer_calendar',
        'eventer_fields',
        'eventer_add_new',
        'eventer_dashboard'
    ];

    $shortcode = wp_unslash($_POST['shortcode']);
    preg_match('/\[(\w+)/', $shortcode, $matches);
    $shortcode_name = $matches[1] ?? '';

    if (!in_array($shortcode_name, $allowed_shortcodes, true)) {
        wp_die(__('Shortcode not allowed on preview page.', 'eventer'));
    }

    echo do_shortcode(stripslashes($shortcode));
} else {
    esc_html_e('Sorry, nothing to show here. It seems you are accessing this page directly instead of from the Eventer shortcode settings.', 'eventer');
}

echo '</div>';
get_footer();
