<?php
$selected_date = date_i18n( 'Y-m-d', $params['event_cdate'] );

$registration_switch = get_post_meta($event_id, 'eventer_event_registration_swtich', true);
if ($registration_switch != "1") return;
$original_event = eventer_wpml_original_post_id($event_id);
$tickets = get_post_meta($original_event, 'wceventer_tickets', true);
$eventer_formatted_date = date_i18n('Y-m-d', $event_cdate);
$event_start_time_str = $start_str;
$event_end_time_str = $end_str;
$multi_state = (date_i18n('Y-m-d', $event_start_time_str) != date_i18n('Y-m-d', $event_end_time_str)) ? $event_start_time_str . '-' . $event_end_time_str : '';
$eventer_st_time = date_i18n("H:i", $event_start_time_str);
$booking_url = (function_exists('wc_get_cart_url')) ? wc_get_cart_url() : '';
$booking_url_target = get_post_meta($event_id, 'eventer_event_registration_target', true);
$commonBooking = get_post_meta($event_id, 'eventer_common_ticket_count', true);
$aviable_tickets = get_post_meta($event_id , 'eventer_event_available_tickets', true);
$registration_url = get_post_meta($event_id, 'eventer_event_custom_registration_url', true);
$time_slot = (date_i18n('H:i:s', strtotime($time_slot)) != '00:00:00') ? $time_slot : date_i18n('H:i:00', $event_start_time_str);
if (filter_var($registration_url, FILTER_VALIDATE_URL)) {
  $booking_url = $registration_url;
}
$new_updated_bookings = $all_tickets_name = array();
$eventer_maximum_tickets_count = eventer_get_settings('eventer_tickets_quantity_set');
$eventer_maximum_tickets_count = ($eventer_maximum_tickets_count) ? $eventer_maximum_tickets_count : 10;
$booking_calendar = eventer_get_settings('eventer_booking_calendar');
$booking_calendar_type = eventer_get_settings('eventer_booking_calendar_type');

$ticket_enabled_date = $bookingClsoed = $ticket_sale_status = '';

$difference = 1000;

// Get event start and end time
$eventer_start_time = get_post_meta($event_id, 'eventer_event_start_dt', true);
$eventer_end_time = get_post_meta($event_id, 'eventer_event_end_dt', true);

// Convert start and end times to timestamps
$event_start_time_str_f = strtotime($eventer_start_time);
$eventer_st_time = date_i18n("H:i", $event_start_time_str_f);
$event_end_time_str_f = strtotime($eventer_end_time);
$eventer_en_time = date_i18n("H:i", $event_end_time_str_f);

// Format proper start and end time
$eventer_formatted_proper_time = date_i18n('Y-m-d ' . $eventer_st_time, $event_cdate);
$eventer_formatted_proper_end_time = date_i18n('Y-m-d ' . $eventer_en_time, $event_cdate);

// Get global and per-event booking close time settings
$eventer_bookings_close_time = eventer_get_settings('eventer_bookings_close_time');
$eventer_event_bookings_close_time = get_post_meta($event_id, 'eventer_event_bookings_close_time', true);

// Determine the closing time for bookings
if (!empty($eventer_event_bookings_close_time)) {
    // Use per-event setting if available
    $close_booking_time = ($eventer_event_bookings_close_time === 'start') ? $eventer_formatted_proper_time : $eventer_formatted_proper_end_time;
} else {
    // Use global setting as fallback
    $close_booking_time = ($eventer_bookings_close_time === 'start') ? $eventer_formatted_proper_time : $eventer_formatted_proper_end_time;
}

// Get number of days before the event when booking should close
$booking_closes = get_post_meta($event_id, 'eventer_disable_booking_before', true);
$bookingClosed = 0; // Default to open

if ($booking_closes != '') {
    // Calculate the last possible booking time before closure
    $close_booking_timestamp = strtotime($close_booking_time . ' - ' . $booking_closes . ' days');

    // Get current timestamp
    $current_timestamp = current_time('timestamp');

    // Calculate the difference in days
    $difference = ceil(($close_booking_timestamp - $current_timestamp) / (60 * 60 * 24));

    if ($difference == 1) {
        $ticket_sale_status = '<div class="eventer-ticket-booking-status pull-right eventer-orange-bg">' . esc_html__('1 day left for booking', 'eventer') . '</div>';
    } elseif ($difference > 1 && $difference <= 4) {
        $ticket_sale_status = '<div class="eventer-ticket-booking-status pull-right eventer-orange-bg">' . $difference . esc_html__(' days left for booking', 'eventer') . '</div>';
    } elseif ($difference <= 0) {
        $bookingClosed = 1;
        $ticket_sale_status = '<div class="eventer-ticket-booking-status pull-right eventer-red-bg">' . esc_html__('Booking closed', 'eventer') . '</div>';
    }
}

$decimal_separator = $thousand_separator = $decimals = $woocommerce_currency = '';
if ( class_exists( 'WooCommerce' ) ) {
    // WooCommerce's settings for decimal places, thousand separator, and decimal separator
    $decimal_separator = wc_get_price_decimal_separator();
    $thousand_separator = wc_get_price_thousand_separator();
    $decimals = wc_get_price_decimals();
    $woocommerce_currency = get_woocommerce_currency_symbol();
}
?>

<?php 
ob_start();
if ( $booking_calendar_type == 'on' && count($all_dates) > 1 
	&& $days_diff <= 0 && get_post_type($event_id) == 'eventer'
	&& $booking_calendar == 'on' ) :
?>
	<select id="eventer-future-bookings" name="eventer-future-bookings" data-eventer="<?php echo esc_attr($event_id); ?>">
		<option value="" selected><?php esc_html_e('Select', 'eventer'); ?></option>
		<?php
		$all_dates = array_filter($all_dates, function ($date) {
			$start = date_i18n('Y-m-d G:i', strtotime(date_i18n("Y-m-d", time()) . " - 730 day"));
			$end = date_i18n('Y-m-d G:i', strtotime(date_i18n("Y-m-d", time()) . " + 730 day"));
			return (strtotime($date) >= strtotime($start) and strtotime($date) <= strtotime($end));
		});
		usort( $all_dates, 'eventer_compare_dates');
		foreach ($all_dates as $date) {
			$date = date_i18n('Y-m-d', strtotime( $date ) );
			$date_show = date_i18n(get_option('date_format'), strtotime( $date ) );

			if (strtotime($date) >= strtotime(date('Y-m-d'))) {
		        echo '<option value="' . esc_attr($date) . '" ' . ($selected_date == $date && $params['ajax'] == 1 ? 'selected="selected"' : '') . '>' . esc_attr($date_show) . '</option>';
		    }
		}
		?>
	</select>
<?php 
endif;
$select_date_html = ob_get_clean();
?>

<div class="eventer eventer-event-single">
  <div class="eventer-ticket-details-wrap">
    <?php
    $ticket_remaining_modal = $remaining_for_reg = $check_duplicate = '';
    $show_tickets_info = $tickets;
    $mandatory_time_slots = eventer_get_settings('eventer_time_slots_mandatory');
    if (!empty($show_tickets_info)) {
      echo '<div class="eventer-ticket-details" data-common="' . $commonBooking . '" data-date="' . esc_attr(date_i18n('Y-m-d', $event_cdate)) . '" data-time="' . esc_attr($time_slot) . '" data-slottitle="' . $time_slot_title . '">
        '.$ticket_sale_status.'
		<h3>' . esc_html__('Tickets details', 'eventer') . '</h3>';

			if ( $booking_calendar_type == 'on' ) {
				if ( count($all_dates) > 1 && $days_diff <= 0 && get_post_type($event_id) == 'eventer' && $booking_calendar == 'on' ) {
					echo '<label>' . esc_html__('Select Booking Date', 'eventer') . '</label>';
					echo $select_date_html;
				}

				// echo (count($all_dates) > 1 && $days_diff <= 0 && get_post_type($event_id) == 'eventer' && $booking_calendar == 'on') ? 
				// '<label>' . esc_html__('Select Booking Date', 'eventer') . '</label><input type="input" id="eventer-future-bookings" data-time="asdasdf" class="datepicker" style="display:none;"/>' : '';
			} else {
				echo ( $days_diff <= 0 && get_post_type($event_id) == 'eventer' && $booking_calendar == 'on') ? '<label>' . esc_html__('Select Booking Date', 'eventer') . '</label><input type="input" id="eventer-future-bookings" data-time="asdasdf" class="datepicker" style="display:none;"/>' : '';
			}

      // echo ($days_diff <= 0 && get_post_type($event_id) == 'eventer' && $booking_calendar == 'on') ? '<input type="input" id="eventer-future-bookings" data-time="asdasdf" class="datepicker" style="display:none;" />' : '';
      if($time_slot_values){	
       	echo '<label>'.esc_html__('Select Booking Slot', 'eventer').'</label>';
      	echo $time_slot_values;	
	  }
      echo '<ul class="eventer-tickets-info">';
      foreach ($show_tickets_info as $ticket) {
        $remaining_for_reg = $remaining_booked = '';
        $ticket_enabled_message = ''; // ensure defined
        $wceventer_ticket_id = (isset($ticket['wceventer_ticket_id'])) ? $ticket['wceventer_ticket_id'] : '';
        if (get_post_type($wceventer_ticket_id) != 'product' || get_post_status($wceventer_ticket_id) != 'publish') continue;

        $ticket_name = get_the_title($wceventer_ticket_id);
        $sold_individually = get_post_meta($wceventer_ticket_id, '_sold_individually', true);
        $eventer_maximum_tickets_count = ($sold_individually == 'yes') ? 1 : $eventer_maximum_tickets_count;

        $product = wc_get_product($wceventer_ticket_id);

        /**
         * Keep numeric for logic and attributes; format only for display.
         */
        $raw_price_num            = (float) wc_get_price_to_display($product);   // numeric current price (respects tax display)
        $ticket_regular_price_num = (float) $product->get_regular_price();       // numeric regular price

        // Old price (regular) – format only for display
        $show_old_price = ($currency_position != 'postfix')
            ? $woocommerce_currency . number_format($ticket_regular_price_num, $decimals, $decimal_separator, $thousand_separator)
            : number_format($ticket_regular_price_num, $decimals, $decimal_separator, $thousand_separator) . $woocommerce_currency;

        // Show <del> only if regular price is set and differs from current
        $old_price = ($ticket_regular_price_num > 0 && abs($raw_price_num - $ticket_regular_price_num) > 0.00001)
            ? '<del class="eventer-price-currency">' . $show_old_price . '</del> '
            : '';

        $new_booked_tickets_key = eventer_search_ticket($ticket_name, $booked_tickets, 0, $wceventer_ticket_id);
        $exact_ticket_find = (isset($booked_tickets[$new_booked_tickets_key])) ? $booked_tickets[$new_booked_tickets_key] : array();

        if (!empty($exact_ticket_find)) {
            $pid = (isset($exact_ticket_find['pid'])) ? $exact_ticket_find['pid'] : '';
            if ($pid == $wceventer_ticket_id || $exact_ticket_find['name'] == $ticket_name) {
                $ticket_name = esc_attr($exact_ticket_find['name']);
                $remaining_booked = esc_attr($exact_ticket_find['tickets']);

                // If a custom price is provided in the booked record, normalize and coerce to float safely
                if (isset($exact_ticket_find['price']) && $exact_ticket_find['price'] !== '') {
                    $clean = (string) $exact_ticket_find['price'];

                    // Strip currency symbol (if present)
                    if ($woocommerce_currency) {
                        $clean = str_replace($woocommerce_currency, '', $clean);
                    }
                    // Remove thousand separators (except space which we normalize via regex below)
                    if ($thousand_separator && $thousand_separator !== ' ') {
                        $clean = str_replace($thousand_separator, '', $clean);
                    }
                    // Normalize any spaces
                    $clean = preg_replace('/\s+/', '', $clean);

                    // Normalize decimal separator to dot
                    if ($decimal_separator && $decimal_separator !== '.') {
                        $clean = str_replace($decimal_separator, '.', $clean);
                    }

                    // Final numeric cast
                    $raw_price_num = (float) $clean;
                }

                $ticket_enabled = (isset($exact_ticket_find['enabled'])) ? $exact_ticket_find['enabled'] : '';
                $ticket_enabled_message = (strtotime($ticket_enabled) <= date_i18n('U')) ? '' : '<div class="event-ticket-sale-date">' . esc_html__('Ticket sale opens on', 'eventer') . ' ' . date_i18n(get_option('date_format'), strtotime($ticket_enabled)) . '</div>';
            }
        }

        if (in_array($ticket_name, $all_tickets_name)) {
            $check_duplicate = "1";
            continue;
        }
        $all_tickets_name[] = $ticket_name;

        $ticket_number = (isset($ticket['wceventer_ticket_number']) && $remaining_booked == '') ? $ticket['wceventer_ticket_number'] : $remaining_booked;

        // Build display string from numeric price
        $raw_price_display = number_format($raw_price_num, $decimals, $decimal_separator, $thousand_separator);

        // Final ticket price HTML (with currency position)
        $ticket_price = ($currency_position != 'postfix')
            ? $old_price . $woocommerce_currency . $raw_price_display
            : $old_price . $raw_price_display . $woocommerce_currency;

        $remain_for_booking = ($ticket_number > $eventer_maximum_tickets_count) ? $eventer_maximum_tickets_count : $ticket_number;

        $btn_txt = esc_html__('Add to cart', 'eventer');
        $added_cart = esc_html__('Added to cart', 'eventer');

        if ($bookingClsoed != 1) {
            echo '<li data-btntxt="' . esc_attr($btn_txt) . '" data-addedcart="' . esc_attr($added_cart) . '" data-currency="' . $woocommerce_currency . '" data-price="' . esc_attr($raw_price_num) . '" data-product="' . esc_attr($wceventer_ticket_id) . '" data-eventer="' . $event_id . '" data-multi="' . esc_attr($multi_state) . '"  data-edate="' . $event_cdate . '" data-eventerurl="' . esc_url(eventer_generate_endpoint_url('edate', $eventer_formatted_date, get_permalink($event_id))) . '" data-etime="' . date_i18n(get_option('time_format'), strtotime($time_slot)) . '" data-allday="' . esc_attr($allday) . '"  data-ticketname="' . $ticket_name . '">';
        }

        $remaining_tickets_data = '<i class="eventer-ticket-remaining" data-tickets="' . $ticket_number . '">' . $ticket_number . ' ' . esc_html__('remaining', 'eventer') . '</i>';
        if ($aviable_tickets === 'yes') {
            $remaining_tickets_data = '';
        }

        $remaining_tickets = ($ticket_number <= 0)
            ? '<i class="eventer-ticket-remaining eventer-ticket-full">' . esc_html__('All Booked', 'eventer') . '</i>'
            : $remaining_tickets_data;

        if ($ticket_number > 0) {
            $remaining_for_reg = 1;
        }

        if (date_i18n('U') < strtotime($close_booking_time)) {
            echo '<div class="eventer-wc-ticket-table"><div>
                    <div class="eventer-wc-ticket-col"><span class="eventer-ticket-type-name">' . $ticket_name . ' ' . $remaining_tickets . '</span></div>
                    <div class="eventer-wc-ticket-col eventer-flex-justify-end eventer-px-10"><span class="eventer-wc-ticket-price eventer-ticket-type-price">' . $ticket_price . '</span></div>';

            if ($remaining_for_reg == 1 && $bookingClsoed != 1) {
                if ($ticket_enabled_message == '') {
                    echo '<div class="eventer-wc-ticket-col"><select class="eventer-wc-ticket-quantity">';
                    for ($start = 1; $start <= $remain_for_booking; $start++) {
                        echo '<option value="' . $start . '">' . $start . '</option>';
                    }
                    echo '</select></div>';

                    echo '<div class="eventer-wc-ticket-col">
                            <div class="eventer-wc-addtocart"><input type="button" class="eventer-btn add-ticket-wc" value="' . esc_attr($btn_txt) . '">
                                <!-- <span class="eventer-wc-ticket-total"></span> -->
                                <span class="eventer-wc-ticket-added"></span></div></div>';
                }
            }

            echo '</div>' . $ticket_enabled_message . '</div>';
        } else {
            esc_html_e('Sorry, Event passed', 'eventer');
        }
        echo '</li>';
        }

      echo '</ul></div>';
    }
    if (get_post_type($event_id) == 'eventer') {
      ?>
      <a href="<?php echo esc_url($booking_url); ?>" target="<?php echo esc_attr($booking_url_target); ?>" class="eventer-btn eventer-btn-primary"><?php esc_html_e('View cart', 'eventer'); ?></a>
    <?php } ?>
  </div>
</div>

<?php
if (get_metadata('post', $event_id, 'eventer_time_slots_mandatory', true)):
	$mandatory_timeslot = get_post_meta($event_id, 'eventer_time_slots_mandatory', true);

	if ($mandatory_timeslot == 'on'):
?>
	<script type="text/javascript">
		jQuery(document).ready(function( $ ){
			function checkTimeSlot(event) {
				var $time = $("select.eventer-time-slot");
				if ( ! $time.length ) {
					return false;
				}

				var url = window.location.href;

				if ($time.val() === "00:00:00" && url.indexOf('checkout_show') === -1) {
					var url = $(event.currentTarget).attr("href");
					event.currentTarget.href = "#";
					event.stopPropagation();
					event.preventDefault();
					$time.addClass("eventer-required-field");
				}
			}

			$('.eventer.eventer-event-single .eventer-ticket-details-wrap a.eventer-btn.eventer-btn-primary, .eventer-btn.add-ticket-wc').on('click', function( e ) {
				checkTimeSlot(e);
			});
		});
	</script>
<?php
	else: ?>

	<?php
	endif;
else: ?>
	<script type="text/javascript">
		jQuery(document).ready(function( $ ){
			function checkTimeSlot(event) {
				var $time = $("select.eventer-time-slot");
				if ( ! $time.length ) {
					return false;
				}

				var url = window.location.href;

				if ($time.val() === "00:00:00" && single.mandatory_timeslot === "on" && url.indexOf('checkout_show') === -1) {
					var url = $(event.currentTarget).attr("href");
					event.currentTarget.href = "#";
					event.stopPropagation();
					event.preventDefault();
					$time.addClass("eventer-required-field");
				}
			}

			$('.eventer.eventer-event-single .eventer-ticket-details-wrap a.eventer-btn.eventer-btn-primary, .eventer-btn.add-ticket-wc').on('click', function( e ) {
				checkTimeSlot(e);
			});
		});
	</script>
<?php
endif; ?>