<?php
namespace UiCore\Settings;

defined('ABSPATH') || exit();

/**
 * Blog settings.
 *
 * @return array
 */

$category = _x('Blog', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'blog';

return [
    self::add_visual_select([
        'id' => 107,
        'index' => 'blog_layout',
        'adv' => false,
        'name' => _x('Layout', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the blog page and archive layout.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog layout', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'module' => 'frontend',
        'default' => 'grid',
        'options' => [
            [
                'name' => _x('Classic', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'classic',
                'icon' => '/img/blog-classic.svg',
            ],
            [
                'name' => _x('Grid', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'grid',
                'icon' => '/img/blog-grid.svg',
            ],
            [
                'name' => _x('Horizontal', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'horizontal',
                'icon' => '/img/blog-horizontal.svg',
            ],
            [
                'name' => _x('Masonry', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'masonry',
                'icon' => '/img/blog-masonry.svg',
            ],
        ],
        'visible' => true,
    ]),
    self::add_select([
        'id' => 108,
        'index' => 'blog_col',
        'adv' => true,
        'name' => _x('Grid Columns', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the number of columns for blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid columns', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '3',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('1', 'Admin - Theme Options', 'uicore-framework'),
                'value' => '1'
            ],
            [
                'name' => _x('2', 'Admin - Theme Options', 'uicore-framework'),
                'value' => '2'
            ],
            [
                'name' => _x('3', 'Admin - Theme Options', 'uicore-framework'),
                'value' => '3'
            ],
            [
                'name' => _x('4', 'Admin - Theme Options', 'uicore-framework'),
                'value' => '4'
            ]
        ],
        'size' => 's',
    ]),
    self::add_select([
        'id' => 109,
        'index' => 'blog_col_space',
        'adv' => true,
        'name' => _x('Grid Items Spacing', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item spacing for blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid item spacing', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'large',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Extra large', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'extra large'
            ],
            [
                'name' => _x('Large', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'large'
            ],
            [
                'name' => _x('Medium', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'medium'
            ],
            [
                'name' => _x('Small', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'small'
            ],
            [
                'name' => _x('Extra small', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'extra small'
            ],
            [
                'name' => _x('None', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'none'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 245,
        'index' => 'blog_item_style',
        'adv' => true,
        'name' => _x('Item Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the grid item style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog grid item style', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'simple',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Simple', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'simple'
            ],
            [
                'name' => _x('Boxed', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'boxed'
            ],
            [
                'name' => _x('Boxed Creative', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'boxed creative'
            ],
            [
                'name' => _x('Cover', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'cover'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 110,
        'index' => 'blog_hover_effect',
        'adv' => true,
        'name' => _x('Item Hover Effect', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item hover effect for blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('item hover effect', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'zoom',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('None', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'none'
            ],
            [
                'name' => _x('Zoom', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'zoom'
            ],
            [
                'name' => _x('Float', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'float'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 111,
        'index' => 'blog_ratio',
        'adv' => true,
        'name' => _x('Image Ratio', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item image ratio for blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('item image ratio', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'landscape',
        'visible' => ['blog_layout' => 'classic'],
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Square', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'square'
            ],
            [
                'name' => _x('Landscape', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'landscape'
            ],
            [
                'name' => _x('Portrait', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'portrait'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_input([
        'id' => 112,
        'index' => 'blog_img_radius',
        'adv' => true,
        'name' => _x('Image Border Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item image border radius for blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('item image border radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '6',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
    ]),
    self::add_typography([
        'id' => 113,
        'index' => 'blog_title',
        'adv' => true,
        'name' => _x('Post Title Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the text options for post title in blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('post title', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => '18',
                't' => '18',
                'm' => '16',
            ],
            'h' => '1.44',
            'ls' => '0',
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'module' => 'admin',
        'hover' => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => false,
        'color' => true,
    ]),
    self::add_toggle([
        'id' => 114,
        'index' => 'blog_excerpt',
        'adv' => true,
        'name' => _x('Show Excerpt on Blog Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable / disable excerpt in blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('post excerpt', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 115,
        'index' => 'blog_excerpt_length',
        'adv' => true,
        'name' => _x('Excerpt Length', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the excerpt length (number of words) in blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('post excerpt length', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '22',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 2,
        'max' => 300,
        'suffix' => '',
    ]),
    self::add_typography([
        'id' => 116,
        'index' => 'blog_ex',
        'adv' => true,
        'name' => _x('Post Excerpt Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the post excerpt options for blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('post excerpt style', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            'f' => 'Text',
            's' => [
                'd' => '14',
                't' => '13',
                'm' => '13',
            ],
            'h' => '1.57',
            'ls' => '0',
            't' => 'None',
            'st' => 'regular',
            'c' => 'Headline',
        ],
        'visible' => true,
        'module' => 'admin',
        'hover' => false,
        'family' => true,
        'line_height' => false,
        'responsive' => true,
        'full_responsive' => false,
        'color' => true,
    ]),
    self::add_toggle([
        'id' => 117,
        'index' => 'blog_author',
        'adv' => true,
        'name' => _x('Show Author on Blog Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide author name in blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('author', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'front',
    ]),
    self::add_toggle([
        'id' => 118,
        'index' => 'blog_date',
        'adv' => true,
        'name' => _x('Show Date on Blog Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide post date in blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('date', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 119,
        'index' => 'blog_category',
        'adv' => true,
        'name' => _x('Show Category on Blog Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide post category in blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('category', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 349,
        'index' => 'blog_readtime',
        'adv' => true,
        'name' => _x('Show Read Time on Blog Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide read time in blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog grid readtime', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 120,
        'index' => 'blog_padding',
        'adv' => true,
        'name' => _x('Vertical Padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the top/bottom spacing on blog page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog vertical padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            'd' => '100',
            't' => '75',
            'm' => '45',
        ],
        'visible' => true,
        'module' => 'admin',
        'responsive' => true,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 1000,
        'suffix' => 'px',
    ]),
    self::add_input([
        'id' => 121,
        'index' => 'blog_posts_number',
        'adv' => true,
        'name' => _x('Blog Items on Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the number of posts displayed on a page.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog items', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '12',
        'module' => 'frontend',
        'responsive' => false,
        'size' => 's',
        'accept' => 'number',
        'min' => 2,
        'suffix' => '',
        'max' => 300,
        'visible' => true,
    ]),
    self::add_select([
        'id' => 229,
        'index' => 'animations_blog',
        'adv' => false,
        'name' => _x('Entrance Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation style for blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'none',
        'visible' => true,
        'module' => 'admin',
        'options' => [
            [
                'name' => _x('None', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'none'
            ],
            [
                'name' => _x('Fade', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fade'
            ],
            [
                'name' => _x('Fade Down', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fade down'
            ],
            [
                'name' => _x('Fade Up', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fade up'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 230,
        'index' => 'animations_blog_duration',
        'adv' => false,
        'name' => _x('Animation Duration', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation speed.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation duration', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'normal',
        'visible' => true,
        'module' => 'admin',
        'options' => [
            [
                'name' => _x('Slow', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'slow'
            ],
            [
                'name' => _x('Normal', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'normal'
            ],
            [
                'name' => _x('Fast', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fast'
            ]
        ],
        'size' => 's',
    ]),
    self::add_input([
        'id' => 231,
        'index' => 'animations_blog_delay_child',
        'adv' => false,
        'name' => _x('Delay Between Elements', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation delay between elements inside the blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation delay elements', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '200',
        'visible' => true,
        'module' => 'admin',
        'accept' => 'number',
        'responsive' => false,
        'size' => 's',
        'min' => 0,
        'max' => 5000,
        'suffix' => 'ms',
    ]),
    self::add_select([
        'id' => 122,
        'index' => 'blog_sidebar',
        'adv' => true,
        'name' => _x('Blog Page Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar for blog page and archive.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'left',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('None', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'none'
            ],
            [
                'name' => _x('Blog Post', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Blog Post'
            ],
            [
                'name' => _x('Blog Archive', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Blog Archive'
            ],
            [
                'name' => _x('Portfolio Post', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Portfolio Post'
            ],
            [
                'name' => _x('Portfolio Archive', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Portfolio Archive'
            ],
            [
                'name' => _x('WooCommerce Shop', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'WooCommerce Shop'
            ],
            [
                'name' => _x('WooCommerce Product', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'WooCommerce Product'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 123,
        'index' => 'blog_sidebar_position',
        'adv' => true,
        'name' => _x('Blog Page Sidebar Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar position for blog page and archive.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('sidebar position', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'left',
        'visible' => [
            '!blog_sidebar' => 'none'
        ],
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Right', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'right'
            ],
            [
                'name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'left'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_toggle([
        'id' => 124,
        'index' => 'blog_sidebars',
        'adv' => true,
        'name' => _x('Blog Page Sticky Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar to sticky on page scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('sticky sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 366,
        'index' => 'blog_filters',
        'adv' => true,
        'name' => _x('Show Filters', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the filters in the blog grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog grid filters', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 421,
        'index' => 'blog_filters_child',
        'adv' => true,
        'name' => _x('Categories Display', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Display only parent categories or all categories', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog grid filters child parent', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'all',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Parent Categories', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'parent'
            ],
            [
                'name' => _x('All Categories', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'all'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 367,
        'index' => 'blog_filters_align',
        'adv' => true,
        'name' => _x('Filters Alignment', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the filters alignment.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog grid filters alignment', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'left',
        'visible' => 366,
        'module' => 'admin',
        'options' => [
            [
                'name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'left'
            ],
            [
                'name' => _x('Center', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'center'
            ]
        ],
        'size' => 'm',
    ]),
    self::add_input([
        'id' => 368,
        'index' => 'blog_filters_all_text',
        'adv' => true,
        'name' => _x('All Categories Text', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the text for the "All Categories" filter.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog grid filters all categories text', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'All Categories',
        'responsive' => false,
        'visible' => 366,
        'accept' => 'text',
        'module' => 'frontend',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 125,
        'index' => 'blogs_title',
        'adv' => true,
        'name' => _x('Blog Post Page Title', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the blog post title layout. Default page title is set in Theme Options - Page Title.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('page title', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'default page title',
        'visible' => true,
        'module' => 'frontend',
        'size' => 'm',
        'options' => [
            [
                'name' => _x('Default Page Title', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'default page title'
            ],
            [
                'name' => _x('Simple Page Title', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'simple page title'
            ],
            [
                'name' => _x('Simple Creative', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'simple creative'
            ],
            [
                'name' => _x('Full Screen', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'full screen'
            ]
        ],
    ]),
    self::add_toggle([
        'id' => 302,
        'index' => 'blogs_breadcrumb',
        'adv' => true,
        'name' => _x('Show Breadcrumbs', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Display the breadcrumbs just before the post title.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog page title breadcrumb', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => [
            'blogs_title' => 'simple page title'
        ],
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 126,
        'index' => 'blogs_img',
        'adv' => true,
        'name' => _x('Blog Post Featured Image', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide the post featured image below the post title.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('featured image', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => [
            'blogs_title' => 'simple page title'
        ],
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 127,
        'index' => 'blogs_pagetitle_width',
        'adv' => true,
        'name' => _x('Show Post Meta', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide post meta (author, date, category, etc.) on single post.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('post meta', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '75',
        'accept' => 'number',
        'responsive' => false,
        'size' => 's',
        'min' => 200,
        'max' => 100,
        'suffix' => '%',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 373,
        'adv' => true,
        'type' => 'toggle',
        'index' => 'blogs_excerpt_in_pt',
        'module' => 'frontend',
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'name' => _x('Show Excerpt in Page Title', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the excerpt in the page title.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog page title excerpt', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'default' => 'true',
        'visible' => [
            'in_array(blogs_title)' => ['full screen', 'default page title']
        ],
    ]),
    self::add_toggle([
        'id' => 128,
        'index' => 'blogs_author',
        'adv' => true,
        'name' => _x('Show Author on Blog Post', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide author name on blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('author', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 129,
        'index' => 'blogs_date',
        'name' => _x('Show Date on Blog Post', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide date on blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('date', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 197,
        'index' => 'blogs_date_type',
        'name' => _x('Date Type', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Choose the date display type.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('date type', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => 129,
        'visible' => 129,
        'adv' => true,
        'default' => 'published',
        'options' => [
            [
                'name' => _x('Published', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'published'
            ],
            [
                'name' => _x('Updated', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'updated'
            ],
            [
                'name' => _x('Both', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'both'
            ]
        ],
        'size' => 'm',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 130,
        'index' => 'blogs_category',
        'name' => _x('Show Category on Blog Post', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide category on blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('category', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 350,
        'index' => 'blogs_readtime',
        'name' => _x('Show Read Time on Blog Post', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide read time in title meta.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog meta read time', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 131,
        'index' => 'blogs_tags',
        'name' => _x('Show Tags on Blog Post', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide tags on blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('tags', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 303,
        'index' => 'blogs_author_box',
        'name' => _x('Author Box', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add the author info at the end of the post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog post author box info', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 304,
        'index' => 'blogs_author_style',
        'name' => _x('Author Box Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the author box style.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog post author box style', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 303,
        'visible' => 303,
        'adv' => true,
        'default' => 'simple',
        'options' => [
            [
                'name' => _x('Simple', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'simple'
            ],
            [
                'name' => _x('Boxed', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'boxed'
            ]
        ],
        'size' => 'm',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 246,
        'index' => 'blogs_navigation',
        'name' => _x('Post Navigation', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable next / previous navigation at the end of the post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog post navigation', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 343,
        'index' => 'blogs_loop_navigation',
        'name' => _x('Loop Posts', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('If this is active the navigation will not reach to an end', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog navigation loop', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 132,
        'visible' => 246,
        'adv' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 305,
        'index' => 'blogs_related',
        'name' => _x('Related Posts', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show related posts at the end of the post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog post related', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 303,
        'visible' => true,
        'adv' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 306,
        'index' => 'blogs_related_filter',
        'name' => _x('Related Posts Filter', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show related posts based on:', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog post related filter', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 303,
        'visible' => 305,
        'adv' => true,
        'default' => 'random',
        'options' => [
            [
                'name' => _x('Random', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'random'
            ],
            [
                'name' => _x('Category', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'category'
            ],
            [
                'name' => _x('Tag', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'tag'
            ]
        ],
        'size' => 'm',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 307,
        'index' => 'blogs_related_style',
        'name' => _x('Related Posts Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the related posts display style.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog post related style', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 303,
        'visible' => 305,
        'adv' => true,
        'default' => 'list',
        'options' => [
            [
                'name' => _x('List', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'list'
            ],
            [
                'name' => _x('Grid', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'grid'
            ]
        ],
        'size' => 'm',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 132,
        'index' => 'blogs_narrow',
        'name' => _x('Narrow Post Width', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the post container width to 65% of default container width. Only applied on desktop screens.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('narrow width', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 330,
        'index' => 'blogs_wide_align',
        'name' => _x('Wide Images Outer Offset', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set overflow offset for wide align images: 0-10.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog wide image offset', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => '2',
        'min' => 0,
        'max' => 10,
        'size' => 's',
        'accept' => 'number',
        'module' => 'admin',
        'responsive' => false,
        'suffix' => '',
    ]),
    self::add_toggle([
        'id' => 133,
        'index' => 'blogs_progress',
        'name' => _x('Reading Progress', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show a reading progress bar below the header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('reading progress', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 134,
        'index' => 'blogs_sidebar_id',
        'name' => _x('Blog Post Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'default' => 'none',
        'options' => [
            [
                'name' => _x('None', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'none'
            ],
            [
                'name' => _x('Blog Post', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Blog Post'
            ],
            [
                'name' => _x('Blog Archive', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Blog Archive'
            ],
            [
                'name' => _x('Portfolio Post', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Portfolio Post'
            ],
            [
                'name' => _x('Portfolio Archive', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'Portfolio Archive'
            ],
            [
                'name' => _x('WooCommerce Shop', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'WooCommerce Shop'
            ],
            [
                'name' => _x('WooCommerce Product', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'WooCommerce Product'
            ]
        ],
        'size' => 'm',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 135,
        'index' => 'blogs_sidebar',
        'name' => _x('Blog Post Sidebar Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar position for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('sidebar position', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => 134,
        'visible' => true,
        'adv' => false,
        'default' => 'left',
        'options' => [
            [
                'name' => _x('Right', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'right'
            ],
            [
                'name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'left'
            ]
        ],
        'size' => 'm',
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 136,
        'index' => 'blogs_sidebars',
        'name' => _x('Blog Post Sticky Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar to sticky on page scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('sticky sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => 134,
        'visible' => true,
        'adv' => false,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_typography([
        'id' => 137,
        'index' => 'blog_h1',
        'name' => _x('Post H1 Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the H1 typography for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog h1', 'Admin - Theme Options Search', 'uicore-framework'),
        'adv' => true,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '72', 'unit' => 'px'],
                't' => ['value' => '48', 'unit' => 'px'],
                'm' => ['value' => '34', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.2', 'unit' => 'em'],
                't' => ['value' => '1.2', 'unit' => 'em'],
                'm' => ['value' => '1.2', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.027', 'unit' => 'em'],
                't' => ['value' => '-0.027', 'unit' => 'em'],
                'm' => ['value' => '-0.027', 'unit' => 'em'],
            ],
            't' => 'none',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'hover' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => true,
        'color' => true,
        'line_height' => true,
        'module' => 'admin',
    ]),
    self::add_typography([
        'id' => 138,
        'index' => 'blog_h2',
        'name' => _x('Post H2 Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the H2 typography for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog h2', 'Admin - Theme Options Search', 'uicore-framework'),
        'adv' => true,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '40', 'unit' => 'px'],
                't' => ['value' => '34', 'unit' => 'px'],
                'm' => ['value' => '26', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.2', 'unit' => 'em'],
                't' => ['value' => '1.2', 'unit' => 'em'],
                'm' => ['value' => '1.2', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '-0.027', 'unit' => 'em'],
                't' => ['value' => '-0.027', 'unit' => 'em'],
                'm' => ['value' => '-0.027', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'hover' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => true,
        'color' => true,
        'line_height' => true,
        'module' => 'admin',
    ]),
    self::add_typography([
        'id' => 139,
        'index' => 'blog_h3',
        'name' => _x('Post H3 Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the H3 typography for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog h3', 'Admin - Theme Options Search', 'uicore-framework'),
        'adv' => true,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '34', 'unit' => 'px'],
                't' => ['value' => '26', 'unit' => 'px'],
                'm' => ['value' => '20', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.25', 'unit' => 'em'],
                't' => ['value' => '1.25', 'unit' => 'em'],
                'm' => ['value' => '1.25', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '0', 'unit' => 'em'],
                't' => ['value' => '0', 'unit' => 'em'],
                'm' => ['value' => '0', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'hover' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => true,
        'color' => true,
        'line_height' => true,
        'module' => 'admin',
    ]),
    self::add_typography([
        'id' => 140,
        'index' => 'blog_h4',
        'name' => _x('Post H4 Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the H4 typography for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog h4', 'Admin - Theme Options Search', 'uicore-framework'),
        'adv' => true,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '20', 'unit' => 'px'],
                't' => ['value' => '18', 'unit' => 'px'],
                'm' => ['value' => '16', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.1', 'unit' => 'em'],
                't' => ['value' => '1.1', 'unit' => 'em'],
                'm' => ['value' => '1.1', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '0', 'unit' => 'em'],
                't' => ['value' => '0', 'unit' => 'em'],
                'm' => ['value' => '0', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'hover' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => true,
        'color' => true,
        'line_height' => true,
        'module' => 'admin',
    ]),
    self::add_typography([
        'id' => 141,
        'index' => 'blog_h5',
        'name' => _x('Post H5 Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the H5 typography for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog h5', 'Admin - Theme Options Search', 'uicore-framework'),
        'adv' => true,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => ['value' => '16', 'unit' => 'px'],
                't' => ['value' => '15', 'unit' => 'px'],
                'm' => ['value' => '14', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.1', 'unit' => 'em'],
                't' => ['value' => '1.1', 'unit' => 'em'],
                'm' => ['value' => '1.1', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '0', 'unit' => 'em'],
                't' => ['value' => '0', 'unit' => 'em'],
                'm' => ['value' => '0', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'hover' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => true,
        'color' => true,
        'line_height' => true,
        'module' => 'admin',
    ]),
    self::add_typography([
        'id' => 142,
        'index' => 'blog_h6',
        'name' => _x('Post H6 Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the H6 typography for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('blog h6', 'Admin - Theme Options Search', 'uicore-framework'),
        'adv' => true,
        'default' => [
            'f' => 'Text',
            's' => [
                'd' => ['value' => '14', 'unit' => 'px'],
                't' => ['value' => '13', 'unit' => 'px'],
                'm' => ['value' => '12', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.1', 'unit' => 'em'],
                't' => ['value' => '1.1', 'unit' => 'em'],
                'm' => ['value' => '1.1', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '0', 'unit' => 'em'],
                't' => ['value' => '0', 'unit' => 'em'],
                'm' => ['value' => '0', 'unit' => 'em'],
            ],
            't' => 'Uppercase',
            'st' => 'regular',
            'c' => 'Headline',
        ],
        'visible' => true,
        'hover' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => true,
        'color' => true,
        'line_height' => true,
        'module' => 'admin',
    ]),
    self::add_typography([
        'id' => 143,
        'index' => 'blog_p',
        'name' => _x('Post Paragraph Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the paragraph typography for blog post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog paragraph', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'adv' => true,
        'default' => [
            'f' => 'Text',
            's' => [
                'd' => ['value' => '16', 'unit' => 'px'],
                't' => ['value' => '18', 'unit' => 'px'],
                'm' => ['value' => '16', 'unit' => 'px'],
            ],
            'h' => [
                'd' => ['value' => '1.875', 'unit' => 'em'],
                't' => ['value' => '1.875', 'unit' => 'em'],
                'm' => ['value' => '1.875', 'unit' => 'em'],
            ],
            'ls' => [
                'd' => ['value' => '0', 'unit' => 'em'],
                't' => ['value' => '0', 'unit' => 'em'],
                'm' => ['value' => '0', 'unit' => 'em'],
            ],
            't' => 'None',
            'st' => 'regular',
            'c' => 'Body',
        ],
        'visible' => true,
        'hover' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => true,
        'color' => true,
        'line_height' => true,
        'module' => 'admin',
    ]),
    self::add_color2([
        'id' => 327,
        'index' => 'blog_link_color',
        'name' => _x('Post Links Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the post links color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('post blog link color', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'adv' => true,
        'visible' => true,
        'default' =>[
            'm' => 'Primary',
            'h' => 'Secondary',
        ],
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 365,
        'index' => 'blogs_styles_tb',
        'name' => _x('Use Styles in ThemeBuilder', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Use blog styles in ThemeBuilder widgets.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Blog', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('blog themebuilder styles', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'adv' => true,
        'visible' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
];