<?php
namespace UiCore\Settings;

defined('ABSPATH') || exit();

/**
 * Footer settings.
 *
 * @return array
 */

$category = _x('Footer', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'footer';

return [
    self::add_toggle([
        'id' => 999, // couldnt find any ID
        'index' => 'footer',
        'adv' => true,
        'name' => _x('Enable Footer', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable / disable footer sitewide.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('enable footer', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_visual_select([
        'id' => 79,
        'index' => 'footer_layout',
        'adv' => true,
        'name' => _x('Footer: Layout', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the base layout for footer.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer layout', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => null,
        'visible' => true,
        'module' => 'frontend',
        'default' => 'five',
        'options' => [
            [
                'name'  => _x('One', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'one',
                'icon'  => '/img/footer-one-column.svg',
            ],
            [
                'name'  => _x('Two', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'two',
                'icon'  => '/img/footer-two-columns.svg',
            ],
            [
                'name'  => _x('Two Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'two_left',
                'icon'  => '/img/footer-two-columns-left.svg',
            ],
            [
                'name'  => _x('Two Right', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'two_right',
                'icon'  => '/img/footer-two-columns-right.svg',
            ],
            [
                'name'  => _x('Three', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'three',
                'icon'  => '/img/footer-three-columns.svg',
            ],
            [
                'name'  => _x('Three Center', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'three_center',
                'icon'  => '/img/footer-three-columns-center.svg',
            ],
            [
                'name'  => _x('Three Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'three_left',
                'icon'  => '/img/footer-three-columns-left.svg',
            ],
            [
                'name'  => _x('Three Right', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'three_right',
                'icon'  => '/img/footer-three-columns-right.svg',
            ],
            [
                'name'  => _x('Four', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'four',
                'icon'  => '/img/footer-four-columns.svg',
            ],
            [
                'name'  => _x('Four Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'four_left',
                'icon'  => '/img/footer-four-columns-left.svg',
            ],
            [
                'name'  => _x('Four Right', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'four_right',
                'icon'  => '/img/footer-four-columns-right.svg',
            ],
            [
                'name'  => _x('Four Left 2', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'four_left_2',
                'icon'  => '/img/footer-four-columns-left-2.svg',
            ],
            [
                'name'  => _x('Four Right 2', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'four_right_2',
                'icon'  => '/img/footer-four-columns-right-2.svg',
            ],
            [
                'name'  => _x('Five', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'five',
                'icon'  => '/img/footer-five-columns.svg',
            ],
            [
                'name'  => _x('Five Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'five_left',
                'icon'  => '/img/footer-five-columns-left.svg',
            ],
            [
                'name'  => _x('Five Right', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'five_right',
                'icon'  => '/img/footer-five-columns-right.svg',
            ],
        ],
    ]),
    self::add_background([
        'id' => 80,
        'index' => 'footer_bg',
        'adv' => true,
        'name' => _x('Footer Background', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the footer background.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer background', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [
            'type' => 'Dark Neutral',
            'solid' => 'Dark Neutral',
            'gradient' => [
                'angle' => '90',
                'color1' => '#19187C',
                'color2' => '#532df5',
            ],
            'image' => [
                'url' => '',
                'attachment' => 'fixed',
                'position' => [
                    'd' => 'center center',
                    't' => 'center center',
                    'm' => 'center center',
                ],
                'repeat' => 'no-repeat',
                'size' => [
                    'd' => 'cover',
                    't' => 'cover',
                    'm' => 'contain',
                ],
            ],
        ],
        'visible' => true,
        'module' => 'admin',
        'blur' => false,
    ]),
    self::add_input([
        'id' => 81,
        'index' => 'footer_padding',
        'adv' => true,
        'name' => _x('Footer Padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set top/bottom spacing for footer bar.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [
            'd' => '80',
            't' => '50',
            'm' => '30',
        ],
        'visible' => true,
        'module' => 'admin',
        'responsive' => true,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 500,
        'suffix' => 'px',
    ]),
    self::add_typography([
        'id' => 82,
        'index' => 'footer_title',
        'adv' => true,
        'name' => _x('Footer Title Font', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the font for footer titles.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer title font', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [
            's' => [
                'd' => '16',
                't' => '15',
                'm' => '14',
            ],
            'h' => '1.2',
            'ls' => '0',
            't' => 'None',
            'st' => '600',
            'c' => '#FFFFFF',
            'f' => 'Primary',
        ],
        'visible' => true,
        'module' => 'admin',
        'hover' => false,
        'family' => true,
        'line_height' => false,
        'responsive' => true,
        'full_responsive' => false,
        'color' => true,
    ]),
    self::add_typography([
        'id' => 83,
        'index' => 'footer_text',
        'adv' => true,
        'name' => _x('Footer Text Font', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the font for footer text.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer text font', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [],
        'visible' => true,
        'module' => 'admin',
        'hover' => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => false,
        'color' => true,
    ]),
    self::add_color2([
        'id' => 84,
        'index' => 'footer_link',
        'adv' => true,
        'name' => _x('Footer Link Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the color for footer links.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer link color', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [
            'm' => 'Body',
            'h' => 'Primary',
        ],
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 85,
        'index' => 'footer_wide',
        'adv' => true,
        'name' => _x('Footer Wide', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the footer to full width.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer wide', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 86,
        'index' => 'copyrights',
        'adv' => false,
        'name' => _x('Enable Copyright', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable copyright bar below the footer.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('enable copyright', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'frontend',
        'default' => 'true',
    ]),
    self::add_editor([
        'id' => 998, // couldnt find any ID
        'index' => 'copyrights_content',
        'adv' => false,
        'module' => 'frontend',
        'name' => _x('Copyrights Content', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the content for the copyrights area.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights content', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => '<p>&copy; <a href="https://www.uicore.co/" target="_blank" rel="noopener">UiCore</a> [year]. All Rights Reserved.</p>',
        'visible' => [
            'copyrights' => 'true',
        ],
    ]),
    self::add_color([
        'id' => 87,
        'index' => 'copyrights_bg',
        'adv' => true,
        'name' => _x('Copyrights Background', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the background color for the copyrights area.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights background', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'Dark Neutral',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 88,
        'index' => 'copyrights_border',
        'adv' => true,
        'name' => _x('Copyrights Border', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a border to the copyrights area.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights border', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'true',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 89,
        'index' => 'copyrights_borderc',
        'adv' => true,
        'name' => _x('Copyrights Border Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the border color for the copyrights area.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights border color', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'rgba(255, 255, 255, 0.2)',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 90,
        'index' => 'copyrights_border_whide',
        'adv' => true,
        'name' => _x('Copyrights Border White', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show border as white.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights border white', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_input([
        'id' => 91,
        'index' => 'copyrights_padding',
        'adv' => true,
        'name' => _x('Copyrights Padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set top/bottom spacing for copyrights area.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [
            'd' => '40',
            't' => '40',
            'm' => '30',
        ],
        'visible' => true,
        'module' => 'admin',
        'responsive' => true,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 500,
        'suffix' => 'px',
    ]),
    self::add_color([
        'id' => 92,
        'index' => 'copyrights_text',
        'adv' => true,
        'name' => _x('Copyrights Text Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the copyright text color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights text color', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'Body',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_input([
        'id' => 93,
        'index' => 'copyrights_texts',
        'adv' => true,
        'name' => _x('Copyrights Text Size', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the copyright font size.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights text size', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [
            'd' => '16',
            't' => '16',
            'm' => '16',
        ],
        'visible' => true,
        'module' => 'admin',
        'responsive' => true,
        'accept' => 'number',
        'size' => 's',
        'min' => 10,
        'max' => 130,
        'suffix' => 'px',
    ]),
    self::add_color2([
        'id' => 94,
        'index' => 'copyrights_link',
        'adv' => true,
        'name' => _x('Copyrights Link Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the color for copyrights links.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights link color', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => [
            'm' => '#FFFFFF',
            'h' => 'Primary',
        ],
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 95,
        'index' => 'copyrights_icons',
        'adv' => true,
        'name' => _x('Copyrights Icons', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show social icons in the copyrights area.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('copyrights icons', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 225,
        'index' => 'animations_footer',
        'adv' => true,
        'name' => _x('Entrance Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'none',
        'visible' => true,
        'module' => 'admin',
        'options' => [
            [
                'name'  => _x('None', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'none',
            ],
            [
                'name'  => _x('Fade', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fade',
            ],
            [
                'name'  => _x('Fade Down', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fade down',
            ],
            [
                'name'  => _x('Fade Up', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fade up',
            ],
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 226,
        'index' => 'animations_footer_duration',
        'adv' => true,
        'name' => _x('Footer Animation Duration', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation duration for the footer.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer animation duration', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => 'normal',
        'visible' => true,
        'module' => 'admin',
        'options' => [
            [
                'name'  => _x('Slow', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'slow',
            ],
            [
                'name'  => _x('Normal', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'normal',
            ],
            [
                'name'  => _x('Fast', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'fast',
            ],
        ],
        'size' => 's',
    ]),
    self::add_input([
        'id' => 227,
        'index' => 'animations_footer_delay',
        'adv' => true,
        'name' => _x('Footer Animation Delay', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation delay for the footer.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer animation delay', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => '0',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 5000,
        'suffix' => 'ms',
    ]),
    self::add_input([
        'id' => 228,
        'index' => 'animations_footer_delay_child',
        'adv' => true,
        'name' => _x('Footer Animation Child Delay', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation delay for each child in the footer.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('footer animation child delay', 'Admin - Theme Options Search', 'uicore-framework'),
        'default' => '200',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 5000,
        'suffix' => 'ms',
    ]),
];

